/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#include "ww_data.h"


static void ww_data_base_init (gpointer g_class);


GType
ww_data_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwDataInterface),
			ww_data_base_init,	/* base_init */
			NULL,				/* base_finalize */
			NULL,				/* class_init */
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			0,
			0,					/* n_preallocs */
			NULL				/* instance_init */
		};

		type = g_type_register_static (G_TYPE_INTERFACE, "WwData", &info, 0);

		/*
		   g_print ("ww_object_get_type\n");
		 */
	}

	return type;
}

static void
ww_data_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

/********************************************************************/

void
ww_data_set_attribute (WwData * self, const gchar ** name, const gchar ** value)
{
	WW_DATA_GET_INTERFACE (self)->set_attribute (self, name, value);
}

void
ww_data_set_element (WwData * self, const gchar * element0, const gchar * element1, const gchar * value)
{
	WW_DATA_GET_INTERFACE (self)->set_element (self, element0, element1, value);
}

void
ww_data_set_parent (WwData * self, WwData * parent)
{
	WW_DATA_GET_INTERFACE (self)->set_parent (self, parent);
}

void
ww_data_set_child (WwData * self, WwData * child)
{
	WW_DATA_GET_INTERFACE (self)->set_child (self, child);
}
