/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <gtk/gtk.h>
#include <gtk/gtkgl.h>

#include "ww_meshloader.h"
#include "mmapthread.h"
#include "mmap.h"
#include "disk.h"

typedef struct _WwMeshloaderPrivate WwMeshloaderPrivate;
struct _WwMeshloaderPrivate {
	gboolean dispose_has_run;

	gint nx;
	gint ny;

	gdouble west;
	gdouble east;
	gdouble south;
	gdouble north;

	gdouble above_surface;

	WwTerrainaccessor *ta;

	WwMesh *mesh;
};

#define WW_MESHLOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_MESHLOADER, WwMeshloaderPrivate))

static GObjectClass *parent_class = NULL;

static void ww_meshloader_class_init (WwMeshloaderClass * klass);
static void ww_meshloader_init (WwMeshloader * object);
static void ww_meshloader_finalize (GObject * object);
static void ww_meshloader_dispose (GObject * object);
static GObject *ww_meshloader_constructor (GType type, guint n_props, GObjectConstructParam * props);

/*****************************************************************************/

GType
ww_meshloader_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwMeshloaderClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_meshloader_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwMeshloader),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_meshloader_init
		};

		type = g_type_register_static (G_TYPE_OBJECT, "WwMeshloader", &info, 0);
	}

	return type;
}

static void
ww_meshloader_class_init (WwMeshloaderClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	/*
	   g_print ("ww_meshloader_class_init:c:%p:\n", klass);
	 */
	g_type_class_add_private (klass, sizeof (WwMeshloaderPrivate));

	parent_class = g_type_class_peek_parent (klass);
	object_class->constructor = ww_meshloader_constructor;
	object_class->finalize = ww_meshloader_finalize;
	object_class->dispose = ww_meshloader_dispose;

}

static void
ww_meshloader_init (WwMeshloader * self)
{
	WwMeshloaderPrivate *priv = WW_MESHLOADER_GET_PRIVATE (self);
	/*
	   g_print ("ww_meshloader_init:o:%p:\n", self);
	 */

	priv->dispose_has_run = FALSE;

	priv->nx = 0;
	priv->ny = 0;
	priv->west = 0.0;
	priv->east = 0.0;
	priv->south = 0.0;
	priv->north = 0.0;
	priv->above_surface = 0.0;
	priv->ta = NULL;
	priv->mesh = NULL;
}

static void
ww_meshloader_dispose (GObject * obj)
{
	WwMeshloader *self = WW_MESHLOADER (obj);
	WwMeshloaderPrivate *priv = WW_MESHLOADER_GET_PRIVATE (self);
	/*
	   g_print ("ww_meshloader_dispose\n");
	 */

	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;

	if (priv->ta != NULL) {
		g_object_unref (priv->ta);
		priv->ta = NULL;
	}
	if (priv->mesh != NULL) {
		g_object_unref (priv->mesh);
		priv->mesh = NULL;
	}

	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void
ww_meshloader_finalize (GObject * obj)
{
	/*
	   WwMeshloader *self = WW_MESHLOADER (obj);
	   WwMeshloaderPrivate *priv = WW_MESHLOADER_GET_PRIVATE (self);
	 */
	/*
	   g_print ("ww_meshloader_finalize\n");
	 */

	/*
	   g_free(***);
	 */
	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static GObject *
ww_meshloader_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);
	/*
	   g_print ("ww_meshloader_constructor\n");
	 */
	object = object_class->constructor (type, n_props, props);

	return object;
}

WwMeshloader *
ww_meshloader_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_MESHLOADER, NULL);
	/*
	   g_print ("ww_meshloader_new:o:%p\n", object);
	 */
	return WW_MESHLOADER (object);
}

/********************************************************************/

static void
meshloader_download_to_data (GObject * obj)
{
	WwMeshloader *loader = WW_MESHLOADER (obj);
	WwMeshloaderPrivate *priv = WW_MESHLOADER_GET_PRIVATE (loader);

	ww_terrainaccessor_read_data (priv->ta, priv->west, priv->south, priv->east, priv->north, priv->nx, priv->ny);

	priv->mesh =
		ww_mesh_new_with_terrain (priv->west, priv->south, priv->east, priv->north, priv->nx, priv->ny, priv->above_surface,
								  priv->ta);

	glarea_force_update ();
}

static void
meshloader_download (GObject * obj)
{
	WwMeshloader *loader = WW_MESHLOADER (obj);
	WwMeshloaderPrivate *priv = WW_MESHLOADER_GET_PRIVATE (loader);
	/*
	   g_print("meshloader_donwload\n");
	 */

	ww_terrainaccessor_data_prepare (priv->ta, priv->west, priv->south, priv->east, priv->north, priv->nx, priv->ny);

	mmapthread_add_power (meshloader_download_to_data, obj);
}

/**********************************/

void
ww_meshloader_set_source (WwMeshloader * loader, gint nx, gint ny,
						  gdouble x0, gdouble y0, gdouble x1, gdouble y1, gdouble above_surface, WwTerrainaccessor * ta)
{
	WwMeshloaderPrivate *priv;

	priv = WW_MESHLOADER_GET_PRIVATE (loader);
	priv->nx = nx;
	priv->ny = ny;
	priv->west = x0;
	priv->east = x1;
	priv->south = y0;
	priv->north = y1;
	priv->above_surface = above_surface;
	priv->ta = ta;
	g_object_ref (ta);
	priv->mesh = NULL;
}

void
ww_meshloader_start (WwMeshloader * loader)
{
	WwMeshloaderPrivate *priv;
	const gchar *url;

	priv = WW_MESHLOADER_GET_PRIVATE (loader);


	url = ww_terrainaccessor_get_server_url (priv->ta);

	mmapthread_add_download2 (url, meshloader_download, (GObject *) loader);
}

void
ww_meshloader_set_mesh (WwMeshloader * loader, WwMesh * mesh)
{
	WwMeshloaderPrivate *priv;

	priv = WW_MESHLOADER_GET_PRIVATE (loader);

	priv->mesh = mesh;
}

WwMesh *
ww_meshloader_get_mesh (WwMeshloader * loader)
{
	WwMeshloaderPrivate *priv;

	priv = WW_MESHLOADER_GET_PRIVATE (loader);

	return priv->mesh;
}
