/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_MESHLOADER_H__
#define __WW_MESHLOADER_H__

#include <gtk/gtk.h>

#include "ww_mesh.h"

G_BEGIN_DECLS
#define WW_TYPE_MESHLOADER                (ww_meshloader_get_type ())
#define WW_MESHLOADER(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_MESHLOADER, WwMeshloader))
#define WW_MESHLOADER_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_MESHLOADER, WwMeshloaderClass))
#define WW_IS_MESHLOADER(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_MESHLOADER))
#define WW_IS_MESHLOADER_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_MESHLOADER))
#define WW_MESHLOADER_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_MESHLOADER, WwMeshloaderClass))
typedef struct _WwMeshloader WwMeshloader;
typedef struct _WwMeshloaderClass WwMeshloaderClass;

struct _WwMeshloader {
	GObject parent;
};

struct _WwMeshloaderClass {
	GObjectClass parent_class;
};

GType ww_meshloader_get_type (void);

WwMeshloader *ww_meshloader_new (void);
void ww_meshloader_set_source (WwMeshloader * loader, gint nx, gint ny,
							   gdouble x0, gdouble y0, gdouble x1, gdouble y1, gdouble above_surface, WwTerrainaccessor * ta);
void ww_meshloader_start (WwMeshloader * loader);

void ww_meshloader_set_mesh (WwMeshloader * loader, WwMesh * mesh);
WwMesh *ww_meshloader_get_mesh (WwMeshloader * loader);

G_END_DECLS
#endif /* __WW_MESHLOADER_H__ */
