/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*
#define DB(x) (x)
*/
#define DB(x)


#include "config.h"

#include "ww_object.h"
#include "util.h"
#include "layermanager.h"
#include "mmapconfig.h"

typedef struct _WwObjectPrivate WwObjectPrivate;
struct _WwObjectPrivate {
	gboolean dispose_has_run;
};

#define WW_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_OBJECT, WwObjectPrivate))

static GObjectClass *parent_class = NULL;

static void ww_object_class_init (WwObjectClass * klass);
static void ww_object_init (WwObject * object);
static void ww_object_finalize (GObject * object);
static void ww_object_dispose (GObject * object);
static GObject *ww_object_constructor (GType type, guint n_props, GObjectConstructParam * props);
static void ww_object_interface_init (gpointer g_iface, gpointer iface_data);

/*****************************************************************************/

static void ww_object_set_attribute (WwData * data, const gchar ** name, const gchar ** value);
static void ww_object_set_element (WwData * data, const gchar * element0, const gchar * element1, const gchar * value);
static void ww_object_set_parent (WwData * data, WwData * parent);
static void ww_object_set_child (WwData * data, WwData * child);

static void ww_object_set_on_real (WwObject * self, gboolean is_on);
static void ww_objcet_update_unimplemented (WwObject * obj);
static void ww_objcet_render_unimplemented (WwObject * obj);
static void ww_object_debug_print_real (WwObject * self);
static void ww_object_set_layermanager_menu_real (WwObject * obj, GtkTreeIter * iter_parent);

/*****************************************************************************/

GType
ww_object_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwObjectClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_object_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwObject),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_object_init
		};

		static const GInterfaceInfo ww_data_info = {
			(GInterfaceInitFunc) ww_object_interface_init,	/* interface_init */
			NULL,				/* interface_finalize */
			NULL				/* interface_data */
		};

		/*
		   type = g_type_register_static (G_TYPE_OBJECT, "WwObject", &info, G_TYPE_FLAG_ABSTRACT);
		 */
		type = g_type_register_static (G_TYPE_OBJECT, "WwObject", &info, 0);

		g_type_add_interface_static (type, WW_TYPE_DATA, &ww_data_info);
	}

	return type;
}

static void
ww_object_class_init (WwObjectClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	/*
	   g_print ("ww_object_class_init:c:%p:\n", klass);
	 */
	g_type_class_add_private (klass, sizeof (WwObjectPrivate));

	parent_class = g_type_class_peek_parent (klass);
	/*
	   object_class->constructor = ww_object_constructor;
	 */
	object_class->finalize = ww_object_finalize;
	object_class->dispose = ww_object_dispose;

	klass->set_on = ww_object_set_on_real;
	klass->debug_print = ww_object_debug_print_real;
	klass->update = ww_objcet_update_unimplemented;
	klass->render = ww_objcet_render_unimplemented;
	klass->set_layermanager_menu = ww_object_set_layermanager_menu_real;
}

static void
ww_object_init (WwObject * self)
{
	WwObjectPrivate *priv = WW_OBJECT_GET_PRIVATE (self);
	/*
	   g_print ("ww_object_init:o:%p:\n", self);
	 */
	priv->dispose_has_run = FALSE;

	self->wwparent = NULL;
	self->is_on = FALSE;
	self->name = NULL;
	self->extended_information_abstract = NULL;
	self->extended_information_tool_bar_image = NULL;
	self->show_at_startup = FALSE;
}
static void
ww_object_dispose (GObject * obj)
{
	WwObject *self = WW_OBJECT (obj);
	WwObjectPrivate *priv = WW_OBJECT_GET_PRIVATE (self);
	/*
	   g_print ("dispose\n");
	 */
	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;

	g_object_unref (self->wwparent);

	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void
ww_object_finalize (GObject * obj)
{
	WwObject *self = WW_OBJECT (obj);
	/*
	   WwObjectPrivate *priv = WW_OBJECT_GET_PRIVATE(self);
	 */

	/*
	   g_print ("finalize\n");
	 */
	g_free (self->name);
	g_free (self->extended_information_abstract);
	g_free (self->extended_information_tool_bar_image);

	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static GObject *
ww_object_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);

	/*
	   g_print ("ww_object_constructor\n");
	 */

	object = object_class->constructor (type, n_props, props);

	return object;
}

static void
ww_object_interface_init (gpointer g_iface, gpointer iface_data)
{
	WwDataInterface *iface = (WwDataInterface *) g_iface;
	iface->set_attribute = ww_object_set_attribute;
	iface->set_element = ww_object_set_element;
	iface->set_parent = ww_object_set_parent;
	iface->set_child = ww_object_set_child;
}

WwObject *
ww_object_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_OBJECT, NULL);

	/*
	   g_print ("ww_object_new:o:%p\n", object);
	 */

	return WW_OBJECT (object);
}

/********************************************************************/

static void
ww_object_set_attribute (WwData * data, const gchar ** name, const gchar ** value)
{
	WwObject *obj = WW_OBJECT (data);
	gint i;
	/*
	   g_print("ww_object_set_attribute:o:%p\n", obj);
	 */
	for (i = 0; name[i] != NULL; ++i) {
		DB (g_print ("ww_object_set_attribute:name:%s: value:%s:\n", name[i], value[i]));

		if (g_ascii_strcasecmp (name[i], "ShowAtStartup") == 0) {
			obj->show_at_startup = util_char_to_boolean (value[i]);
			obj->is_on = obj->show_at_startup;
		} else {
			;
		}
	}
}

static void
ww_object_set_element (WwData * data, const gchar * element0, const gchar * element1, const gchar * value)
{
	WwObject *obj = WW_OBJECT (data);
	/*
	   g_print("ww_object_set_element:o:%p  e0:%s e1:%s value:%s\n", obj, element0, element1, value);
	 */
	if (g_ascii_strcasecmp (element0, "Name") == 0) {
		obj->name = g_strdup (value);

	} else if (g_ascii_strcasecmp (element0, "Abstract") == 0) {
		obj->extended_information_abstract = g_strdup (value);

	} else if (g_ascii_strcasecmp (element0, "ToolBarImage") == 0) {
		obj->extended_information_tool_bar_image = g_strdup (value);

	} else {
		;
	}
}

static void
ww_object_set_parent (WwData * data, WwData * parent)
{
	WwObject *obj = WW_OBJECT (data);
	WwObject *obj_parent = WW_OBJECT (parent);

	obj->wwparent = obj_parent;
	g_object_ref (obj_parent);
}

static void
ww_object_set_child (WwData * data, WwData * child)
{
	/* ここには、こないはず */
}

static void
ww_object_debug_print_real (WwObject * obj)
{
	g_print ("ww_object_debug_print ########## :o:%p\n", obj);

	g_print ("\t wwparent:%p\n", obj->wwparent);
	if (obj->wwparent != NULL) {
		g_print ("\t parent:name:%s\n", obj->wwparent->name);
	}
	util_print_bool ("\t is_on:", obj->is_on);
	g_print ("\t name:%s\n", obj->name);
	g_print ("\t extended_information_abstract:%s\n", obj->extended_information_abstract);
	g_print ("\t extended_information_tool_bar_image:%s\n", obj->extended_information_tool_bar_image);
	util_print_bool ("\t show_at_startup:", obj->show_at_startup);
}

void
ww_object_debug_print (WwObject * obj)
{
	WW_OBJECT_GET_CLASS (obj)->debug_print (obj);
}

static void
ww_objcet_update_unimplemented (WwObject * obj)
{
	g_print ("WwObjectClass::update not implemented for `%s'\n", g_type_name (G_TYPE_FROM_INSTANCE (obj)));
}

static void
ww_objcet_render_unimplemented (WwObject * obj)
{
	g_print ("WwObjectClass::render not implemented for `%s'\n", g_type_name (G_TYPE_FROM_INSTANCE (obj)));
}

void
ww_object_update (WwObject * obj)
{
	g_return_if_fail (obj != NULL);

	WW_OBJECT_GET_CLASS (obj)->update (obj);
}

void
ww_object_render (WwObject * obj)
{
	g_return_if_fail (obj != NULL);

	WW_OBJECT_GET_CLASS (obj)->render (obj);
}

static void
ww_object_set_on_real (WwObject * obj, gboolean is_on)
{
	mmap_config_set_bool (obj->name, is_on);

	obj->is_on = is_on;
}

void
ww_object_set_on (WwObject * obj, gboolean is_on)
{
	WW_OBJECT_GET_CLASS (obj)->set_on (obj, is_on);
}

gboolean
ww_object_get_on (WwObject * obj)
{
	return obj->is_on;
}

/* quadtile の保存先が ~/.mmap/Cache/Earth/Blue*** となり LayerSet 名の Images が入ってない。
 * 不自然な気もするが、抜くことにする。 
 */

gchar *
ww_object_get_path (WwObject * self)
{
	gchar *parent_path;
	gchar *path = NULL;
	WwObject *parent = self->wwparent;

	if (parent == NULL) {
		/* ここで抜いている 
		   path = g_strdup_printf ("%s/", self->name);
		 */
	} else {
		parent_path = ww_object_get_path (parent);
		if (parent_path == NULL) {
			path = g_strdup_printf ("%s/", self->name);
		} else {
			path = g_strdup_printf ("%s%s/", parent_path, self->name);

			g_free (parent_path);
		}
	}

	return path;
}

static void
ww_object_set_layermanager_menu_real (WwObject * obj, GtkTreeIter * iter_parent)
{
	GtkTreeIter iter;
	gboolean is_on = FALSE;
	gboolean exist = FALSE;
	/*
	   g_print ("ww_object_set_layermanager_menu_real:o:%p\n", obj);
	 */

	is_on = mmap_config_get_bool (obj->name, &exist);
	if (exist == TRUE) {
		obj->is_on = is_on;
	} else {
		mmap_config_set_bool (obj->name, obj->is_on);
	}

	layermanager_append (&iter, iter_parent);
	layermanager_set_item (&iter, obj->is_on, obj->name, obj);
}

void
ww_object_set_layermanager_menu (WwObject * obj, GtkTreeIter * iter_parent)
{
	WW_OBJECT_GET_CLASS (obj)->set_layermanager_menu (obj, iter_parent);
}
