/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __GSI_H__
#define __GSI_H__

#include <gtk/gtk.h>


#define W_SECOND 225
#define H_SECOND 150
/* 地図のサイズ(単位:pixel) */
#define H_PIXEL 2000
/* 地図の重なりのサイズ(単位：秒)*/
#define MARGIN  18
/* 地図の右下不要部分のサイズ(単位:pixel) */
#define W_GREEN 180
#define H_GREEN 50

/***********/

#include "nmapdata_all.h"

typedef struct {
	gchar id[3];
	gchar *name;
	gchar *value;
} Data25k;

const gchar *gsi25k_get_data (const gchar * text, Data25k * data25k);
gfloat *gsi25k_get_curve (const gchar * text, Slp * slp, gint * return_n);
guint8 gsi25k_hex_to_int (const gchar * text);
gboolean gsi25k_compare_id(Data25k *data25k, gchar id[]);

/************ 以下はメモ ************/
/*
 * 最北端：択捉島    北緯45度33分
 * 最南端：沖ノ鳥島  北緯20度25分
 * 最東端：南鳥島    東経153度59分
 * 最西端：与那国島  東経122度56分
 */
#endif /* __GSI_H__ */
