/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
#define DB(x) (x)
*/
#define DB(x)

#include <gtk/gtk.h>

#include "ww_object.h"
#include "glarea.h"

enum {
	LAYER_VISIBLE,
	LAYER_NAME,
	LAYER_WWOBJECT,
	N_COLUMNS
};

static GtkWidget *treeview;

/*************************/

void
layermanager_expand_all (void)
{
	gtk_tree_view_expand_all (GTK_TREE_VIEW (treeview));
}

void
layermanager_append (GtkTreeIter * iter, GtkTreeIter * iter_parent)
{
	GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (treeview));
	GtkTreeStore *store = GTK_TREE_STORE (model);

	gtk_tree_store_append (store, iter, iter_parent);
}

void
layermanager_set_item (GtkTreeIter * iter, gboolean is_on, const gchar * name, WwObject * obj)
{
	GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (treeview));
	GtkTreeStore *store = GTK_TREE_STORE (model);

	gtk_tree_store_set (store, iter, LAYER_VISIBLE, is_on, LAYER_NAME, name, LAYER_WWOBJECT, obj, -1);
}

void
layermanager_clear (void)
{
	GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (treeview));

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(treeview));
	gtk_tree_store_clear (GTK_TREE_STORE (model));
}


/*************************/

static void
all_check (GtkTreePath * path)
{
	GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (treeview));
	GtkTreePath *p = path;
	GtkTreeIter iter;

	/* 同じレベルの先頭へ */
	while (gtk_tree_path_prev (p) == TRUE) {
		;
	}

	if (gtk_tree_model_get_iter (model, &iter, p) == FALSE) {
		g_print ("wrong path\n");
	}

	do {
		WwObject *obj;
		gboolean is_on;

		gtk_tree_model_get (model, &iter, LAYER_WWOBJECT, &obj, -1);

		is_on = ww_object_get_on (obj);

		gtk_tree_store_set (GTK_TREE_STORE (model), &iter, LAYER_VISIBLE, is_on, -1);

	} while (gtk_tree_model_iter_next (model, &iter) == TRUE);
}

static void
checkbox_toggled_cb (GtkCellRendererToggle * renderer, gchar * path_str, gpointer user_data)
{
	GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (treeview));
	GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
	GtkTreeIter iter;
	gboolean is_on;
	WwObject *obj;

	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, LAYER_VISIBLE, &is_on, -1);
	gtk_tree_model_get (model, &iter, LAYER_WWOBJECT, &obj, -1);

	if (is_on == TRUE) {
		is_on = FALSE;
	} else {
		is_on = TRUE;
	}

	g_print ("checkbox_toggled_cb:%s:\n", obj->name);

	/* layer の is_on を変更すると layer 側で show_only_one_layer を反映してくれる */
	ww_object_set_on (obj, is_on);
	/* 反映された結果を layermanager 側に反映させる */
	all_check (path);

	gtk_tree_path_free (path);

	glarea_force_update_and_render ();
}

GtkWidget *
layermanager_create (void)
{
	GtkWidget *scroll;
	GtkTreeStore *store;

	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer_check;
	GtkCellRenderer *renderer_text;

	store = gtk_tree_store_new (N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_POINTER);
	treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
	g_object_unref (G_OBJECT (store));

	gtk_widget_set_size_request (treeview, 200, -1);

	gtk_tree_view_expand_all (GTK_TREE_VIEW (treeview));

	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), TRUE);

	renderer_check = gtk_cell_renderer_toggle_new ();
	g_signal_connect (renderer_check, "toggled", G_CALLBACK (checkbox_toggled_cb), NULL);
	renderer_text = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (column, "Layer");
	gtk_tree_view_column_pack_start (column, renderer_check, FALSE);
	gtk_tree_view_column_pack_start (column, renderer_text, FALSE);
	gtk_tree_view_column_set_attributes (column, renderer_check, "active", LAYER_VISIBLE, NULL);
	gtk_tree_view_column_set_attributes (column, renderer_text, "text", LAYER_NAME, NULL);

	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (scroll), treeview);

	return scroll;
}
