/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
#define DB(x) (x)
*/
#define DB(x)

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#include "net.h"

typedef struct {
	gchar *data;
	size_t mem_size;
	size_t data_size;
} GetData;

#define NET_ALLOC_UNIT 100000

static size_t
write_memory_cb (void *ptr, size_t size, size_t nmemb, void *data)
{
	GetData *mem = (GetData *) data;
	size_t add_size = size * nmemb;
	size_t new_size;

	new_size = mem->data_size + add_size + 1;

	if (mem->data == NULL) {
		mem->data = (char *) malloc (NET_ALLOC_UNIT);
		mem->mem_size = NET_ALLOC_UNIT;
	} else if (new_size > mem->mem_size) {
		mem->data = (char *) realloc (mem->data, mem->mem_size + NET_ALLOC_UNIT);
		mem->mem_size += NET_ALLOC_UNIT;
	}

	DB (printf ("write_memory_cb:%p:\n", mem->data));
	memcpy (&(mem->data[mem->data_size]), ptr, add_size);
	mem->data_size += add_size;
	mem->data[mem->data_size] = 0;

	DB (printf ("write_memory_cb:%d:%d     add:%d\n", mem->mem_size, mem->data_size, add_size));

	return add_size;
}

/************************************/

CURL *
net_download_set (void)
{
	CURL *curl;

	curl = curl_easy_init ();

	return curl;
}

void *
net_download_get (CURL * curl, const gchar * uri, gint * return_bytes)
{
	GetData chunk = { NULL, 0, 0 };
	gint retval;
	gchar err[CURL_ERROR_SIZE];

	curl_easy_setopt (curl, CURLOPT_URL, uri);
	curl_easy_setopt (curl, CURLOPT_WRITEFUNCTION, write_memory_cb);
	curl_easy_setopt (curl, CURLOPT_WRITEDATA, (void *) &chunk);
	curl_easy_setopt (curl, CURLOPT_BUFFERSIZE, 10000);
	/* 302 対応 */
	curl_easy_setopt (curl, CURLOPT_AUTOREFERER, 1);
	curl_easy_setopt (curl, CURLOPT_FOLLOWLOCATION, 1);

	curl_easy_setopt (curl, CURLOPT_ERRORBUFFER, &err);
	curl_easy_setopt (curl, CURLOPT_FAILONERROR, 1);

	DB (curl_easy_setopt (curl, CURLOPT_VERBOSE, 1));

	retval = curl_easy_perform (curl);


	if (retval == 0) {
		*return_bytes = chunk.data_size;
		return chunk.data;

	} else {
		g_print ("error:net_download_get:retval %d: %s: size:%d %s\n", retval, err, chunk.data_size, uri);

		*return_bytes = 0;
		return NULL;
	}

}

void
net_download_cleanup (CURL * curl)
{
	curl_easy_cleanup (curl);
}

/************************************/

void *
net_download (const gchar * uri, gint * return_bytes)
{
	CURL *curl;
	gint bytes;
	void *data;

	DB (g_print ("net_download:%s\n", uri));

	curl = net_download_set ();
	data = net_download_get (curl, uri, &bytes);
	net_download_cleanup (curl);

	DB (g_print ("net_download:%d\n", chunk.data_size));

	*return_bytes = bytes;
	return data;
}

/************************************/

void
net_init (void)
{
	curl_global_init (CURL_GLOBAL_ALL);
}
