/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __NMAPDATA_ALL_H__
#define __NMAPDATA_ALL_H__

#include <gtk/gtk.h>

#include "text.h"

typedef struct {
    gfloat *v;
    gint n;
}Vertices;

Vertices * data_common_vertices_new(void);
void data_common_vertices_add(Vertices *vertices, gfloat *v, gint n);
void data_common_vertices_free(Vertices *vertices);

/* 描画対象をあらわす。
 * msmap では２種類
 * (1)線分
 * (2)文字（文字の位置に点を打つこともある）
 */

typedef struct {
    gfloat linewidth;
    gfloat color[3];
} LineType;

typedef struct _Lines Lines;

Lines * data_common_lines_new(gint n);
void data_common_lines_add(Lines *lines, gint n, gint first, gint count);
void data_common_lines_free(Lines *lines);
void data_common_lines_draw(Lines *lines, Vertices *vertices, LineType *linetype);

typedef struct {
	GArray *index;    
    GPtrArray *pixtext;
}Text;

Text * data_common_text_new(void);
void data_common_text_add(Text *text, guint16 index, PixText *pixtext);
void data_common_text_free(Text *text);
void data_common_text_free_pixtext(Text *text);
void data_common_text_draw_text(Text *text, Vertices *vertices);
void data_common_text_draw_points(Text *text, Vertices *vertices, gfloat *color);

GIOChannel * data_common_channel_open(const gchar *name, const gchar *type);

/*****************************/

typedef struct {
	gdouble x;					/* 基準点の経度(秒) */
	gdouble y;					/* 基準点の緯度(秒) */

	gdouble nx;					/* 経度方向の範囲(秒) */
	gdouble ny;					/* 緯度方向の範囲(秒) */

	gint n_slp;					/* 座標のデータ数(標高点以外) */
	gint n_mhslp;				/* 座標のデータ数(標高点のみ) */
} Slm;

Slm *slm_create (const gchar * name);
void slm_free (Slm * slm);

/*****************************/

typedef struct {
	gint n;						/* データ数 */
	gfloat *v;					/* 国土地理院のインデックスは１から。MSMap では０から。 */
	/* v[3] が並んでいる */
} Slp;

Slp *slp_create (const gchar * name, gint n, gdouble x0, gdouble y0);
void slp_free (Slp * slp);

/*****************************/

/* 国土地理院の資料では、リンクと橋・トンネル・雪覆いの関係が、それぞれに対して多対多の
 * ように見えるが、データを見ると１対１のようなので、１対１として表現する。 */

typedef enum {
	NONE,						/* どれでもない */
	HA,							/* 橋 */
	TO,							/* トンネル */
	YO,							/* 雪覆い */
} HaToYo;

/*****************************/

typedef struct {
	guint8 sr;					/* 種類 */
	guint8 jt;					/* 状態 */
	gint first;
	gint count;
} Gksub;

typedef struct {
	GSList *sub;

	Vertices *vertices;
    Lines *lines;
} Gk;

void gk_state_change (Gk * gk);
void gk_draw (Gk * gk);
void gk_free (Gk * gk);
Gk *gk_create (const gchar * name, Slp * slp);

/*****************************/

typedef struct {
	guint8 sr;					/* 種類 */
	gint first;
	gint count;
} Sksub;

typedef struct {
	GSList *sub;

    Vertices *vertices;
    Lines *lines;
} Sk;

void sk_state_change (Sk * sk);
void sk_draw (Sk * sk);
void sk_free (Sk * sk);
Sk *sk_create (const gchar * name, Slp * slp);

/*****************************/

typedef struct {
	guint8 jt;					/* 状態 */
	guint8 yu;					/* 有料無料 */
	guint8 sb;					/* 種類 */
	guint8 fi;					/* 種類 */
	guint16 kb;					/* 国道番号 */
	/*
	   gchar *kb;   
	   PixText *pixtext;
	 */
	GSList *nm;
	HaToYo hatoyo;
	gint first;
	guint16 count;
} Dksub;

typedef struct {
	GSList *sub;
    Vertices *vertices;
    Lines *lines;
	/*
    Text *text;
	 */
} Dk;

void dk_state_change (Dk * dk);
void dk_draw (Dk * dk);
void dk_free (Dk * dk);
/*
void dk_add_text (Dk * dk);
void dk_del_text (Dk * dk);
*/
Dk *dk_create (const gchar * name, Slp * slp);

/*****************************/

typedef struct {
	guint8 sb;					/* 種類 */
	guint8 jt;					/* 状態 */
	gchar *er;					/* 駅 */
	PixText *pixtext;
	GSList *nm;
	HaToYo hatoyo;
	gint first;
	guint16 count;
} Tksub;

typedef struct {
	GSList *sub;

    Vertices *vertices;
    Lines *lines;
    Text *text;
} Tk;

void tk_state_change (Tk * tk);
void tk_draw (Tk * tk);
void tk_free (Tk * tk);
void tk_add_text (Tk * tk);
void tk_del_text (Tk * tk);

Tk *tk_create (const gchar * name, Slp * slp);

/*****************************/

gchar **ek_create (const gchar * name);

/*****************************/

typedef struct {
	guint8 sb;					/* 種類 */
	GSList *nm;
	HaToYo hatoyo;
	gint first;
	gint count;
} Kksub;

typedef struct {
	GSList *sub;
    Vertices *vertices;
    Lines *lines;
} Kk;

void kk_state_change (Kk * kk);
void kk_draw (Kk * kk);
void kk_free (Kk * kk);
Kk *kk_create (const gchar * name, Slp * slp);

/*****************************/

typedef struct {
	guint8 sr;					/* 種類 */
	/*  基準点の番号か「名称不明」しかなく、点名でないので不使用
	   GSList *nm;
	 */
	gchar *hk_char;
	PixText *pixtext;
	guint16 index;				/* 一つの市にある基準点の最大数は 549 */
} Kjsub;

typedef struct {
	GSList *sub;

    Vertices *vertices;
    Text *text;
} Kj;

void kj_state_change (Kj * kj);
void kj_draw (Kj * kj);
void kj_free (Kj * kj);
void kj_add_text (Kj * kj);
void kj_del_text (Kj * kj);
Kj *kj_create (const gchar * name, Slp * slp);

/*****************************/

typedef struct {
	guint8 sr;					/* 種類 */
	gchar *nm;					/* 名前(１行に１つしかないことを確認済) */
	gchar *js;
	PixText *pixtext;
	guint16 index;				/* １つの市にある公共施設の最大数は 497 個 */
} Kosub;

typedef struct {
	GSList *sub;

    Vertices *vertices;
    Text *text;
} Ko;

void ko_state_change (Ko * ko);
void ko_draw (Ko * ko);
void ko_free (Ko * ko);
void ko_add_text (Ko * ko);
void ko_del_text (Ko * ko);
Ko *ko_create (const gchar * name, Slp * slp);

/*****************************/

typedef struct {
	guint8 sr;					/* 種類 */
	gchar *nm;					/* 名前(１行に１つのみ。確認済。) */
	PixText *pixtext;
	guint16 index;				/* １つの市が持つ地名データの最大数は 1917 */
} Cmsub;

typedef struct {
	GSList *sub;

    Vertices *vertices;
    Text *text;
} Cm;

void cm_state_change (Cm * cm);
void cm_draw (Cm * cm);
void cm_free (Cm * cm);
void cm_add_text (Cm * cm);
void cm_del_text (Cm * cm);
Cm *cm_create (const gchar * name, Slp * slp);

/*****************************/

typedef struct {
	gint key;
	gint z;
} KeyVal;

typedef struct {
	gchar *name;			/* 例：11111 */

	/* 以下のいくつかのデータは Alt にも含まれるが、実際のデータから作りなおす。 */
	gdouble x0;					/* 左下の経度緯度(秒)(１の桁が偶数でない場合あり) */
	gdouble y0;
	gdouble x1;					/* 右上の経度緯度 */
	gdouble y1;

	KeyVal *keyval;

	GHashTable *hash;			/* 各データは KeyVal */

	gint ref_count;				/* このデータを必要としている地図の数 */
} Mh;

void mh_free (Mh * mh);
Mh * mh_create (const gchar * name, gdouble x0, gdouble y0);
gint mh_create_hash_key_from_lonlat (gint lon, gint lat);

/*****************************/

#endif  /* __NMAPDATA_ALL_H__ */
