/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <glib.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "disk.h"

GIOChannel *
disk_channel_open (const gchar * fullpath, IOType type)
{
	GIOChannel *ch = NULL;
	GIOStatus status;
	GError *err = NULL;
	const gchar *rw;


	if (type == READ) {
		rw = "r";
	} else if (type == WRITE) {
		rw = "w";
	} else {
		g_print ("error:IOType:%s:\n", fullpath);
		exit (-1);
	}

	ch = g_io_channel_new_file (fullpath, rw, &err);
	if (err != NULL) {
		g_print ("error:g_io_channel_new_file:%s:%s\n", fullpath, err->message);
		g_error_free (err);
		exit (-1);
	}

	status = g_io_channel_set_encoding (ch, NULL, &err);
	if (err != NULL) {
		g_print ("error:g_io_channel_set_encoding:%s:%s\n", fullpath, err->message);
		g_error_free (err);
		exit (-1);
	}

	return ch;
}

gint
disk_get_file_size (const gchar * fullpath)
{
	struct stat buf;
	gint size = 0;

	if (stat (fullpath, &buf) == 0) {
		size = buf.st_size;
	}

	return size;
}

/***** バイナリデータ用 ******/

void *
disk_bin_from_disk (const gchar * fullpath, gint * size)
{
	GIOChannel *ch = NULL;
	GError *err = NULL;
	void *data = NULL;

	ch = g_io_channel_new_file (fullpath, "r", &err);

	if (err != NULL) {
		g_print ("error:bin_from_disk:%s:%s\n", fullpath, err->message);

		data = NULL;
		*size = 0;
	} else {
		GIOStatus status;
		gsize buf_size;
		gsize data_size = 0;

		buf_size = (gsize)disk_get_file_size (fullpath);

		data = g_new (gchar, buf_size);

		g_io_channel_set_encoding (ch, NULL, &err);	/* バイナリーは NULL を指定 */
		g_io_channel_set_buffered (ch, FALSE);
		status = g_io_channel_read_chars (ch, data, buf_size, &data_size, &err);
		if (status == G_IO_STATUS_ERROR) {
			g_print ("error:bin_from_disk:%s:%s\n", fullpath, err->message);
		}

		*size = data_size;

		g_io_channel_unref (ch);
	}

	return data;
}

/*******************************************/

gboolean
disk_filetest (const gchar * fullpath)
{
	return g_file_test (fullpath, G_FILE_TEST_IS_REGULAR | G_FILE_TEST_EXISTS);
}
