/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */

#ifndef __WW_DATA_H__
#define __WW_DATA_H__

#include <glib-object.h>

G_BEGIN_DECLS
#define WW_TYPE_DATA                (ww_data_get_type ())
#define WW_DATA(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_DATA, WwData))
#define WW_IS_DATA(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_DATA))
#define WW_DATA_GET_INTERFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), WW_TYPE_DATA, WwDataInterface))
typedef struct _WwData WwData;	/* dummy object */
typedef struct _WwDataInterface WwDataInterface;

struct _WwDataInterface {
	GTypeInterface parent;

	void (*set_attribute) (WwData * self, const gchar ** name, const gchar ** value);
	void (*set_element) (WwData * self, const gchar * element0, const gchar * element1, const gchar * value);
	void (*set_parent) (WwData * self, WwData * parent);
	void (*set_child) (WwData * self, WwData * child);
};

GType ww_data_get_type (void);

void ww_data_set_attribute (WwData * self, const gchar ** name, const gchar ** value);
void ww_data_set_element (WwData * self, const gchar * element0, const gchar * element1, const gchar * value);
void ww_data_set_parent (WwData * self, WwData * parent);
void ww_data_set_child (WwData * self, WwData * child);

G_END_DECLS
#endif /* __WW_DATA_H__ */
