/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtk/gtkgl.h>

#include "ww_gsiloader.h"
#include "mmapthread.h"
#include "mmap.h"
#include "disk.h"
#include "glarea.h"
#include "ww_smap.h"
#include "nmapdata_all.h"

typedef struct _WwGsiloaderPrivate WwGsiloaderPrivate;

struct _WwGsiloaderPrivate {
	gboolean dispose_has_run;


    GObject *owner;     /* ダウンロードの依頼元 */
    GSList *sl_city;
};

#define WW_GSILOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_GSILOADER, WwGsiloaderPrivate))

static GObjectClass *parent_class = NULL;

static void ww_gsiloader_class_init (WwGsiloaderClass * klass);
static void ww_gsiloader_init (WwGsiloader * object);
static void ww_gsiloader_finalize (GObject * object);
static void ww_gsiloader_dispose (GObject * object);
static GObject *ww_gsiloader_constructor (GType type, guint n_props, GObjectConstructParam * props);

/*****************************************************************************/

GType
ww_gsiloader_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwGsiloaderClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_gsiloader_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwGsiloader),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_gsiloader_init
		};

		type = g_type_register_static (G_TYPE_OBJECT, "WwGsiloader", &info, 0);
	}

	return type;
}

static void
ww_gsiloader_class_init (WwGsiloaderClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	/*
	   g_print ("ww_gsiloader_class_init:c:%p:\n", klass);
	 */
	g_type_class_add_private (klass, sizeof (WwGsiloaderPrivate));

	parent_class = g_type_class_peek_parent (klass);
	object_class->constructor = ww_gsiloader_constructor;
	object_class->finalize = ww_gsiloader_finalize;
	object_class->dispose = ww_gsiloader_dispose;

}

static void
ww_gsiloader_init (WwGsiloader * self)
{
	WwGsiloaderPrivate *priv = WW_GSILOADER_GET_PRIVATE (self);
	/*
	   g_print ("ww_gsiloader_init:o:%p:\n", self);
	 */

	priv->dispose_has_run = FALSE;

	priv->sl_city = NULL;
}

static void
ww_gsiloader_dispose (GObject * obj)
{
	WwGsiloader *self = WW_GSILOADER (obj);
	WwGsiloaderPrivate *priv = WW_GSILOADER_GET_PRIVATE (self);
    /*
	g_print ("ww_gsiloader_dispose\n");
    */

	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;

    if(priv->owner != NULL){
        g_object_unref(priv->owner);
    }

	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void
ww_gsiloader_finalize (GObject * obj)
{
	WwGsiloader *self = WW_GSILOADER (obj);
	WwGsiloaderPrivate *priv = WW_GSILOADER_GET_PRIVATE (self);
	/*
	   g_print ("ww_gsiloader_finalize\n");
	 */

	g_slist_free(priv->sl_city);

	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static GObject *
ww_gsiloader_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);
	/*
	   g_print ("ww_gsiloader_constructor\n");
	 */
	object = object_class->constructor (type, n_props, props);

	return object;
}

WwGsiloader *
ww_gsiloader_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_GSILOADER, NULL);

	return WW_GSILOADER (object);
}

/********************************************************************/

static gboolean
gsi_filetest_all (const gchar * name, const gchar *dir)
{
	gchar *files[] = { ".slm", ".slp",
		"cm.sal", "ko.sal", "kj.sal",
		"dk.sal", "tk.sal", "kk.sal",
		"gk.sal", "sk.sal",
        "mh.sal", "mh.slp",
	};

	gint i;
	gint n;

	n = sizeof files / sizeof (gchar *);
	/*
	   g_print ("n:::%d\n", n);
	 */
	for (i = 0; i < n; ++i) {
		gchar *fullpath;
		gboolean result;

        fullpath = g_strconcat (dir, name, files[i], NULL);
		result = filetest (fullpath);
		g_free (fullpath);

		if (result == FALSE) {
			return FALSE;
		}
	}

	return TRUE;
}

static void
gsiloader_extract(GObject * obj)
{
	WwGsiloader *loader = WW_GSILOADER (obj);
	WwGsiloaderPrivate *priv = WW_GSILOADER_GET_PRIVATE (loader);
    GSList *sl;

    /*
	g_print("gsiloader_extract\n");
    */

    for(sl = priv->sl_city; sl != NULL; sl = sl->next){
        NCity *city = sl->data;
        gchar *lzh;

        lzh = g_strconcat (mmap_dir_gsi_vn, city->name, ".lzh", NULL);

	    if (gsi_filetest_all(city->name, mmap_dir_gsi_vn) == TRUE) {               /* 解凍済キャッシュがあった */
		    ;
	    } else if (filetest(lzh) == TRUE) {                 /* lzh キャッシュがあった */
            disk_lzh_extract (lzh, mmap_dir_gsi_vn);
	    }

        g_free(lzh);
    }

    /* 解凍まで完了 */

    if(WW_IS_SMAP(priv->owner) == TRUE){
        WwSmap *smap = WW_SMAP(priv->owner);

        for(sl = priv->sl_city; sl != NULL; sl = sl->next){
            NCity *city = sl->data;

            city_create_mh (city);
        }

	    ww_smap_vcn_calc (smap);

        for(sl = priv->sl_city; sl != NULL; sl = sl->next){
            NCity *city = sl->data;

            city_free_mh (city);
        }

    } else {
        /* ループしてるが、ここにくる時はいつも一つのはず */
        for(sl = priv->sl_city; sl != NULL; sl = sl->next){
            NCity *city = sl->data;

            city_create_other (city);
        }
    }

	glarea_force_update_and_render ();
}

static void
gsiloader_download (GObject * obj)
{
	WwGsiloader *loader = WW_GSILOADER (obj);
	WwGsiloaderPrivate *priv = WW_GSILOADER_GET_PRIVATE (loader);
    GSList *sl;

    /*
	g_print("gsiloader_download\n");
    */

    for(sl = priv->sl_city; sl != NULL; sl = sl->next){
        NCity *city = sl->data;
        gchar *lzh;

        lzh = g_strconcat (mmap_dir_gsi_vn, city->name, ".lzh", NULL);

	    if (gsi_filetest_all(city->name, mmap_dir_gsi_vn) == TRUE) {      /* 解凍済キャッシュがあった */
		    ;
	    } else if (filetest(lzh) == TRUE) {             /* lzh キャッシュがあった */
            ;
	    } else {                                        /* キャッシュがなかったのでネットから落して展開する */
		    const gchar *uri_l = "http://sdf.gsi.go.jp/data25k/";
		    gchar *uri;
		    void *data;
		    gint bytes;

		    uri = g_strconcat (uri_l, city->path, ".lzh", NULL);	/* aichi/11111 */

            data = mmapthread_download_get (uri, &bytes);
		    if (data == NULL) {
			    g_print ("error: get_lzh:net_download return NULL:%s\n", city->path);
			    exit (1);
		    }

            /*
		    g_print ("data:%s:%d\n", city->path, bytes);
            */

		    disk_save_bin (lzh, data, bytes);               /* キャッシュに入れとく */

		    g_free (data);
		    g_free (uri);
	    }

        g_free(lzh);
    }

	mmapthread_add_power (gsiloader_extract, obj);
}

/**********************************/

void
ww_gsiloader_set_owner (WwGsiloader * loader, GObject *owner)
{
	WwGsiloaderPrivate *priv;

    /*
    g_print("ww_gsiloader_set_owner:%p\n", owner);
    */

	priv = WW_GSILOADER_GET_PRIVATE (loader);
	priv->owner = owner;
    /* ものすごいその場しのぎ */
    if(priv->owner == NULL){
        ;
    }else if(WW_IS_SMAP(priv->owner) == TRUE){
        g_object_ref(owner);
    }
}

void
ww_gsiloader_add_source (WwGsiloader * loader, NCity *city)
{
	WwGsiloaderPrivate *priv;

	priv = WW_GSILOADER_GET_PRIVATE (loader);
	priv->sl_city = g_slist_prepend(priv->sl_city, city);
}

void
ww_gsiloader_add_source_list (WwGsiloader * loader, GSList *sl_city)
{
	WwGsiloaderPrivate *priv;

	priv = WW_GSILOADER_GET_PRIVATE (loader);
	priv->sl_city = g_slist_concat(priv->sl_city, sl_city);
}

void
ww_gsiloader_start (WwGsiloader * loader)
{
	WwGsiloaderPrivate *priv;
	const gchar *uri = "http://sdf.gsi.go.jp/data25k/";

	priv = WW_GSILOADER_GET_PRIVATE (loader);

	mmapthread_add_download2 (uri, gsiloader_download, (GObject *) loader);
}

