/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_MESHST_H__
#define __WW_MESHST_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS
#define WW_TYPE_MESHST               (ww_meshst_get_type ())
#define WW_MESHST(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_MESHST, WwMeshst))
#define WW_MESHST_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_MESHST, WwMeshstClass))
#define WW_IS_MESHST(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_MESHST))
#define WW_IS_MESHST_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_MESHST))
#define WW_MESHST_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_MESHST, WwMeshstClass))
typedef struct _WwMeshst WwMeshst;
typedef struct _WwMeshstClass WwMeshstClass;

struct _WwMeshst {
	GObject parent;
};

struct _WwMeshstClass {
	GObjectClass parent_class;
};

GType ww_meshst_get_type (void);

WwMeshst *ww_meshst_new_simple (gint nx, gint ny);
WwMeshst *ww_meshst_new_complex (gint nx, gint ny, gdouble px0, gdouble py0, gdouble px1, gdouble py1,
								 gdouble cx0, gdouble cy0, gdouble cx1, gdouble cy1);

void ww_meshst_change_simple (WwMeshst * st);
void ww_meshst_bind (WwMeshst * st);

G_END_DECLS
#endif /* __WW_MESHST_H__ */
