/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_TEXTURETILE_H__
#define __WW_TEXTURETILE_H__

#include "ww_texture.h"

G_BEGIN_DECLS
#define WW_TYPE_TEXTURETILE                (ww_texturetile_get_type ())
#define WW_TEXTURETILE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_TEXTURETILE, WwTexturetile))
#define WW_TEXTURETILE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_TEXTURETILE, WwTexturetileClass))
#define WW_IS_TEXTURETILE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_TEXTURETILE))
#define WW_IS_TEXTURETILE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_TEXTURETILE))
#define WW_TEXTURETILE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_TEXTURETILE, WwTexturetileClass))
typedef struct _WwTexturetile WwTexturetile;
typedef struct _WwTexturetileClass WwTexturetileClass;

struct _WwTexturetile {
	WwTexture parent;
};

struct _WwTexturetileClass {
	WwTextureClass parent_class;
};

GType ww_texturetile_get_type (void);

WwTexturetile *ww_texturetile_new (void);
void ww_texturetile_set_coordinate (WwTexturetile * texture, gdouble west, gdouble south, gdouble east, gdouble north);
void ww_texturetile_get_coordinate (WwTexturetile * texture, gdouble * west, gdouble * south, gdouble * east, gdouble * north);

G_END_DECLS
#endif /* __WW_TEXTURETILE_H__ */
