using UnityEngine;
using System.Collections;
using UnityEditor;

public class MotionCreateWindow : EditorWindow {
	
	GameObject prefab = null;
	string prefabName = "ScriptName";
	
	[MenuItem("Plugins/MMD Loader/Motion Create")]
	static void Init() {
		var window = (MotionCreateWindow)EditorWindow.GetWindow<MotionCreateWindow>(true, "MotionCreate");
		window.Show();
	}
	
	void OnGUI() {
		const int height = 16;
		
		prefab = (GameObject)EditorGUI.ObjectField(
			new Rect(0, 0, position.width-16, height), "PMD Prefab" ,prefab, typeof(GameObject));
		
		prefabName = EditorGUI.TextField(
			new Rect(0, 20, position.width-16, height), "Script Name", prefabName);
	}
}
