/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.motion.Motion;

public class VMD2CSV
extends JFrame {
    private File vmd = null;
    private File csv = null;
    private JButton buttonCSV2VMD;
    private JButton buttonVMD2CSV;
    private JMenuItem jMenuItem3;
    private JLabel labelCSVS;
    private JLabel labelVMDS;
    private JMenu menuAbout;
    private JMenuBar menuBar;
    private JMenuItem menuClose;
    private JMenu menuFile;
    private JMenuItem menuOpen;
    private JTextField textCSV;
    private JTextField textVMD;

    public VMD2CSV() {
        this.initComponents();
        this.setDropTarget(new HteDropTarget());
    }

    private void initComponents() {
        this.buttonCSV2VMD = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.labelVMDS = new JLabel();
        this.labelCSVS = new JLabel();
        this.buttonVMD2CSV = new JButton();
        this.textVMD = new JTextField();
        this.textCSV = new JTextField();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuOpen = new JMenuItem();
        this.menuClose = new JMenuItem();
        this.menuAbout = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("VMD2CSV");
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonCSV2VMD.setText("\u2191");
        this.buttonCSV2VMD.setEnabled(false);
        this.buttonCSV2VMD.setMinimumSize(new Dimension(45, 16));
        this.buttonCSV2VMD.setPreferredSize(new Dimension(45, 16));
        this.buttonCSV2VMD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VMD2CSV.this.buttonCSV2VMDActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.buttonCSV2VMD, gridBagConstraints);
        jLabel1.setText("VMD file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 10;
        this.getContentPane().add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("CSV file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        this.labelVMDS.setText("\u8aad\u307f\u8fbc\u307e\u308c\u3066\u307e\u305b\u3093");
        this.labelVMDS.setMaximumSize(new Dimension(30000, 30000));
        this.labelVMDS.setMinimumSize(new Dimension(140, 14));
        this.labelVMDS.setPreferredSize(new Dimension(140, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.labelVMDS, gridBagConstraints);
        this.labelCSVS.setText("\u8aad\u307f\u8fbc\u307e\u308c\u3066\u307e\u305b\u3093");
        this.labelCSVS.setMaximumSize(new Dimension(30000, 30000));
        this.labelCSVS.setMinimumSize(new Dimension(140, 14));
        this.labelCSVS.setPreferredSize(new Dimension(140, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.labelCSVS, gridBagConstraints);
        this.buttonVMD2CSV.setText("\u2193");
        this.buttonVMD2CSV.setEnabled(false);
        this.buttonVMD2CSV.setMinimumSize(new Dimension(45, 16));
        this.buttonVMD2CSV.setPreferredSize(new Dimension(45, 16));
        this.buttonVMD2CSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VMD2CSV.this.buttonVMD2CSVActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.buttonVMD2CSV, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.textVMD, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.textCSV, gridBagConstraints);
        this.menuFile.setText("File");
        this.menuOpen.setText("\u958b\u304f");
        this.menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VMD2CSV.this.menuOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuOpen);
        this.menuClose.setText("\u7d42\u4e86");
        this.menuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VMD2CSV.this.menuCloseActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuClose);
        this.menuBar.add(this.menuFile);
        this.menuAbout.setText("help");
        this.menuBar.add(Box.createHorizontalGlue());
        this.jMenuItem3.setText("about");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VMD2CSV.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.menuAbout.add(this.jMenuItem3);
        this.menuBar.add(this.menuAbout);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void buttonCSV2VMDActionPerformed(ActionEvent evt) {
        try {
            FileInputStream fis = new FileInputStream(this.csv);
            Motion m = new Motion().fromCSV(fis);
            fis.close();
            FileOutputStream os = new FileOutputStream(this.vmd);
            m.toVMD(os);
            os.close();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "I/O \u30a8\u30e9\u30fc", 0);
        }
        catch (MmdFormatException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "MMD \u30e2\u30fc\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u3058\u3083\u3042\u308a\u307e\u305b\u3093", 0);
        }
        this.renewInfo();
    }

    private void menuCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void open(File f) {
        String prename = f.getName();
        int i = prename.lastIndexOf(46);
        String ext = prename.substring(i + 1).toLowerCase();
        prename = prename.substring(0, i);
        if (ext.startsWith("vmd") && f.exists()) {
            this.vmd = f;
            this.csv = new File(f.getParentFile(), prename + ".csv");
        } else {
            this.csv = f;
            this.vmd = new File(f.getParentFile(), prename + ".vmd");
        }
        this.textVMD.setText(this.vmd.getName());
        this.textCSV.setText(this.csv.getName());
        this.renewInfo();
    }

    private void menuOpenActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("\u30e2\u30fc\u30b7\u30e7\u30f3\u3092\u958b\u304f");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD motion", "vmd", "csv"));
        if (jfc.showOpenDialog(this) != 0) {
            return;
        }
        File f = jfc.getSelectedFile();
        this.open(f);
    }

    private void buttonVMD2CSVActionPerformed(ActionEvent evt) {
        try {
            FileInputStream fis = new FileInputStream(this.vmd);
            Motion m = new Motion().fromVMD(fis);
            fis.close();
            FileOutputStream fos = new FileOutputStream(this.csv);
            m.toCSV(fos);
            fos.close();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "I/O \u30a8\u30e9\u30fc", 0);
        }
        catch (MmdFormatException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "VMD \u30e2\u30fc\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u3058\u3083\u3042\u308a\u307e\u305b\u3093", 0);
        }
        this.renewInfo();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        String version = "1.0";
        JOptionPane.showMessageDialog(this, "<html>VMD2CSV \u306f MMD\u30e2\u30fc\u30b7\u30e7\u30f3\u30c7\u30fc\u30bf VMD\u3068<br>VMDCSVConverter \u4e0a\u4f4d\u4e92\u63db\u306e CSV \u3068\u306e<br>\u76f8\u4e92\u5909\u63db\u3092\u3059\u308bJava\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u306eGUI\u3067\u3059\u3002<br>MMD Motion (jp.sourceforge.mmd.MMDMotion) http://sourceforge.jp/projects/mmdmotion-java/ Version: " + version + "<br>" + "Copyright 2015 by nazo, MIT License<br><br>" + "\u4f9d\u5b58\u6027: TogaGem (jp.sourceforge.mikutoga) http://sourceforge.jp/projects/mikutoga/ Version: 3.101.4-mod<br>" + "Copyright(c) 2010 olyutorskii, MIT License</html>", "VMD2CSV \u306b\u3064\u3044\u3066", 1);
    }

    protected void renewInfo() {
        String vmdM = "<html>";
        String csvM = "<html>";
        long vmdT = 0L;
        long csvT = 0L;
        DateFormat df = DateFormat.getDateTimeInstance(3, 1);
        if (this.vmd.exists()) {
            vmdT = this.vmd.lastModified();
            this.buttonVMD2CSV.setEnabled(true);
        } else {
            vmdM = vmdM + "\u5b58\u5728\u3057\u307e\u305b\u3093";
            this.buttonVMD2CSV.setEnabled(false);
        }
        if (this.csv.exists()) {
            this.csv.lastModified();
            csvT = this.csv.lastModified();
            if (vmdT > 0L) {
                if (vmdT > csvT) {
                    vmdM = vmdM + "<font color=red>\u65b0</font>: ";
                } else {
                    csvM = csvM + "<font color=red>\u65b0</font>: ";
                }
            }
            csvM = csvM + df.format(new Date(csvT));
            this.buttonCSV2VMD.setEnabled(true);
        } else {
            csvM = csvM + "\u5b58\u5728\u3057\u307e\u305b\u3093";
            this.buttonCSV2VMD.setEnabled(false);
        }
        if (vmdT > 0L) {
            vmdM = vmdM + df.format(new Date(vmdT));
        }
        this.labelVMDS.setText(vmdM + "</html>");
        this.labelCSVS.setText(csvM + "</html>");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Object filename = args[0];
            try {
                Motion m;
                FileInputStream fis = new FileInputStream(args[0]);
                if (((String)filename).toLowerCase().endsWith("vmd")) {
                    m = new Motion().fromVMD(fis);
                    fis.close();
                    m.toCSV(System.out);
                } else {
                    m = new Motion().fromCSV(fis);
                    fis.close();
                    filename = ((String)filename).substring(0, ((String)filename).lastIndexOf(46)) + ".vmd";
                    FileOutputStream fos = new FileOutputStream((String)filename);
                    m.toVMD(fos);
                    fos.close();
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (MmdFormatException ex) {
                Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.exit(0);
        }
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VMD2CSV().setVisible(true);
            }
        });
    }

    private class HteDropTarget
    extends DropTarget {
        private HteDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(0x40000000);
                try {
                    List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    File f = (File)list.get(0);
                    VMD2CSV.this.open(f);
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException ex) {
                    Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

