/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion;

import jp.sourceforge.mmd.motion.geo.Vector3D;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 *
 * @author nazo
 */
public class LightPose extends Pose{

    /**
     * rgb [0:1]
     */
    public float [] rgb;
    public Vector3D v;

    public LightPose(){
        super();
        nameOfBone="照明";
        this.rgb = new float[]{0.5f, 0.5f, 0.5f};
        v=new Vector3D(0,0,-1);
    }

    public LightPose(LightPose p){
        super(p);
        rgb=new float[3];
        rgb[0] = p.rgb[0];
        rgb[1] = p.rgb[1];
        rgb[2] = p.rgb[2];
        v=p.v.clone();
    }

    static public LightPose fromCSV(String line){
        String [] column=CsvSpliter.split(line);
        if(column.length<7)return null;
        LightPose p=new LightPose();

        p.frame=Integer.parseInt(column[0]);
        p.rgb=new float[]{
            Float.parseFloat(column[1]),
            Float.parseFloat(column[2]),
            Float.parseFloat(column[3])
        };
        p.v=new Vector3D(
            Double.parseDouble(column[4]),
            Double.parseDouble(column[5]),
            Double.parseDouble(column[6])
        );
        return p;
    }

    @Override
    public String toCSV() {
        return frame+","+rgb[0]+","+rgb[1]+","+rgb[2]+","+(v)+"\n";
    }

    @Override
    protected byte[] toVMD() {
        int i;
        byte [] a;
        ByteBuffer ret=ByteBuffer.allocate(28).order(ByteOrder.LITTLE_ENDIAN);
        ret.putInt(frame);
        ret.putFloat(rgb[0]);
        ret.putFloat(rgb[1]);
        ret.putFloat(rgb[2]);

        double []x=v.toDouble();
        ret.putFloat((float)x[0]);
        ret.putFloat((float)x[1]);
        ret.putFloat((float)x[2]);
        return ret.array();
    }

    @Override
    @SuppressWarnings({"CloneDoesntCallSuperClone", "CloneDeclaresCloneNotSupported"})
    public Pose clone() {
        return new LightPose(this);
    }
    
}
