/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.Box;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.mmd.motion.Motion;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;

/**
 * VMD,CSVを読み込んで反対側に書き込む JFrame.
 * @author nazo
 */
public class VMD2CSV extends javax.swing.JFrame {
    private File vmd=null;
    private File csv=null;

    /**
     * Creates new form VMD2CSV
     */
    public VMD2CSV() {
        initComponents();
        setDropTarget(new HteDropTarget());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonCSV2VMD = new javax.swing.JButton();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
        labelVMDS = new javax.swing.JLabel();
        labelCSVS = new javax.swing.JLabel();
        buttonVMD2CSV = new javax.swing.JButton();
        textVMD = new javax.swing.JTextField();
        textCSV = new javax.swing.JTextField();
        menuBar = new javax.swing.JMenuBar();
        menuFile = new javax.swing.JMenu();
        menuOpen = new javax.swing.JMenuItem();
        menuClose = new javax.swing.JMenuItem();
        menuAbout = new javax.swing.JMenu();
        jMenuItem3 = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("VMD2CSV");
        getContentPane().setLayout(new java.awt.GridBagLayout());

        buttonCSV2VMD.setText("↑");
        buttonCSV2VMD.setEnabled(false);
        buttonCSV2VMD.setMinimumSize(new java.awt.Dimension(45, 16));
        buttonCSV2VMD.setPreferredSize(new java.awt.Dimension(45, 16));
        buttonCSV2VMD.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonCSV2VMDActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        getContentPane().add(buttonCSV2VMD, gridBagConstraints);

        jLabel1.setText("VMD file");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 10;
        getContentPane().add(jLabel1, gridBagConstraints);

        jLabel2.setText("CSV file");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        getContentPane().add(jLabel2, gridBagConstraints);

        labelVMDS.setText("読み込まれてません");
        labelVMDS.setMaximumSize(new java.awt.Dimension(30000, 30000));
        labelVMDS.setMinimumSize(new java.awt.Dimension(140, 14));
        labelVMDS.setPreferredSize(new java.awt.Dimension(140, 14));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(labelVMDS, gridBagConstraints);

        labelCSVS.setText("読み込まれてません");
        labelCSVS.setMaximumSize(new java.awt.Dimension(30000, 30000));
        labelCSVS.setMinimumSize(new java.awt.Dimension(140, 14));
        labelCSVS.setPreferredSize(new java.awt.Dimension(140, 14));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(labelCSVS, gridBagConstraints);

        buttonVMD2CSV.setText("↓");
        buttonVMD2CSV.setEnabled(false);
        buttonVMD2CSV.setMinimumSize(new java.awt.Dimension(45, 16));
        buttonVMD2CSV.setPreferredSize(new java.awt.Dimension(45, 16));
        buttonVMD2CSV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonVMD2CSVActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        getContentPane().add(buttonVMD2CSV, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(textVMD, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(textCSV, gridBagConstraints);

        menuFile.setText("File");

        menuOpen.setText("開く");
        menuOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuOpenActionPerformed(evt);
            }
        });
        menuFile.add(menuOpen);

        menuClose.setText("終了");
        menuClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuCloseActionPerformed(evt);
            }
        });
        menuFile.add(menuClose);

        menuBar.add(menuFile);

        menuAbout.setText("help");
        menuBar.add(Box.createHorizontalGlue());

        jMenuItem3.setText("about");
        jMenuItem3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem3ActionPerformed(evt);
            }
        });
        menuAbout.add(jMenuItem3);

        menuBar.add(menuAbout);

        setJMenuBar(menuBar);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void buttonCSV2VMDActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonCSV2VMDActionPerformed
        try {
            FileInputStream fis=new FileInputStream(csv);
            Motion m=new Motion().fromCSV(fis);
            fis.close();
            FileOutputStream os=new FileOutputStream(vmd);
            m.toVMD(os);
            os.close();
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "ファイルが開けません",JOptionPane.ERROR_MESSAGE);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "I/O エラー",JOptionPane.ERROR_MESSAGE);
        } catch (MmdFormatException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "MMD モーションファイルじゃありません",JOptionPane.ERROR_MESSAGE);
        }
        renewInfo();
    }//GEN-LAST:event_buttonCSV2VMDActionPerformed

    private void menuCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuCloseActionPerformed
        dispose();
    }//GEN-LAST:event_menuCloseActionPerformed

    private void open(File f){
        String prename=f.getName();
        String ext;
        int i=prename.lastIndexOf('.');
        ext=prename.substring(i+1).toLowerCase();
        prename=prename.substring(0,i);
            
        if(ext.startsWith("vmd")&&f.exists()){
            vmd=f;
            csv=new File(f.getParentFile(),prename+".csv");
        }else {
            csv=f;
            vmd=new File(f.getParentFile(),prename+".vmd");
        }
        textVMD.setText(vmd.getName());
        textCSV.setText(csv.getName());
        renewInfo();
    }
    
    private void menuOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuOpenActionPerformed
        JFileChooser jfc=new JFileChooser();
        jfc.setDialogTitle("モーションを開く");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD motion","vmd","csv"));
        if(jfc.showOpenDialog(this)!=JFileChooser.APPROVE_OPTION)
            return;
        File f=jfc.getSelectedFile();
        open(f);
    }//GEN-LAST:event_menuOpenActionPerformed

    private void buttonVMD2CSVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonVMD2CSVActionPerformed
        try {
            FileInputStream fis=new FileInputStream(vmd);
            Motion m=new Motion().fromVMD(fis);
            fis.close();
            FileOutputStream fos=new FileOutputStream(csv);
            m.toCSV(fos);
            fos.close();
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "ファイルが開けません",JOptionPane.ERROR_MESSAGE);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "I/O エラー",JOptionPane.ERROR_MESSAGE);
        } catch (MmdFormatException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "VMD モーションファイルじゃありません",JOptionPane.ERROR_MESSAGE);
        }
        renewInfo();
    }//GEN-LAST:event_buttonVMD2CSVActionPerformed

    private void jMenuItem3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem3ActionPerformed
        new AboutDialog(this,true,this.getClass(),
                "VMD2CSV は MMDモーションデータ VMDと"
                + "VMDCSVConverter 上位互換の CSV との"
                + "相互変換をするJavaライブラリーのGUIです。")
                .show("VMD2CSV");
    }//GEN-LAST:event_jMenuItem3ActionPerformed

    protected void renewInfo(){
        String vmdM="<html>",csvM="<html>";
        long vmdT=0,csvT=0;
        DateFormat df=DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.LONG);
        if(vmd.exists()){
            vmdT=vmd.lastModified();
            buttonVMD2CSV.setEnabled(true);
        }else {
            vmdM+="存在しません";
            buttonVMD2CSV.setEnabled(false);
        }
        if(csv.exists()){
            csv.lastModified();
            csvT=csv.lastModified();
            if(vmdT>0){
                if(vmdT>csvT){
                    vmdM+="<font color=red>新</font>: ";
                } else {
                    csvM+="<font color=red>新</font>: ";
                }
            }
            csvM+=df.format(new Date(csvT));
            buttonCSV2VMD.setEnabled(true);
        }else {
            csvM+="存在しません";
            buttonCSV2VMD.setEnabled(false);
        }
        if(vmdT>0){
            vmdM+=df.format(new Date(vmdT));
        }
        labelVMDS.setText(vmdM+"</html>");
        labelCSVS.setText(csvM+"</html>");        
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        if(args.length>0){
            String filename=args[0];
            Motion m;
            FileInputStream fis;
            FileOutputStream fos;
            try {
                fis=new FileInputStream(args[0]);
                if(filename.toLowerCase().endsWith(".vmd")){
                    m = new Motion().fromVMD(fis );
                    fis.close();
                    filename=filename.substring(0,filename.lastIndexOf('.'))+".csv";
                    fos=new FileOutputStream(filename);
                    m.toCSV(fos);
                    fos.close();
                }else {
                    m = new Motion().fromCSV(fis);
                    fis.close();
                    filename=filename.substring(0,filename.lastIndexOf('.'))+".vmd";
                    m.toVMD(fos=new FileOutputStream(filename));
                    fos.close();
                }
            } catch (FileNotFoundException ex){
                System.err.println(ex.getLocalizedMessage());
            } catch (IOException ex) {
                System.err.println(ex.getLocalizedMessage());
            } catch (MmdFormatException ex) {
                System.err.println(ex.getLocalizedMessage());
            }
            System.exit(0);
        }
        
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(VMD2CSV.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(VMD2CSV.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(VMD2CSV.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(VMD2CSV.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new VMD2CSV().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonCSV2VMD;
    private javax.swing.JButton buttonVMD2CSV;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JLabel labelCSVS;
    private javax.swing.JLabel labelVMDS;
    private javax.swing.JMenu menuAbout;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem menuClose;
    private javax.swing.JMenu menuFile;
    private javax.swing.JMenuItem menuOpen;
    private javax.swing.JTextField textCSV;
    private javax.swing.JTextField textVMD;
    // End of variables declaration//GEN-END:variables

    private class HteDropTarget extends DropTarget {

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(DnDConstants.ACTION_REFERENCE);
                try {
                    List<File> list = (List<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
                    File f=list.get(0);
                    open(f);
                } catch (UnsupportedFlavorException e) {
                } catch (IOException ex) {
                    Logger.getLogger(VMD2CSV.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}
