/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.bin.parser;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class TextDecoder {
    private final CharsetDecoder decoder;
    private CharBuffer charBuffer;
    private boolean chopZero = false;

    public TextDecoder(Charset cs) {
        this(cs.newDecoder());
    }

    public TextDecoder(CharsetDecoder decoder) {
        this.decoder = decoder;
        this.decoder.reset();
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    protected int prepareCharBuffer(int byteLength) {
        int capacity;
        float maxCharsPerByte = this.decoder.maxCharsPerByte();
        int maxChars = (int)((float)byteLength * maxCharsPerByte) + 1;
        if (this.charBuffer != null && (capacity = this.charBuffer.capacity()) >= maxChars) {
            return capacity;
        }
        this.charBuffer = CharBuffer.allocate(maxChars);
        return maxChars;
    }

    public void setZeroChopMode(boolean chop) {
        this.chopZero = chop;
    }

    public boolean isZeroChopMode() {
        return this.chopZero;
    }

    protected void chopZeroTermed(ByteBuffer bBuf) {
        if (!this.chopZero) {
            return;
        }
        int start = bBuf.position();
        int limit = bBuf.limit();
        for (int idx = start; idx < limit; ++idx) {
            byte bVal = bBuf.get(idx);
            if (bVal != 0) continue;
            bBuf.limit(idx);
            break;
        }
    }

    public String decode(ByteBuffer bBuf) throws CharacterCodingException {
        this.chopZeroTermed(bBuf);
        int blen = bBuf.remaining();
        this.prepareCharBuffer(blen);
        this.charBuffer.clear();
        this.decoder.reset();
        CoderResult decResult = this.decoder.decode(bBuf, this.charBuffer, true);
        if (decResult.isError()) {
            decResult.throwException();
            assert (false);
        }
        assert (!decResult.isOverflow());
        String result = this.charBuffer.flip().toString();
        return result;
    }
}

