/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.xml;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jp.sfjp.mikutoga.xml.DomNsUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SiblingElemIterator
implements Iterator<Element> {
    private Element next;
    private final String nsuri;
    private final String localName;

    public SiblingElemIterator(Element first) {
        this.next = first;
        if (this.next == null) {
            this.nsuri = null;
            this.localName = null;
        } else {
            this.nsuri = this.next.getNamespaceURI();
            this.localName = this.next.getLocalName();
        }
    }

    public SiblingElemIterator(Element parent, String nsuri, String localName) {
        this.next = DomNsUtils.pickFirstChild(parent, nsuri, localName);
        if (this.next == null) {
            this.nsuri = null;
            this.localName = null;
        } else {
            this.nsuri = nsuri;
            this.localName = localName;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Element next() throws NoSuchElementException {
        Element result;
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Node sibNode = result = this.next;
        while ((sibNode = sibNode.getNextSibling()) != null && !this.matchElemName(sibNode)) {
        }
        this.next = sibNode;
        return result;
    }

    private boolean matchElemName(Node node) {
        return DomNsUtils.hasNsLocalNameElem(node, this.nsuri, this.localName);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

