/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import jp.sourceforge.mmd.motion.BooleanPose;
import jp.sourceforge.mmd.motion.Pose;

class MoveOnFrame
implements Comparable {
    private int frame;
    protected TreeMap<String, Pose> poses;
    protected ArrayList<BooleanPose> booleanPoses;

    public MoveOnFrame(int frame) {
        this.frame = frame;
        this.poses = new TreeMap();
        this.booleanPoses = new ArrayList();
    }

    public int hashCode() {
        return this.frame;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveOnFrame other = (MoveOnFrame)obj;
        return this.frame == other.frame;
    }

    public void put(Pose p) {
        if (p instanceof BooleanPose) {
            this.booleanPoses.add((BooleanPose)p);
        } else {
            this.poses.put(p.nameOfBone, p);
        }
    }

    public Pose get(String s) {
        return this.poses.get(s);
    }

    public void remove(String s) {
        this.poses.remove(s);
    }

    public int size() {
        return this.poses.size() + this.booleanPoses.size();
    }

    public Pose[] toArray() {
        Pose[] ps = new Pose[this.poses.size() + this.booleanPoses.size()];
        Iterator<Pose> ip = this.poses.values().iterator();
        int i = 0;
        while (ip.hasNext()) {
            Pose pose = ip.next();
            ps[i] = pose.clone();
            ++i;
        }
        for (Pose pose : this.booleanPoses) {
            ps[i] = pose.clone();
            ++i;
        }
        return ps;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o.getClass() != this.getClass()) {
            return 1;
        }
        MoveOnFrame other = (MoveOnFrame)o;
        return this.frame - other.frame;
    }
}

