/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import java.util.TreeMap;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.pmd.parser.PmdBasicHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdBoneHandler;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class PmdFileHander
implements PmdBoneHandler,
PmdBasicHandler {
    private Model model;
    private Bone bone = null;
    private ArrayList<String> al = new ArrayList();
    private TreeMap<Integer, Integer> tm = new TreeMap();

    public PmdFileHander(Model model) {
        this.model = model;
    }

    @Override
    public void pmdParseStart() throws MmdFormatException {
    }

    @Override
    public void pmdHeaderInfo(byte[] header) throws MmdFormatException {
        if (header[0] != 80 || header[1] != 109 || header[2] != 100) {
            throw new MmdFormatException("Not PMD file.");
        }
    }

    @Override
    public void pmdModelInfo(String modelName, String description) throws MmdFormatException {
        this.model.setName(modelName);
    }

    @Override
    public void loopStart(ParseStage stage, int loops) throws MmdFormatException {
    }

    @Override
    public void pmdBoneInfo(String boneName, byte boneKind) throws MmdFormatException {
        this.bone = new Bone(this.model);
        this.bone.name = boneName;
        this.al.add(boneName);
        switch (boneKind) {
            case 8: {
                this.bone.limitRot = new Vector3D();
            }
        }
    }

    @Override
    public void pmdBoneLink(int parentId, int tailId, int ikId) throws MmdFormatException {
        if (parentId == 65535) {
            this.bone.parent = null;
        } else {
            this.bone.parent = this.al.get(parentId);
            this.model.get(this.bone.parent).addChild(this.bone);
        }
        this.tm.put(this.al.size() - 1, tailId);
    }

    @Override
    public void pmdBonePosition(float xPos, float yPos, float zPos) throws MmdFormatException {
        this.bone.gv = new Vector3D(xPos, yPos, zPos);
        this.bone.mr = new Matrix();
        this.bone.ini_mr = new Matrix();
    }

    @Override
    public void pmdIKInfo(int boneId, int targetId, int depth, float weight) throws MmdFormatException {
    }

    @Override
    public void pmdIKChainInfo(int childId) throws MmdFormatException {
    }

    @Override
    public void pmdBoneGroupInfo(String groupName) throws MmdFormatException {
    }

    @Override
    public void pmdGroupedBoneInfo(int boneId, int groupId) throws MmdFormatException {
    }

    @Override
    public void loopNext(ParseStage stage) throws MmdFormatException {
        if (this.bone != null) {
            this.model.put(this.bone.name, this.bone);
        }
        this.bone = null;
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
    }

    @Override
    public void pmdParseEnd(boolean hasMoreData) throws MmdFormatException {
    }
}

