/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sourceforge.mmd.midiMotion.MotionBuilder;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Matrix;

public class DrumsMotionBuilder
extends MotionBuilder {
    protected Motion playerTemp = null;
    protected Motion drumTemp = null;
    protected Motion player = new Motion();
    protected Map<Integer, int[]> note2frames = new TreeMap<Integer, int[]>();
    protected boolean openHH = true;

    public void setTemplate(Motion drum, Motion player) {
        this.playerTemp = player;
        this.player.setModelName(player.getModelName());
        this.drumTemp = drum;
        this.motion.setModelName(drum.getModelName());
    }

    public void loadFrameMap(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "MS932"));
        while (br.ready()) {
            String line = br.readLine();
            if (line.charAt(0) == ';') continue;
            String[] p = CsvSpliter.split((String)line);
            this.note2frames.put(new Integer(p[5]), new int[]{Integer.parseInt(p[1]), Integer.parseInt(p[2]), Integer.parseInt(p[3]), Integer.parseInt(p[4]), Integer.parseInt(p[6]), Integer.parseInt(p[7])});
        }
    }

    @Override
    public void loadMessages() {
        Pose[] ps;
        int i;
        if (this.drumTemp == null || this.note2frames.isEmpty()) {
            return;
        }
        MidiEvent[] drums = this.mm.getChannelMessage(9);
        for (i = 0; i < 9; ++i) {
            if (drums != null) continue;
            drums = this.mm.getChannelMessage(i);
        }
        this.reportProgressStart();
        for (MidiEvent me : drums) {
            ShortMessage sm = (ShortMessage)me.getMessage();
            int com = sm.getCommand();
            if (com != 144) continue;
            int note = sm.getData1();
            int vel = sm.getData2();
            int frame = this.ticsToframe(me.getTick());
            this.reportProgress(frame);
            int[] list = this.note2frames.get(note);
            if (list == null) continue;
            if (list[4] == -1 && this.openHH) {
                ps = this.drumTemp.get(this.note2frames.get(257)[1]);
                this.motion.putAll(ps, frame + list[0] - list[1] - 1);
                ps = this.playerTemp.get(this.note2frames.get(257)[1]);
                this.player.putAll(ps, frame + list[0] - list[1] - 1);
            } else if (list[4] == 1 && !this.openHH) {
                ps = this.drumTemp.get(this.note2frames.get(258)[1]);
                this.motion.putAll(ps, frame + list[0] - list[1] - 1);
                ps = this.playerTemp.get(this.note2frames.get(258)[1]);
                this.player.putAll(ps, frame + list[0] - list[1] - 1);
            }
            int j = list[0];
            for (i = frame + list[0] - list[1]; i < frame + list[0] - list[1] + list[3]; ++i) {
                ps = this.drumTemp.get(j);
                this.motion.putAll(ps, i < 0 ? 0 : i);
                ++j;
            }
            j = list[0];
            Pose[] hit = this.playerTemp.get(list[1]);
            for (i = frame + list[0] - list[1]; i < frame + list[0] - list[1] + list[2]; ++i) {
                ps = this.playerTemp.get(j);
                if (note != 36 && note != 35 && i == frame + list[0] - list[1]) {
                    this.swing(vel, ps, hit);
                }
                this.player.putAll(ps, i < 0 ? 0 : i);
                ++j;
            }
            this.openHH = list[5] > 0 ? true : (list[5] < 0 ? false : this.openHH);
        }
        ps = this.playerTemp.get(0);
        this.player.putAll(ps, 0);
        ps = this.drumTemp.get(0);
        this.motion.putAll(ps, 0);
        this.reportProgressEnd();
    }

    public Motion getMotionPlayer() {
        return this.player;
    }

    private void swing(int vel, Pose[] ps, Pose[] hit) {
        for (Pose p : ps) {
            for (Pose hit1 : hit) {
                if (p.nameOfBone.compareTo(hit1.nameOfBone) != 0) continue;
                Matrix dr = ((BonePose)p).mr.times(((BonePose)hit1).mr.transpose());
                ((BonePose)p).mr = dr.power((double)vel / 100.0).times(((BonePose)hit1).mr);
            }
        }
    }
}

