/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sourceforge.mmd.ik_solver.IKSolver;
import jp.sourceforge.mmd.midiMotion.MotionBuilder;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class KeyBoardMotionBuilder
extends MotionBuilder {
    private static String[] rightHands = new String[]{"\u53f3\u4eba\u6307\uff13\u5148", "\u53f3\u4eba\u6307\uff11", "\u53f3\u624b\u9996", "\u53f3\u3072\u3058", "\u53f3\u8155"};
    private static String[] leftHands = new String[]{"\u5de6\u4eba\u6307\uff13\u5148", "\u5de6\u4eba\u6307\uff11", "\u5de6\u624b\u9996", "\u5de6\u3072\u3058", "\u5de6\u8155"};
    protected Motion player = null;
    protected Model playerModel = null;
    protected Model keyModel = null;
    protected String bendW = null;
    protected String programChange = null;
    private Vector3D offset = new Vector3D(0.0, 0.0, -3.2);
    protected int center = 61;

    public KeyBoardMotionBuilder() {
        this.motion.setModelName("Keyboard");
    }

    public KeyBoardMotionBuilder(Motion init) {
        super(init);
    }

    public void setPlayer(Motion motion, Model model) {
        this.player = motion == null ? new Motion(model.getName()) : motion;
        this.playerModel = model;
    }

    public void setKeyboard(Motion motion, Model model) {
        if (motion != null) {
            this.motion = motion;
        }
        this.keyModel = model;
        this.motion.setModelName(model.getName());
    }

    public int getCenter() {
        return this.center;
    }

    public void setCenter(int aCenter) {
        this.center = aCenter;
    }

    @Override
    public void loadMessages() {
        MidiEvent[] keys = this.mm.getChannelMessage(0);
        if (keys == null) {
            keys = this.mm.getChannelMessage(1);
        }
        if (keys == null) {
            keys = this.mm.getChannelMessage(2);
        }
        int pitchBend = 0;
        int loaded = 0;
        IKSolver iksR = null;
        IKSolver iksL = null;
        if (this.playerModel != null) {
            iksR = new IKSolver();
            iksR.setBones(new Bone[]{this.playerModel.get(rightHands[2]), this.playerModel.get(rightHands[3]), this.playerModel.get(rightHands[4])});
            iksR.setLimits(0, 64);
            iksR.setLimits(1, 51);
            iksL = new IKSolver();
            iksL.setBones(new Bone[]{this.playerModel.get(leftHands[2]), this.playerModel.get(leftHands[3]), this.playerModel.get(leftHands[4])});
            iksL.setLimits(0, 64);
            iksL.setLimits(1, 51);
            this.playerModel.setPoses(this.player.get(0));
            this.playerModel.resetChanged();
            this.keyModel.setPoses(this.motion.get(0));
            this.keyModel.resetChanged();
        }
        this.reportProgressStart();
        for (MidiEvent me : keys) {
            Vector3D finger;
            IKSolver iks;
            BonePose p;
            int note;
            int com;
            Pose[] ps;
            ShortMessage sm = (ShortMessage)me.getMessage();
            int frame = this.ticsToframe(me.getTick());
            this.reportProgress(frame);
            if (loaded < frame) {
                if (this.keyModel != null) {
                    this.keyModel.setPoses(this.motion.getInterporate(frame));
                    this.keyModel.resetChanged();
                }
                if (this.playerModel != null) {
                    ps = this.player.getInterporate(frame);
                    this.playerModel.setPoses(ps);
                    this.playerModel.resetChanged();
                }
                loaded = frame;
            }
            if ((com = sm.getCommand()) == 144) {
                note = sm.getData1();
                int velo = sm.getData2();
                p = new BonePose();
                p.nameOfBone = String.format("nt%03d", note);
                p.frame = frame - 1;
                this.motion.put((Pose)new BonePose(p));
                ++p.frame;
                p.mr = Matrix.rotation((double)-4.0, (double)0.0, (double)0.0);
                this.motion.put((Pose)p);
                this.keyModel.get(p.nameOfBone).setPose(p);
                if (iksR == null) continue;
                if (note > this.center) {
                    iks = iksR;
                    finger = this.playerModel.get(rightHands[2]).getPos().sub(this.playerModel.get(rightHands[0]).getPos());
                } else {
                    iks = iksL;
                    finger = this.playerModel.get(leftHands[2]).getPos().sub(this.playerModel.get(leftHands[0]).getPos());
                }
                iks.solve(this.getVecter(note, 0.5 * (double)velo / 100.0).add(finger));
                ps = this.playerModel.getChanged();
                this.playerModel.resetChanged();
                this.player.putAll(ps, frame - 1);
                iks.solve(this.getVecter(note, 0.0).add(finger));
                ps = this.playerModel.getChanged();
                this.playerModel.resetChanged();
                this.player.putAll(ps, frame);
                continue;
            }
            if (com == 128) {
                note = sm.getData1();
                p = new BonePose();
                p.nameOfBone = String.format("nt%03d", note);
                p.frame = frame;
                this.motion.put((Pose)new BonePose(p));
                --p.frame;
                p.mr = Matrix.rotation((double)-4.0, (double)0.0, (double)0.0);
                this.motion.put((Pose)p);
                this.keyModel.get(p.nameOfBone).setPose(p);
                if (this.playerModel == null) continue;
                if (note > this.center) {
                    iks = iksR;
                    finger = this.playerModel.get(rightHands[2]).getPos().sub(this.playerModel.get(rightHands[0]).getPos());
                } else {
                    iks = iksL;
                    finger = this.playerModel.get(leftHands[2]).getPos().sub(this.playerModel.get(leftHands[0]).getPos());
                }
                iks.solve(this.getVecter(note, 0.0).add(finger));
                ps = this.playerModel.getChanged();
                this.playerModel.resetChanged();
                this.player.putAll(ps, frame - 1);
                iks.solve(this.getVecter(note, 0.3).add(finger));
                ps = this.playerModel.getChanged();
                this.playerModel.resetChanged();
                this.player.putAll(ps, frame);
                continue;
            }
            if (com != 224 || this.bendW == null) continue;
            p = new BonePose();
            p.nameOfBone = this.bendW;
            p.frame = frame - 1;
            p.mr = Matrix.rotation((double)(60.0 * (double)pitchBend / 8192.0), (double)0.0, (double)0.0);
            this.motion.put((Pose)new BonePose(p));
            if (this.playerModel != null) {
                finger = this.playerModel.get(leftHands[2]).getPos().sub(this.playerModel.get(leftHands[0]).getPos());
                Vector3D key_surface = this.keyModel.get(this.bendW).getPos();
                iksL.solve(key_surface.add(new Vector3D(0.0, 0.4, 0.0).rotate_vector(new Vector3D(Math.sin(-((double)pitchBend) / 8192.0), 0.0, 0.0), Math.cos((double)pitchBend / 8192.0))).add(finger));
                ps = this.playerModel.getChanged();
                this.playerModel.resetChanged();
                this.player.putAll(ps, frame - 1);
                pitchBend = sm.getData1() + sm.getData2() * 128 - 8192;
                iksL.solve(key_surface.add(new Vector3D(0.0, 0.4, 0.0).rotate_vector(new Vector3D(Math.sin(-((double)pitchBend) / 8192.0), 0.0, 0.0), Math.cos((double)pitchBend / 8192.0))).add(finger));
                ps = this.playerModel.getChanged();
                this.playerModel.resetChanged();
                this.player.putAll(ps, frame);
            }
            p.frame = frame;
            p.mr = Matrix.rotation((double)(60.0 * (double)pitchBend / 8192.0), (double)0.0, (double)0.0);
            this.motion.put((Pose)p);
        }
        this.reportProgressEnd();
    }

    public Motion getMotionPlayer() {
        return this.player;
    }

    public void setBendW(String s) {
        this.bendW = s;
    }

    public void setProgramChange(String s) {
        this.programChange = s;
    }

    private Vector3D getVecter(int note, double y) {
        Bone b = this.keyModel.get(String.format("nt%03d", note));
        return b.getPos().add(b.getGMatrix().times(this.offset.add(new Vector3D(0.0, y, 0.0))));
    }

    public Vector3D getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3D offset) {
        this.offset = offset;
    }
}

