/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import jp.sourceforge.mmd.midiMotion.KeyBoardMotionBuilder;
import jp.sourceforge.mmd.midiMotion.MidiResolver;
import jp.sourceforge.mmd.midiMotion.ProgressLisner;
import jp.sourceforge.mmd.midiMotion.gui.MotionPane;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.swing.BoneComboBox;
import jp.sourceforge.mmd.motion.swing.MmdDialog;

public class KeyboardMotionPane
extends MotionPane
implements ProgressLisner {
    protected Model keyModel;
    protected Motion keyMotion;
    protected Model playerModel;
    protected Motion playerMotion;
    protected KeyBoardMotionBuilder kbmb = new KeyBoardMotionBuilder();
    protected Vector3D offset = this.kbmb.getOffset();
    private BoneComboBox boneComboBox1;
    private BoneComboBox boneComboBox2;
    private JButton buttonProgress;
    private JTextField centerText;
    private JButton keyModelOpenButton;
    private JButton keyMotionOpenButton;
    private JTextField keysModelText;
    private JTextField keysMotionText;
    private JButton playerModelOpenButton;
    private JTextField playerModelText;
    private JButton playerMotionOpenButton;
    private JTextField playerMotionText;
    private JProgressBar progressBar;
    private JTextField textOffsetX;
    private JTextField textOffsetY;
    private JTextField textOffsetZ;

    public KeyboardMotionPane() {
        super("keyboard");
        this.initComponents();
    }

    @Override
    public void setMidiResolver(MidiResolver midiR) {
        super.setMidiResolver(midiR);
        this.buttonProgress.setEnabled(true);
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.buttonProgress = new JButton();
        this.keyModelOpenButton = new JButton();
        this.keysModelText = new JTextField();
        this.keysMotionText = new JTextField();
        this.playerModelText = new JTextField();
        this.playerMotionText = new JTextField();
        this.keyMotionOpenButton = new JButton();
        this.playerModelOpenButton = new JButton();
        this.playerMotionOpenButton = new JButton();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.centerText = new JTextField();
        this.textOffsetX = new JTextField();
        this.textOffsetY = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.textOffsetZ = new JTextField();
        this.boneComboBox1 = new BoneComboBox();
        this.boneComboBox2 = new BoneComboBox();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        jLabel1.setText("keys \u30e2\u30c7\u30eb");
        this.add((Component)jLabel1, new GridBagConstraints());
        jLabel2.setText("keys \u30e2\u30fc\u30b7\u30e7\u30f3");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("player \u30e2\u30c7\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("player \u30e2\u30fc\u30b7\u30e7\u30f3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel4, gridBagConstraints);
        this.buttonProgress.setText("do");
        this.buttonProgress.setEnabled(false);
        this.buttonProgress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.buttonProgressActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.buttonProgress, gridBagConstraints);
        this.keyModelOpenButton.setText("open");
        this.keyModelOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.keyModelOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.keyModelOpenButton, gridBagConstraints);
        this.keysModelText.setEditable(false);
        this.keysModelText.setText("\u307e\u3060");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.keysModelText, gridBagConstraints);
        this.keysMotionText.setEditable(false);
        this.keysMotionText.setText("\u307e\u3060");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.keysMotionText, gridBagConstraints);
        this.playerModelText.setEditable(false);
        this.playerModelText.setText("\u307e\u3060");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.playerModelText, gridBagConstraints);
        this.playerMotionText.setEditable(false);
        this.playerMotionText.setText("\u307e\u3060");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.playerMotionText, gridBagConstraints);
        this.keyMotionOpenButton.setText("open");
        this.keyMotionOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.keyMotionOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.keyMotionOpenButton, gridBagConstraints);
        this.playerModelOpenButton.setText("open");
        this.playerModelOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.playerModelOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.playerModelOpenButton, gridBagConstraints);
        this.playerMotionOpenButton.setText("open");
        this.playerMotionOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.playerMotionOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.playerMotionOpenButton, gridBagConstraints);
        jLabel5.setText("\u30bb\u30f3\u30bf\u30fc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText("\u30db\u30a4\u30fc\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)jLabel6, gridBagConstraints);
        jLabel7.setText("Program Change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)jLabel7, gridBagConstraints);
        this.centerText.setText("60");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.centerText, gridBagConstraints);
        this.textOffsetX.setText(String.valueOf(this.offset.toDouble()[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.textOffsetX, gridBagConstraints);
        this.textOffsetY.setText(String.valueOf(this.offset.toDouble()[1]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textOffsetY, gridBagConstraints);
        jLabel8.setText("\u30aa\u30d5\u30bb\u30c3\u30c8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel8, gridBagConstraints);
        this.textOffsetZ.setText(String.valueOf(this.offset.toDouble()[2]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textOffsetZ, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.boneComboBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.boneComboBox2, gridBagConstraints);
        this.progressBar.setEnabled(false);
        this.progressBar.setString("0");
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private void keyModelOpenButtonActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m == null) {
            return;
        }
        this.keyModel = m;
        this.keysModelText.setText(this.keyModel.getName());
        this.boneComboBox1.setMMDModel(m);
        this.boneComboBox2.setMMDModel(m);
        String proper = System.getProperty("midiMotion.keyboard." + this.keyModel.getName() + ".wheel");
        if (proper != null) {
            this.boneComboBox1.setSelect(proper);
        }
        if ((proper = System.getProperty("midiMotion.keyboard." + this.keyModel.getName() + ".programChange")) != null) {
            this.boneComboBox2.setSelect(proper);
        }
        if ((proper = System.getProperty("midiMotion.keyboard." + this.keyModel.getName() + ".center")) != null) {
            this.centerText.setText(proper);
        }
        if ((proper = System.getProperty("midiMotion.keyboard." + this.keyModel.getName() + ".offset")) != null) {
            String[] sp = proper.split(",");
            this.textOffsetX.setText(sp[0]);
            this.textOffsetY.setText(sp[1]);
            this.textOffsetZ.setText(sp[2]);
        }
    }

    private void playerModelOpenButtonActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m != null) {
            this.playerModel = m;
            this.playerModelText.setText(this.playerModel.getName());
        }
    }

    private void keyMotionOpenButtonActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m != null) {
            this.keyMotion = m;
            this.keysMotionText.setText(this.keyMotion.getModelName());
        }
    }

    private void playerMotionOpenButtonActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m != null) {
            this.playerMotion = m;
            this.playerMotionText.setText(this.playerMotion.getModelName());
        }
    }

    private void buttonProgressActionPerformed(ActionEvent evt) {
        if (this.playerMotion != null && this.playerModel != null) {
            this.kbmb.setPlayer(this.playerMotion, this.playerModel);
        }
        if (this.keyModel != null) {
            this.kbmb.setKeyboard(this.keyMotion, this.keyModel);
            this.kbmb.setCenter(Integer.parseInt(this.centerText.getText()));
            System.setProperty("midiMotion.keyboard." + this.keyModel.getName() + ".center", this.centerText.getText());
            String s = (String)this.boneComboBox1.getSelectedItem();
            if (s != null && !s.equalsIgnoreCase("(\u306a\u3057)")) {
                this.kbmb.setBendW(s);
                System.setProperty("midiMotion.keyboard." + this.keyModel.getName() + ".wheel", s);
            } else {
                this.kbmb.setBendW(null);
                System.setProperty("midiMotion.keyboard." + this.keyModel.getName() + ".wheel", "(\u306a\u3057)");
            }
            s = (String)this.boneComboBox2.getSelectedItem();
            if (s != null && !s.equalsIgnoreCase("(\u306a\u3057)")) {
                this.kbmb.setProgramChange(s);
                System.setProperty("midiMotion.keyboard." + this.keyModel.getName() + ".programChange", s);
            } else {
                this.kbmb.setProgramChange(null);
                System.setProperty("midiMotion.keyboard." + this.keyModel.getName() + ".programChange", "(\u306a\u3057)");
            }
            this.offset = new Vector3D(Double.parseDouble(this.textOffsetX.getText()), Double.parseDouble(this.textOffsetY.getText()), Double.parseDouble(this.textOffsetZ.getText()));
            this.kbmb.setOffset(this.offset);
            System.setProperty("midiMotion.keyboard." + this.keyModel.getName() + ".offset", this.offset.toString());
        }
        this.kbmb.addProgressListener(this);
        this.buttonProgress.setEnabled(false);
        this.kbmb.setMidiResolver(this.midiR);
        new Thread(new Runnable(){
            private ProgressLisner perent;

            public Runnable setP(ProgressLisner l) {
                this.perent = l;
                return this;
            }

            @Override
            public void run() {
                KeyboardMotionPane.this.kbmb.loadMessages();
                KeyboardMotionPane.this.kbmb.removeProgressListener(this.perent);
            }
        }.setP(this)).start();
    }

    @Override
    public void progressStart(int end) {
        this.progressBar.setEnabled(true);
        this.progressBar.setMaximum(end);
        this.progressBar.setValue(0);
    }

    @Override
    public void progressMid(int s) {
        this.progressBar.setValue(s);
        this.progressBar.setString(String.valueOf(s));
    }

    @Override
    public void progressEnd() {
        this.progressBar.setEnabled(false);
        this.progressBar.setMaximum(0);
        this.buttonProgress.setEnabled(true);
        Motion keyboardOutputMotion = this.kbmb.getMotion();
        Motion playerOutputMotion = this.kbmb.getMotionPlayer();
        String s = System.getProperty("midiMotion.outputDir");
        if (s == null) {
            s = ".";
        }
        JFileChooser jfc = new JFileChooser(s);
        jfc.setFileSelectionMode(1);
        jfc.setToolTipText("\u30d5\u30a9\u30eb\u30c0\u30fc\u3092\u9078\u3076");
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        File dir = jfc.getSelectedFile();
        try {
            FileOutputStream fos = new FileOutputStream(new File(dir, "keyboard.vmd"));
            keyboardOutputMotion.toVMD((OutputStream)fos);
            fos.close();
            if (playerOutputMotion != null) {
                fos = new FileOutputStream(new File(dir, "keysPlayer.vmd"));
                playerOutputMotion.toVMD((OutputStream)fos);
                fos.close();
            }
            System.setProperty("midiMotion.outputDir", dir.getParent());
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n" + ex);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IO\u30a8\u30e9\u30fc\n" + ex);
        }
        this.kbmb.resetMotion();
    }

    @Override
    void setFPS(float fps) {
        this.kbmb.setFPS(fps);
    }
}

