/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.midiMotion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;

/**
 *
 * @author nazo
 */
public class DrumsMotionBuilder extends MotionBuilder{
    protected Motion playerTemp;
    protected Motion drumTemp;
    protected Motion player;
    protected Map<Integer,int[]> note2frames;
    protected boolean openHH;

    public DrumsMotionBuilder(){
        super();
        this.openHH = true;
//        motion.setModelName("星のタマ");
        player=new Motion();
        note2frames=new TreeMap<Integer, int[]>();
        playerTemp=null;
        drumTemp=null;
    }

    public void setTemplate(Motion drum,Motion player){
        this.playerTemp=player;
        this.player.setModelName(player.getModelName());
        this.drumTemp=drum;
        motion.setModelName(drum.getModelName());
    }

    public void loadFrameMap(InputStream is) throws IOException{
        BufferedReader br=new BufferedReader(new InputStreamReader(is,"MS932"));
        String line;
        String []p;
        while(br.ready()){
            line=br.readLine();
            if(line.charAt(0)==';')continue;
            p=CsvSpliter.split(line);
            note2frames.put(new Integer(p[5]),
                    new int []{
                        Integer.parseInt(p[1]),//from
                        Integer.parseInt(p[2]),//hit
                        Integer.parseInt(p[3]),//player
                        Integer.parseInt(p[4]),//drum
                        Integer.parseInt(p[6]),// hh preopen
                        Integer.parseInt(p[7])// hh afteropen
                    });
        }
    }

    /**
     * do setTemplate and load
     */
    @Override
    public void loadMessages(){
        if(drumTemp==null||note2frames.isEmpty()){
            return;
        }

        ShortMessage sm;
        int com;
        int note;
        int vel;
        int frame;
        int i,j;
        BonePose p;
        Pose [] ps;
        int []list;
        MidiEvent [] drums=mm.getChannelMessage(9);

        for(i=0;i<9;i++){
            if(drums==null){
                drums=mm.getChannelMessage(i);
            }
        }
        reportProgressStart();
        for(MidiEvent me:drums){
            sm=(ShortMessage)me.getMessage();
            if((com=sm.getCommand())==ShortMessage.NOTE_ON){
                note=sm.getData1();
                vel=sm.getData2();
                frame=ticsToframe(me.getTick());
                reportProgress(frame);
                list=note2frames.get(note);
                if(list==null)continue;

                if((list[4]==-1) && openHH){//close
                    ps=drumTemp.get(note2frames.get(257)[1]);
                    motion.putAll(ps, frame+list[0]-list[1]-1);
                    ps=playerTemp.get(note2frames.get(257)[1]);
                    player.putAll(ps, frame+list[0]-list[1]-1);
                }else if((list[4]==1) && (!openHH) ){//open
                    ps=drumTemp.get(note2frames.get(258)[1]);
                    motion.putAll(ps, frame+list[0]-list[1]-1);
                    ps=playerTemp.get(note2frames.get(258)[1]);
                    player.putAll(ps, frame+list[0]-list[1]-1);
                }

                j=list[0];
                for(i=frame+list[0]-list[1];i<frame+list[0]-list[1]+list[3];i++){
                    ps = drumTemp.get(j);
                    motion.putAll(ps, ((i<0)?0:i));
                    j++;
                }

                j=list[0];
                Pose [] hit=playerTemp.get(list[1]);
                for(i=frame+list[0]-list[1];i<frame+list[0]-list[1]+list[2];i++){
                    ps = playerTemp.get(j);
                    if(note!=36 && note!=35 && i==frame+list[0]-list[1]){
                        swing(vel,ps,hit);
                    }
                    player.putAll(ps, (i<0)?0:i);
                    j++;
                }
                openHH=(list[5]>0)?true:((list[5]<0)?false:openHH);
            }/*end of noteON*/
        }

        ps = playerTemp.get(0);
        player.putAll(ps,0);
        ps = drumTemp.get(0);
        motion.putAll(ps,0);

        reportProgressEnd();
    }


    public Motion getMotionPlayer(){
        return player;
    }

    private void swing(int vel, Pose[] ps, Pose[] hit) {
        for (Pose p : ps) {
            for (Pose hit1 : hit) {
                if (p.nameOfBone.compareTo(hit1.nameOfBone) == 0) {
                    Matrix dr = ((BonePose) p).mr.times(((BonePose) hit1).mr.transpose());
                    ((BonePose) p).mr = dr.power((double)vel/100).times(((BonePose) hit1).mr);
                }
            }
        }
    }
}
