/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.sourceforge.mmd.midiMotion.KeyBoardMotionBuilder;
import jp.sourceforge.mmd.midiMotion.MidiResolver;
import jp.sourceforge.mmd.midiMotion.ProgressLisner;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.swing.MmdDialog;

/**
 *
 * @author nazo
 */
public class KeyboardMotionPane extends MotionPane implements ProgressLisner{
    protected Model keyModel;
    protected Motion keyMotion;
    protected Model playerModel;
    protected Motion playerMotion;
    protected KeyBoardMotionBuilder kbmb;
    protected Vector3D offset;

    /**
     * Creates new form KeyboardMotionPane
     */
    public KeyboardMotionPane() {
        super("keyboard");
        kbmb=new KeyBoardMotionBuilder();
        offset=kbmb.getOffset();
        initComponents();
    }

    @Override
    public void setMidiResolver(MidiResolver midiR) {
        super.setMidiResolver(midiR);
        buttonProgress.setEnabled(true);
    }

    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel4 = new javax.swing.JLabel();
        buttonProgress = new javax.swing.JButton();
        keyModelOpenButton = new javax.swing.JButton();
        keysModelText = new javax.swing.JTextField();
        keysMotionText = new javax.swing.JTextField();
        playerModelText = new javax.swing.JTextField();
        playerMotionText = new javax.swing.JTextField();
        keyMotionOpenButton = new javax.swing.JButton();
        playerModelOpenButton = new javax.swing.JButton();
        playerMotionOpenButton = new javax.swing.JButton();
        javax.swing.JLabel jLabel5 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel6 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel7 = new javax.swing.JLabel();
        centerText = new javax.swing.JTextField();
        textOffsetX = new javax.swing.JTextField();
        textOffsetY = new javax.swing.JTextField();
        javax.swing.JLabel jLabel8 = new javax.swing.JLabel();
        textOffsetZ = new javax.swing.JTextField();
        boneComboBox1 = new jp.sourceforge.mmd.motion.swing.BoneComboBox();
        boneComboBox2 = new jp.sourceforge.mmd.motion.swing.BoneComboBox();
        progressBar = new javax.swing.JProgressBar();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("keys モデル");
        add(jLabel1, new java.awt.GridBagConstraints());

        jLabel2.setText("keys モーション");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        add(jLabel2, gridBagConstraints);

        jLabel3.setText("player モデル");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        add(jLabel3, gridBagConstraints);

        jLabel4.setText("player モーション");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        add(jLabel4, gridBagConstraints);

        buttonProgress.setText("do");
        buttonProgress.setEnabled(false);
        buttonProgress.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonProgressActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        add(buttonProgress, gridBagConstraints);

        keyModelOpenButton.setText("open");
        keyModelOpenButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keyModelOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        add(keyModelOpenButton, gridBagConstraints);

        keysModelText.setEditable(false);
        keysModelText.setText("まだ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        add(keysModelText, gridBagConstraints);

        keysMotionText.setEditable(false);
        keysMotionText.setText("まだ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        add(keysMotionText, gridBagConstraints);

        playerModelText.setEditable(false);
        playerModelText.setText("まだ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        add(playerModelText, gridBagConstraints);

        playerMotionText.setEditable(false);
        playerMotionText.setText("まだ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        add(playerMotionText, gridBagConstraints);

        keyMotionOpenButton.setText("open");
        keyMotionOpenButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keyMotionOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        add(keyMotionOpenButton, gridBagConstraints);

        playerModelOpenButton.setText("open");
        playerModelOpenButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playerModelOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        add(playerModelOpenButton, gridBagConstraints);

        playerMotionOpenButton.setText("open");
        playerMotionOpenButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playerMotionOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        add(playerMotionOpenButton, gridBagConstraints);

        jLabel5.setText("センター");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        add(jLabel5, gridBagConstraints);

        jLabel6.setText("ホイール");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        add(jLabel6, gridBagConstraints);

        jLabel7.setText("Program Change");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        add(jLabel7, gridBagConstraints);

        centerText.setText("60");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        add(centerText, gridBagConstraints);

        textOffsetX.setText(String.valueOf(offset.toDouble()[0]));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        add(textOffsetX, gridBagConstraints);

        textOffsetY.setText(String.valueOf(offset.toDouble()[1]));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(textOffsetY, gridBagConstraints);

        jLabel8.setText("オフセット");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        add(jLabel8, gridBagConstraints);

        textOffsetZ.setText(String.valueOf(offset.toDouble()[2]));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(textOffsetZ, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(boneComboBox1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(boneComboBox2, gridBagConstraints);

        progressBar.setEnabled(false);
        progressBar.setString("0");
        progressBar.setStringPainted(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(progressBar, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void keyModelOpenButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keyModelOpenButtonActionPerformed
        Model m=MmdDialog.loadModel(this);
        if(m==null)return;
        keyModel=m;
        keysModelText.setText(keyModel.getName());
        boneComboBox1.setMMDModel(m);
        boneComboBox2.setMMDModel(m);
        String proper=System.getProperty("midiMotion.keyboard."+keyModel.getName()+".wheel");
        if(proper!=null){
            boneComboBox1.setSelect(proper);
        }
        proper=System.getProperty("midiMotion.keyboard."+keyModel.getName()+".programChange");
        if(proper!=null){
            boneComboBox2.setSelect(proper);
        }
        proper=System.getProperty("midiMotion.keyboard."+keyModel.getName()+".center");
        if(proper!=null){
            centerText.setText(proper);
        }
        proper=System.getProperty("midiMotion.keyboard."+keyModel.getName()+".offset");
        if(proper!=null){
            String [] sp=proper.split(",");
            textOffsetX.setText(sp[0]);
            textOffsetY.setText(sp[1]);
            textOffsetZ.setText(sp[2]);
        }
    }//GEN-LAST:event_keyModelOpenButtonActionPerformed

    private void playerModelOpenButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playerModelOpenButtonActionPerformed
        Model m=MmdDialog.loadModel(this);
        if(m!=null){
            playerModel=m;
            playerModelText.setText(playerModel.getName());
        }
    }//GEN-LAST:event_playerModelOpenButtonActionPerformed

    private void keyMotionOpenButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keyMotionOpenButtonActionPerformed
        Motion m=MmdDialog.loadMotion(this);
        if(m!=null){
            keyMotion=m;
            keysMotionText.setText(keyMotion.getModelName());
        }
    }//GEN-LAST:event_keyMotionOpenButtonActionPerformed

    private void playerMotionOpenButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playerMotionOpenButtonActionPerformed
        Motion m=MmdDialog.loadMotion(this);
        if(m!=null){
            playerMotion=m;
            playerMotionText.setText(playerMotion.getModelName());
        }
    }//GEN-LAST:event_playerMotionOpenButtonActionPerformed

    private void buttonProgressActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonProgressActionPerformed
        if(playerMotion!=null && playerModel!=null){
            kbmb.setPlayer(playerMotion, playerModel);
        }
        if(keyModel!=null){
            kbmb.setKeyboard(keyMotion, keyModel);
            kbmb.setCenter(Integer.parseInt(centerText.getText()));
            System.setProperty("midiMotion.keyboard."+keyModel.getName()+".center",centerText.getText());
            String s=(String)boneComboBox1.getSelectedItem();
            if(s!=null && (!s.equalsIgnoreCase("(なし)"))){
                kbmb.setBendW(s);
                System.setProperty("midiMotion.keyboard."+keyModel.getName()+".wheel",s);
            }else {
                kbmb.setBendW(null);
                System.setProperty("midiMotion.keyboard."+keyModel.getName()+".wheel","(なし)");
            }
            s=(String)boneComboBox2.getSelectedItem();
            if(s!=null && (!s.equalsIgnoreCase("(なし)"))){
                kbmb.setProgramChange(s);
                System.setProperty("midiMotion.keyboard."+keyModel.getName()+".programChange",s);
            }else {
                kbmb.setProgramChange(null);
                System.setProperty("midiMotion.keyboard."+keyModel.getName()+".programChange","(なし)");
            }
            offset=new Vector3D(
                    Double.parseDouble(textOffsetX.getText()),
                    Double.parseDouble(textOffsetY.getText()),
                    Double.parseDouble(textOffsetZ.getText())
            );
            kbmb.setOffset(offset);
            System.setProperty("midiMotion.keyboard."+keyModel.getName()+".offset",offset.toString());
        }
        kbmb.addProgressListener(this);
        buttonProgress.setEnabled(false);
        kbmb.setMidiResolver(midiR);
        new Thread(new Runnable() {
            private ProgressLisner perent;
            public Runnable setP(ProgressLisner l){
                perent=l;
                return this;
            }
            @Override
            public void run() {
                kbmb.loadMessages();
                kbmb.removeProgressListener(perent);
            }
        }.setP(this)).start();
    }//GEN-LAST:event_buttonProgressActionPerformed

    @Override
    public void progressStart(int end) {
        progressBar.setEnabled(true);
        progressBar.setMaximum(end);
        progressBar.setValue(0);
    }

    @Override
    public void progressMid(int s) {
        progressBar.setValue(s);
        progressBar.setString(String.valueOf(s));
    }

    @Override
    public void progressEnd() {
        progressBar.setEnabled(false);
        progressBar.setMaximum(0);
        buttonProgress.setEnabled(true);
        // output
        Motion keyboardOutputMotion=kbmb.getMotion();
        Motion playerOutputMotion=kbmb.getMotionPlayer();

        String s=System.getProperty("midiMotion.outputDir");
        if(s==null){s=".";}
        JFileChooser jfc=new JFileChooser(s);
        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jfc.setToolTipText("フォルダーを選ぶ");
        if(jfc.showSaveDialog(this)!=JFileChooser.APPROVE_OPTION){
            return;
        }

        File dir=jfc.getSelectedFile();
        try {
            FileOutputStream fos=new FileOutputStream(new File(dir,"keyboard.vmd"));
            keyboardOutputMotion.toVMD(fos);
            fos.close();
            if(playerOutputMotion!=null){
                fos=new FileOutputStream(new File(dir,"keysPlayer.vmd"));
                playerOutputMotion.toVMD(fos);
                fos.close();
            }
            System.setProperty("midiMotion.outputDir",dir.getParent());
        }catch(FileNotFoundException ex){
            JOptionPane.showMessageDialog(this, "ファイルが見つかりません\n"+ex);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IOエラー\n"+ex);
        }
        kbmb.resetMotion();
    }

    @Override
    void setFPS(float fps) {
        kbmb.setFPS(fps);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private jp.sourceforge.mmd.motion.swing.BoneComboBox boneComboBox1;
    private jp.sourceforge.mmd.motion.swing.BoneComboBox boneComboBox2;
    private javax.swing.JButton buttonProgress;
    private javax.swing.JTextField centerText;
    private javax.swing.JButton keyModelOpenButton;
    private javax.swing.JButton keyMotionOpenButton;
    private javax.swing.JTextField keysModelText;
    private javax.swing.JTextField keysMotionText;
    private javax.swing.JButton playerModelOpenButton;
    private javax.swing.JTextField playerModelText;
    private javax.swing.JButton playerMotionOpenButton;
    private javax.swing.JTextField playerMotionText;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JTextField textOffsetX;
    private javax.swing.JTextField textOffsetY;
    private javax.swing.JTextField textOffsetZ;
    // End of variables declaration//GEN-END:variables

}
