/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion.swing;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/**
 * パッケージの著作情報を表示するダイアログ.
 * @author nazo
 */
public class AboutDialog extends javax.swing.JDialog {

    /**
     * 著作情報などを表示する, "○○について" ダイアログを表示する.
     * @param parent 親Frame. 
     * @param modal モーダルのオンオフ. モーダルとは、親のキーボードなどの操作を全く受け付けなくさせること.
     * @param clazz clazz パッケージの中心になる, Java Class オブジェクト.
     * @param message メッセージ文. パッケージ名などを除く.
     */
    public AboutDialog(java.awt.Frame parent, boolean modal, Class clazz, String message) {
        super(parent, modal);
        initComponents();

        // Close the dialog when Esc is pressed
        String cancelName = "cancel";
        InputMap inputMap = getRootPane().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), cancelName);
        ActionMap actionMap = getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                doClose();
            }
        });

        URL u = clazz.getResource(clazz.getSimpleName() + ".class");
        String s=u.toExternalForm();
        Properties p=new Properties();

        if(s.startsWith("jar")){
            s = s.substring(0, s.lastIndexOf("!/"));
            try {
/*                InputStream is=new URL(s+"!/META-INF/maven/jp.sourceforge.mmd/MID2Motion/pom.properties").openStream();
                p.load(is);
                is.close();*/
                JarURLConnection jarConnection = (JarURLConnection)new URL(s+"!/").openConnection();
                Attributes attr = jarConnection.getMainAttributes();
                String artifactId=s.substring(s.lastIndexOf("/")+1);
                artifactId=artifactId.substring(0,artifactId.indexOf("-"));
                message=message+"\n\n"+packName(attr,artifactId);
                message +="\n\n依存性: \n";

                s=s.substring(0,s.lastIndexOf("/")+1);
                String el=attr.getValue("Extension-List");
                Attributes attr2;
                JarURLConnection jarConnection2;
                
                for(String l:el.split(" ")){
                    String name=attr.getValue(l+"-Extension-Name");
                    String ver=attr.getValue(l+"-Implementation-Version");
                    jarConnection2 = (JarURLConnection)new URL(s+name+"-"+ver+".jar!/").openConnection();
                    attr2 = jarConnection2.getMainAttributes();
                    message+=packName(attr2,l);
                }

            } catch (MalformedURLException ex) {
                message+=ex;
            } catch (IOException ex) {
                message+=ex;
            }
        }else{
            s = s.substring(0, s.lastIndexOf("classes/"));
            InputStream is;
            try {
                is = new URL(s+"maven-archiver/pom.properties").openStream();
                p.load(is);
                is.close();
                message+="("+p.getProperty("groupId")+"."+p.getProperty("artifactId")+") Version: "+p.getProperty("version");
                message +="\n\n依存性: \n";
                message+= "TogaGem (jp.sourceforge.mikutoga.togagem) http://mikutoga.osdn.jp/ Version: 3.n2\n";
            } catch (MalformedURLException ex) {
                message+=ex;
            } catch (IOException ex) {
                message+=ex;
            }
        }

        jTextArea1.setText(message);
    }

    private String packName(Attributes attr, String artifactID) throws IOException{
        String ret;
        ret=attr.getValue("Implementation-Title");
        ret+=" ("+attr.getValue("Implementation-Vendor-Id")+"."+artifactID+") ";
        ret+=attr.getValue("Implementation-URL");
        ret+= " Version: "+attr.getValue("Implementation-Version")+"\n";
        if(attr.getValue("Copyright") != null){
            ret+="    "+attr.getValue("Copyright")+"\n\n";
        }
        return ret;
    }

    /**
     * ダイアログを表示する. close をすると、もう表示できないので注意.
     * @param title ウィンドウタイトル. " について" が追加される.
     */
    public void show(String title){
        setTitle(title+ " について");
        setVisible(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        okButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        getContentPane().add(okButton, gridBagConstraints);
        getRootPane().setDefaultButton(okButton);

        jScrollPane1.setMinimumSize(new java.awt.Dimension(100, 32));

        jTextArea1.setEditable(false);
        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPane1.setViewportView(jTextArea1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        doClose();
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * Closes the dialog
     */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose();
    }//GEN-LAST:event_closeDialog
    
    private void doClose() {
        setVisible(false);
        dispose();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables
}
