/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Pose;

public class MorphPose
extends Pose {
    public float factor;

    public MorphPose() {
        this.factor = 0.0f;
    }

    public MorphPose(MorphPose p) {
        super(p);
        this.factor = p.factor;
    }

    public static MorphPose fromCSV(String line) throws NumberFormatException {
        String[] column = CsvSpliter.split(line);
        if (column.length < 3) {
            return null;
        }
        MorphPose p = new MorphPose();
        p.nameOfBone = column[0];
        p.frame = Integer.parseInt(column[1]);
        p.factor = Float.parseFloat(column[2]);
        return p;
    }

    @Override
    public String toCSV() {
        return this.nameOfBone + "," + this.frame + "," + this.factor + "\n";
    }

    @Override
    protected byte[] toVMD() {
        ByteBuffer ret = ByteBuffer.allocate(23).order(ByteOrder.LITTLE_ENDIAN);
        try {
            byte[] a = this.nameOfBone.getBytes("MS932");
            ret.put(a);
            for (int i = a.length; i < 15; ++i) {
                ret.put((byte)0);
            }
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax error in MorphPose.toVMD.");
            System.exit(-1);
        }
        ret.putInt(this.frame);
        ret.putFloat(this.factor);
        return ret.array();
    }

    @Override
    public Pose clone() {
        return new MorphPose(this);
    }
}

