/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.TreeMap;

/**
 * 表示のon/offなど.
 * @author nazo
 */
public class BooleanPose extends Pose{

    /**
     * true: 表示する.
     */
    public boolean show;

    /**
     * ikのon/off. true: on.
     */
    public TreeMap<String,Boolean> iks;

    public BooleanPose(){
        super();
        nameOfBone="表示";
        show=true;
        iks=new TreeMap<String, Boolean>();
    }

    public BooleanPose(BooleanPose p){
        super(p);
        show=p.show;
        iks=new TreeMap<String,Boolean>();
        iks.putAll(p.iks);
    }

    static public BooleanPose fromCSV(String line) throws NumberFormatException{
        String [] column=CsvSpliter.split(line);
        if(column.length<3)return null;
        BooleanPose p=new BooleanPose();

        p.frame=Integer.parseInt(column[0]);
        p.show=(column[1].equalsIgnoreCase("TRUE"));
        p.iks=new TreeMap<String, Boolean>();
        int l=Integer.parseInt(column[2]);
        for(int i=0;i<l;i++){
            p.iks.put(column[3+i*2], column[4+i*2].equalsIgnoreCase("TRUE"));
        }
        return p;
    }

    @Override
    public String toCSV() {
        String ret=frame+","+show+","+iks.size();
        for(Map.Entry<String,Boolean> e: iks.entrySet()){
            ret+=","+e.getKey()+","+e.getValue();
        }
        return ret+"\n";
    }

    @Override
    protected byte[] toVMD() {
        int i,l;
        byte [] a;
        l=iks.size();
        ByteBuffer ret=ByteBuffer.allocate(9+l*21).order(ByteOrder.LITTLE_ENDIAN);
        ret.putInt(frame);
        ret.put((byte)(show?1:0));
        ret.putInt(l);
        try {
            for(Map.Entry<String,Boolean> e: iks.entrySet()){
                a=e.getKey().getBytes("MS932");
                ret.put(a);
                for(i=a.length;i<20;i++){
                    ret.put((byte)0);
                }
                ret.put((byte)(e.getValue()?1:0));
            }
        } catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax error in Pose.toVMD.");
            System.exit(-1);
        }

        return ret.array();
    }

    @Override
    @SuppressWarnings({"CloneDoesntCallSuperClone", "CloneDeclaresCloneNotSupported"})
    public Pose clone() {
        return new BooleanPose(this);
    }
}
