/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.math;

import jp.sfjp.mikutoga.math.EulerYXZ;
import jp.sfjp.mikutoga.math.MkPos3D;

public strictfp class MkQuat {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double DBL_PI = Math.PI * 2;
    private static final int STEP_BELOW = 5;
    private static final double BELOWONE;
    private double q1;
    private double q2;
    private double q3;
    private double qw;

    public MkQuat() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public MkQuat(MkQuat q) {
        this(q.q1, q.q2, q.q3, q.qw);
    }

    public MkQuat(double q1, double q2, double q3, double qw) {
        this.q1 = q1;
        this.q2 = q2;
        this.q3 = q3;
        this.qw = qw;
    }

    public static void mul(MkQuat qA, MkQuat qB, MkQuat result) {
        double aq1 = qA.getQ1();
        double aq2 = qA.getQ2();
        double aq3 = qA.getQ3();
        double aqw = qA.getQW();
        double bq1 = qB.getQ1();
        double bq2 = qB.getQ2();
        double bq3 = qB.getQ3();
        double bqw = qB.getQW();
        double rq1 = aq2 * bq3 - aq3 * bq2 + aqw * bq1 + aq1 * bqw;
        double rq2 = aq3 * bq1 - aq1 * bq3 + aqw * bq2 + aq2 * bqw;
        double rq3 = aq1 * bq2 - aq2 * bq1 + aqw * bq3 + aq3 * bqw;
        double rqw = aqw * bqw - aq1 * bq1 - aq2 * bq2 - aq3 * bq3;
        result.q1 = rq1;
        result.q2 = rq2;
        result.q3 = rq3;
        result.qw = rqw;
    }

    public static void conjugate(MkQuat q, MkQuat result) {
        result.q1 = -q.q1;
        result.q2 = -q.q2;
        result.q3 = -q.q3;
        result.qw = q.qw;
    }

    public static void normalize(MkQuat q, MkQuat result) {
        double abs = q.abs();
        double nq1 = q.q1 / abs;
        double nq2 = q.q2 / abs;
        double nq3 = q.q3 / abs;
        double nqw = q.qw / abs;
        result.q1 = nq1;
        result.q2 = nq2;
        result.q3 = nq3;
        result.qw = nqw;
    }

    public static void inverse(MkQuat q, MkQuat result) {
        double sum = 0.0;
        sum += q.q1 * q.q1;
        sum += q.q2 * q.q2;
        sum += q.q3 * q.q3;
        double nq1 = -q.q1 / (sum += q.qw * q.qw);
        double nq2 = -q.q2 / sum;
        double nq3 = -q.q3 / sum;
        double nqw = q.qw / sum;
        result.q1 = nq1;
        result.q2 = nq2;
        result.q3 = nq3;
        result.qw = nqw;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getQ3() {
        return this.q3;
    }

    public double getQW() {
        return this.qw;
    }

    public void setQ1(double q1Arg) {
        this.q1 = q1Arg;
    }

    public void setQ2(double q2Arg) {
        this.q2 = q2Arg;
    }

    public void setQ3(double q3Arg) {
        this.q3 = q3Arg;
    }

    public void setQW(double wArg) {
        this.qw = wArg;
    }

    public void setQ123W(double q1Arg, double q2Arg, double q3Arg, double wArg) {
        this.q1 = q1Arg;
        this.q2 = q2Arg;
        this.q3 = q3Arg;
        this.qw = wArg;
    }

    public double abs() {
        double sum = 0.0;
        sum += this.q1 * this.q1;
        sum += this.q2 * this.q2;
        sum += this.q3 * this.q3;
        double result = StrictMath.sqrt(sum += this.qw * this.qw);
        return result;
    }

    public void setPos3D(double xPos, double yPos, double zPos) {
        this.q1 = xPos;
        this.q2 = yPos;
        this.q3 = zPos;
        this.qw = 0.0;
    }

    public void setPos3D(MkPos3D pos) {
        this.setPos3D(pos.getXpos(), pos.getYpos(), pos.getZpos());
    }

    public void setEulerYXZ(double xRot, double yRot, double zRot) {
        double hx = xRot / 2.0;
        double hy = yRot / 2.0;
        double hz = zRot / 2.0;
        double chx = StrictMath.cos(hx);
        double chy = StrictMath.cos(hy);
        double chz = StrictMath.cos(hz);
        double shx = StrictMath.sin(hx);
        double shy = StrictMath.sin(hy);
        double shz = StrictMath.sin(hz);
        this.q1 = chy * shx * chz + shy * chx * shz;
        this.q2 = shy * chx * chz - chy * shx * shz;
        this.q3 = chy * chx * shz - shy * shx * chz;
        this.qw = chy * chx * chz + shy * shx * shz;
    }

    public void setEulerYXZ(EulerYXZ rot) {
        this.setEulerYXZ(rot.getXRot(), rot.getYRot(), rot.getZRot());
    }

    public void toEulerYXZ(EulerYXZ result, double oldY) {
        double resultZ;
        double resultY;
        double resultX;
        double qx = this.q1;
        double qy = this.q2;
        double qz = this.q3;
        double qqw = this.qw;
        double qx2 = qx * qx;
        double qy2 = qy * qy;
        double qz2 = qz * qz;
        double qwx = qqw * qx;
        double qwy = qqw * qy;
        double qwz = qqw * qz;
        double qxy = qx * qy;
        double qxz = qx * qz;
        double qyz = qy * qz;
        double m00 = 1.0 - 2.0 * (qy2 + qz2);
        double m01 = 2.0 * (qxy - qwz);
        double m02 = 2.0 * (qwy + qxz);
        double m10 = 2.0 * (qxy + qwz);
        double m11 = 1.0 - 2.0 * (qx2 + qz2);
        double m12 = 2.0 * (qyz - qwx);
        double m22 = 1.0 - 2.0 * (qx2 + qy2);
        if (StrictMath.abs(m12) >= BELOWONE) {
            resultX = -StrictMath.copySign(1.5707963267948966, m12);
            resultY = oldY;
            resultZ = StrictMath.atan2(-m01, m00);
            resultZ = resultX >= 0.0 ? (resultZ += resultY) : (resultZ -= resultY);
            if (StrictMath.abs(resultZ) > Math.PI) {
                resultZ -= StrictMath.copySign(Math.PI * 2, resultZ);
            }
        } else {
            resultX = StrictMath.asin(-m12);
            resultY = StrictMath.atan2(m02, m22);
            resultZ = StrictMath.atan2(m10, m11);
        }
        result.setXRot(resultX);
        result.setYRot(resultY);
        result.setZRot(resultZ);
    }

    public void toEulerYXZ(EulerYXZ result) {
        this.toEulerYXZ(result, 0.0);
    }

    public void rotatePos(MkPos3D pos, MkPos3D result) {
        double rQ1 = this.q1;
        double rQ2 = this.q2;
        double rQ3 = this.q3;
        double rQW = this.qw;
        double pQ1 = pos.getXpos();
        double pQ2 = pos.getYpos();
        double pQ3 = pos.getZpos();
        double pQW = 0.0;
        double rrQ1 = -rQ1;
        double rrQ2 = -rQ2;
        double rrQ3 = -rQ3;
        double rrQW = rQW;
        double rpQ1 = rQ2 * pQ3 - rQ3 * pQ2 + rQW * pQ1 + rQ1 * pQW;
        double rpQ2 = rQ3 * pQ1 - rQ1 * pQ3 + rQW * pQ2 + rQ2 * pQW;
        double rpQ3 = rQ1 * pQ2 - rQ2 * pQ1 + rQW * pQ3 + rQ3 * pQW;
        double rpQW = rQW * pQW - rQ1 * pQ1 - rQ2 * pQ2 - rQ3 * pQ3;
        double rprrQ1 = rpQ2 * rrQ3 - rpQ3 * rrQ2 + rpQW * rrQ1 + rpQ1 * rrQW;
        double rprrQ2 = rpQ3 * rrQ1 - rpQ1 * rrQ3 + rpQW * rrQ2 + rpQ2 * rrQW;
        double rprrQ3 = rpQ1 * rrQ2 - rpQ2 * rrQ1 + rpQW * rrQ3 + rpQ3 * rrQW;
        result.setXpos(rprrQ1);
        result.setYpos(rprrQ2);
        result.setZpos(rprrQ3);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("q1=").append(this.q1);
        result.append(" q2=").append(this.q2);
        result.append(" q3=").append(this.q3);
        result.append(" w=").append(this.qw);
        return result.toString();
    }

    static {
        double one = 1.0;
        for (int ct = 1; ct <= 5; ++ct) {
            one = StrictMath.nextAfter(one, 0.0);
        }
        BELOWONE = one;
        assert (BELOWONE < 1.0);
    }
}

