/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.ik_solver;

import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;

public class IKSolver {
    public static final int RLIMIT_LIMITED = 128;
    public static final int RLIMIT_NOGlobalR = 64;
    public static final int RLIMIT_NOX = 3;
    public static final int RLIMIT_NOY = 12;
    public static final int RLIMIT_NOZ = 48;
    protected static final double limit_sine = Math.sqrt(0.5);
    protected static final double limit_sine2 = 0.5;
    protected Bone[] bones;
    protected int[] limits;

    public void setBones(Bone[] arms) {
        this.bones = new Bone[arms.length];
        this.limits = new int[arms.length];
        for (int i = 0; i < arms.length; ++i) {
            this.bones[i] = arms[i];
            if (arms[i].getLimitRot() == null) continue;
            this.limits[i] = 128;
        }
    }

    public void setLimits(int index, int flags) {
        this.limits[index] = flags;
    }

    public int getLimits(int index) {
        return this.limits[index];
    }

    public double solve(Vector3D target) {
        Matrix gmr = null;
        double distance2 = 1.0;
        if ((this.limits[0] & 0x40) > 0) {
            gmr = this.bones[0].getGMatrix();
        }
        for (int i = 0; i < 100 && !((distance2 = target.sub(this.bones[0].getPos()).norm2()) < 1.0E-16); ++i) {
            for (int k = 1; k < this.bones.length; ++k) {
                double sine2;
                double co;
                Vector3D center = this.bones[k].getPos();
                Vector3D tr = target.sub(center);
                Vector3D ta = this.bones[0].getPos().sub(center);
                double norm2 = tr.norm2();
                if (norm2 == 0.0) continue;
                Vector3D ntr = tr.divide(Math.sqrt(norm2));
                norm2 = ta.norm2();
                if (norm2 == 0.0) continue;
                Vector3D nta = ta.divide(Math.sqrt(norm2));
                Vector3D rt = nta.cross(ntr);
                if (this.limits[k] > 0) {
                    Vector3D axis;
                    if ((this.limits[k] & 0x80) > 0) {
                        axis = this.bones[k].getLimitRot();
                        double sine = rt.times(axis);
                        rt = axis.times(sine);
                        co = Math.sqrt(1.0 - sine * sine);
                    } else {
                        if ((this.limits[k] & 3) > 0) {
                            axis = this.bones[k].getLx();
                            co = rt.times(axis);
                            rt = rt.sub(axis.times(co));
                        }
                        if ((this.limits[k] & 0xC) > 0) {
                            axis = this.bones[k].getLy();
                            co = rt.times(axis);
                            rt = rt.sub(axis.times(co));
                        }
                        if ((this.limits[k] & 0x30) > 0) {
                            axis = this.bones[k].getLz();
                            co = rt.times(axis);
                            rt = rt.sub(axis.times(co));
                        }
                        co = (sine2 = rt.norm2()) > 1.0 ? 0.0 : Math.sqrt(1.0 - sine2);
                    }
                } else {
                    sine2 = rt.norm2();
                    if (sine2 > 0.5) {
                        rt = rt.times(limit_sine / Math.sqrt(sine2));
                        co = limit_sine;
                    } else {
                        co = ntr.times(nta);
                    }
                }
                this.bones[k].rotate(rt, co);
            }
        }
        if ((this.limits[0] & 0x40) > 0) {
            this.bones[0].rotateToG(gmr);
        }
        return Math.sqrt(distance2);
    }
}

