/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sourceforge.mmd.midiMotion.MotionBuilder;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;

public class BassMotionBuilder
extends MotionBuilder {
    protected Motion playerTemp = null;
    protected Map<Integer, int[]> note2frames = new TreeMap<Integer, int[]>();
    protected Map<Integer, int[]> string2fingers = new TreeMap<Integer, int[]>();
    protected boolean finger = true;
    protected int lastNote = 0;

    public void setTemplate(Motion player) {
        this.playerTemp = player;
        this.motion.setModelName(player.getModelName());
    }

    public void loadFrameMap(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "MS932"));
        while (br.ready()) {
            String line = br.readLine();
            String[] p = CsvSpliter.split(line);
            if (p[0].charAt(0) == ';') continue;
            Integer note = new Integer(p[1]);
            this.note2frames.put(note, new int[]{Integer.parseInt(p[2]), Integer.parseInt(p[3]), Integer.parseInt(p[4])});
            if (note != 128) continue;
            this.string2fingers.put(Integer.parseInt(p[4]), new int[]{Integer.parseInt(p[2]), Integer.parseInt(p[3])});
        }
    }

    @Override
    public void loadMessages() {
        Pose[] ps;
        int[] list;
        if (this.playerTemp == null || this.note2frames.isEmpty()) {
            return;
        }
        MidiEvent[] bass = null;
        for (int i = 0; i < 16; ++i) {
            if (bass != null) continue;
            bass = this.mm.getChannelMessage(i);
        }
        this.reportProgressStart();
        for (MidiEvent me : bass) {
            int j;
            int vel;
            int note;
            ShortMessage sm = (ShortMessage)me.getMessage();
            int frame = this.ticsToframe(me.getTick());
            this.reportProgress(frame);
            int com = sm.getCommand();
            if (com == 144) {
                note = sm.getData1();
                vel = sm.getData2();
                list = this.note2frames.get(note);
                if (list == null) continue;
                j = list[0];
                if (j == 0) {
                    if (this.lastNote == 0) {
                        this.lastNote = note + 1;
                    } else {
                        int[] list2 = this.note2frames.get(this.lastNote);
                        this.lastNote += 5 * (list2[2] - list[2]);
                    }
                    list = this.note2frames.get(this.lastNote);
                    j = list[1];
                } else {
                    this.lastNote = note;
                }
                ps = this.playerTemp.get(j);
                this.motion.putAll(ps, frame);
                list = this.string2fingers.get(list[2]);
                ps = this.playerTemp.get(list[0] + (this.finger ? 0 : 2));
                this.motion.putAll(ps, frame - 1);
                ps = this.playerTemp.get(list[0] + (this.finger ? 2 : 0));
                this.motion.putAll(ps, frame + 1);
                this.finger = !this.finger;
                continue;
            }
            com = sm.getCommand();
            if (com != 128) continue;
            note = sm.getData1();
            vel = sm.getData2();
            list = this.note2frames.get(note);
            if (list == null) continue;
            j = list[0];
            if (j == 0) {
                list = this.note2frames.get(this.lastNote);
                j = list[1];
            } else {
                this.lastNote = note;
            }
            ps = this.playerTemp.get(j);
            this.motion.putAll(ps, frame - 1);
            ps = this.playerTemp.get(j == list[1] ? list[0] : list[1]);
            this.motion.putAll(ps, frame);
        }
        list = this.note2frames.get(0);
        ps = this.playerTemp.get(list[0]);
        this.motion.putAll(ps, 0);
        this.reportProgressEnd();
    }
}

