/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.ik_solver.IKSolver;
import jp.sourceforge.mmd.midiMotion.MotionBuilder;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class KeyBoardMotionBuilder
extends MotionBuilder {
    private static String[] rightHands = new String[]{"\u53f3\u4eba\u6307\uff13\u5148", "\u53f3\u4eba\u6307\uff11", "\u53f3\u624b\u9996", "\u53f3\u3072\u3058", "\u53f3\u8155"};
    private static String[] leftHands = new String[]{"\u5de6\u4eba\u6307\uff13\u5148", "\u5de6\u4eba\u6307\uff11", "\u5de6\u624b\u9996", "\u5de6\u3072\u3058", "\u5de6\u8155"};
    private static String[] keyName = new String[]{"C%d", "C%d#", "D%d", "D%d#", "E%d", "F%d", "F%d#", "G%d", "G%d#", "A%d", "A%d#", "B%d"};
    public static final int PROTOCOL_MIDI2VMD = 0;
    public static final int PROTOCOL_VOLONOI = 1;
    private Motion player = null;
    private Model playerModel = null;
    private Model keyModel = null;
    private Vector3D offset = new Vector3D(0.0, 0.0, -3.2);
    protected String bendW = null;
    protected String programChange = null;
    protected String damper = null;
    private IKSolver iksR = null;
    private IKSolver iksL = null;
    private double keyAngle = -4.0;
    private int center = 61;
    private int protocol = 0;

    public KeyBoardMotionBuilder() {
        this.motion.setModelName("Keyboard");
    }

    public KeyBoardMotionBuilder(Motion init) {
        super(init);
    }

    public void setPlayer(Motion motion, Model model) throws MmdFormatException {
        this.playerModel = model;
        if (this.playerModel == null) {
            return;
        }
        this.player = motion == null ? new Motion(model.getName()) : motion;
        try {
            this.iksR = new IKSolver();
            this.iksR.setBones(new Bone[]{this.playerModel.get(rightHands[2]), this.playerModel.get(rightHands[3]), this.playerModel.get(rightHands[4])});
            this.iksR.setLimits(0, 64);
            this.iksR.setLimits(1, 51);
            this.iksL = new IKSolver();
            this.iksL.setBones(new Bone[]{this.playerModel.get(leftHands[2]), this.playerModel.get(leftHands[3]), this.playerModel.get(leftHands[4])});
            this.iksL.setLimits(0, 64);
            this.iksL.setLimits(1, 51);
        }
        catch (NullPointerException ex) {
            throw new MmdFormatException("\u7279\u5b9a\u306e\u6307\u30dc\u30fc\u30f3\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093." + ex.getLocalizedMessage());
        }
    }

    public Motion getMotionPlayer() {
        return this.player;
    }

    public void setKeyboard(Motion motion, Model model) {
        if (motion != null) {
            this.motion = motion;
        }
        this.keyModel = model;
        this.motion.setModelName(model.getName());
    }

    public int getCenter() {
        return this.center;
    }

    public void setCenter(int aCenter) {
        this.center = aCenter;
    }

    public double getAngle() {
        return this.keyAngle;
    }

    public void setAngle(double angle) {
        this.keyAngle = angle;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public Vector3D getOffset() {
        return this.offset;
    }

    public void setOffset(Vector3D offset) {
        this.offset = offset;
    }

    public void setBendW(String s) {
        this.bendW = s;
    }

    public void setProgramChange(String s) {
        this.programChange = s;
    }

    public void setDamper(String damper) {
        this.damper = damper;
    }

    @Override
    public void loadMessages() {
        MidiEvent[] keys = null;
        int i = 0;
        while (keys == null) {
            if (i >= 16) {
                return;
            }
            keys = this.mm.getChannelMessage(i);
            ++i;
        }
        if (keys == null) {
            return;
        }
        int pitchBend = 0;
        int loaded = 0;
        if (this.playerModel != null) {
            this.playerModel.setPoses(this.player.get(0));
            this.playerModel.resetChanged();
        }
        if (this.keyModel != null) {
            this.keyModel.setPoses(this.motion.get(0));
            this.keyModel.resetChanged();
        }
        this.reportProgressStart();
        for (MidiEvent me : keys) {
            int note;
            int com;
            ShortMessage sm = (ShortMessage)me.getMessage();
            int frame = this.ticsToframe(me.getTick());
            this.reportProgress(frame);
            if (loaded < frame) {
                if (this.keyModel != null) {
                    this.keyModel.setPoses(this.motion.getInterporate(frame));
                    this.keyModel.resetChanged();
                }
                if (this.playerModel != null) {
                    Pose[] ps = this.player.getInterporate(frame);
                    this.playerModel.setPoses(ps);
                    this.playerModel.resetChanged();
                }
                loaded = frame;
            }
            if ((com = sm.getCommand()) == 144) {
                note = sm.getData1();
                int velo = sm.getData2();
                this.keyOn(frame, note, velo);
                continue;
            }
            if (com == 128) {
                note = sm.getData1();
                this.keyOff(frame, note);
                continue;
            }
            if (com == 224 && this.bendW != null) {
                int new_pitch = sm.getData1() + sm.getData2() * 128 - 8192;
                pitchBend = this.bendingWheel(frame, pitchBend, new_pitch);
                continue;
            }
            if (com == 192 && this.programChange != null) {
                this.programChange(frame);
                continue;
            }
            if (com != 176 || this.damper == null || sm.getData1() != 64) continue;
            this.damper(frame, sm.getData2());
        }
        this.reportProgressEnd();
    }

    private void keyOn(int frame, int note, int velo) {
        Vector3D finger;
        IKSolver iks;
        BonePose p = new BonePose();
        p.nameOfBone = this.getNodeBone(note);
        p.frame = frame - 1;
        this.motion.put(p);
        ++p.frame;
        p.mr = Matrix.rotation(this.keyAngle, 0.0, 0.0);
        this.motion.put(p);
        if (this.keyModel == null) {
            return;
        }
        Bone keyBone = this.keyModel.get(p.nameOfBone);
        if (keyBone == null) {
            return;
        }
        keyBone.setPose(p);
        if (this.playerModel == null) {
            return;
        }
        if (note > this.center) {
            iks = this.iksR;
            finger = this.playerModel.get(rightHands[2]).getPos().sub(this.playerModel.get(rightHands[0]).getPos());
        } else {
            iks = this.iksL;
            finger = this.playerModel.get(leftHands[2]).getPos().sub(this.playerModel.get(leftHands[0]).getPos());
        }
        this.playerModel.resetChanged();
        iks.solve(this.getVecter(note, 0.5 * (double)velo / 100.0).add(finger));
        Pose[] ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame - 1);
        this.playerModel.resetChanged();
        iks.solve(this.getVecter(note, 0.0).add(finger));
        ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame);
    }

    private void keyOff(int frame, int note) {
        Vector3D finger;
        IKSolver iks;
        BonePose p = new BonePose();
        p.nameOfBone = this.getNodeBone(note);
        p.frame = frame;
        this.motion.put(p);
        --p.frame;
        p.mr = Matrix.rotation(this.keyAngle, 0.0, 0.0);
        this.motion.put(p);
        if (this.keyModel == null) {
            return;
        }
        Bone keyBone = this.keyModel.get(p.nameOfBone);
        if (keyBone == null) {
            return;
        }
        keyBone.setPose(p);
        if (this.playerModel == null) {
            return;
        }
        if (note > this.center) {
            iks = this.iksR;
            finger = this.playerModel.get(rightHands[2]).getPos().sub(this.playerModel.get(rightHands[0]).getPos());
        } else {
            iks = this.iksL;
            finger = this.playerModel.get(leftHands[2]).getPos().sub(this.playerModel.get(leftHands[0]).getPos());
        }
        this.playerModel.resetChanged();
        iks.solve(this.getVecter(note, 0.0).add(finger));
        Pose[] ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame - 1);
        this.playerModel.resetChanged();
        iks.solve(this.getVecter(note, 0.3).add(finger));
        ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame);
    }

    private int bendingWheel(int frame, int old_pitch, int new_pitch) {
        BonePose p = new BonePose();
        p.nameOfBone = this.bendW;
        p.frame = frame - 1;
        p.mr = Matrix.rotation(60.0 * (double)old_pitch / 8192.0, 0.0, 0.0);
        this.motion.put(p);
        p.frame = frame;
        p.mr = Matrix.rotation(60.0 * (double)new_pitch / 8192.0, 0.0, 0.0);
        this.motion.put(p);
        if (this.keyModel == null || this.playerModel == null) {
            return new_pitch;
        }
        Vector3D finger = this.playerModel.get(leftHands[2]).getPos().sub(this.playerModel.get(leftHands[0]).getPos());
        Vector3D key_surface = this.keyModel.get(this.bendW).getPos();
        this.playerModel.resetChanged();
        this.iksL.solve(key_surface.add(new Vector3D(0.1, 0.35, 0.0).rotate_vector(new Vector3D(Math.sin(-((double)old_pitch) / 8192.0), 0.0, 0.0), Math.cos((double)old_pitch / 8192.0))).add(finger));
        Pose[] ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame - 1);
        this.playerModel.resetChanged();
        this.iksL.solve(key_surface.add(new Vector3D(0.0, 0.4, 0.0).rotate_vector(new Vector3D(Math.sin(-((double)new_pitch) / 8192.0), 0.0, 0.0), Math.cos((double)new_pitch / 8192.0))).add(finger));
        ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame);
        return new_pitch;
    }

    private void programChange(int frame) {
        if (this.keyModel == null || this.playerModel == null) {
            return;
        }
        Vector3D finger = this.playerModel.get(rightHands[2]).getPos().sub(this.playerModel.get(rightHands[0]).getPos());
        Bone key = this.keyModel.get(this.programChange);
        Vector3D key_surface = key.getPos();
        Matrix key_local_axis = key.getGMatrix();
        this.playerModel.resetChanged();
        this.iksR.solve(key_surface.add(key_local_axis.times(new Vector3D(0.0, 0.4, 0.0))).add(finger));
        Pose[] ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame - 1);
        this.playerModel.resetChanged();
        this.iksR.solve(key_surface.add(finger));
        ps = this.playerModel.getChanged();
        this.player.putAll(ps, frame);
    }

    private void damper(int frame, int value) {
        BonePose p = this.motion.getInterporateBone(frame, this.damper);
        p.nameOfBone = this.damper;
        p.frame = frame - 1;
        this.motion.put(p);
        p.frame = frame;
        p.mr = Matrix.rotation(value < 63 ? 0.0 : (value < 66 ? -4.0 : -8.0), 0.0, 0.0);
        this.motion.put(p);
        if (this.keyModel == null || this.playerModel == null) {
            return;
        }
        Bone tsumasaki = this.playerModel.get("\u53f3\u3064\u307e\u5148\uff29\uff2b");
        Bone kakato = this.playerModel.get("\u53f3\u8db3\uff29\uff2b");
        Bone pedal = this.keyModel.get(this.damper);
        Vector3D foot = kakato.getPos().sub(tsumasaki.getPos());
        Vector3D pedal_pre = pedal.getPos().add(foot);
        Vector3D aim = pedal.getLz().times(-1.0).add(pedal_pre);
        kakato.translationToG(aim);
        BonePose kakato_p = kakato.getPose();
        kakato_p.frame = frame - 1;
        this.player.put(kakato_p);
        pedal.setPose(p);
        aim = pedal.getLz().times(-1.0).add(pedal_pre);
        kakato.translationToG(aim);
        kakato_p = kakato.getPose();
        kakato_p.frame = frame;
        this.player.put(kakato_p);
    }

    private Vector3D getVecter(int note, double y) {
        Bone b = this.keyModel.get(this.getNodeBone(note));
        return b.getPos().add(b.getGMatrix().times(this.offset.add(new Vector3D(0.0, y, 0.0))));
    }

    private String getNodeBone(int note) {
        if (this.protocol == 0) {
            return String.format("nt%03d", note);
        }
        int octabe = note / 12;
        return String.format(keyName[note % 12], octabe - 1);
    }
}

