/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import jp.sfjp.mikutoga.bin.parser.CommonParser;
import jp.sfjp.mikutoga.bin.parser.MmdEofException;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.TextDecoder;
import jp.sfjp.mikutoga.pmd.ShadingUtil;
import jp.sfjp.mikutoga.pmd.parser.PmdBasicHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdBoneHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdMaterialHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdMorphHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdShapeHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdUnifiedHandler;

public class PmdParserBase
extends CommonParser {
    public static final Charset CS_WIN31J = Charset.forName("windows-31j");
    protected static final String CR = "\r";
    protected static final String LF = "\n";
    protected static final String CRLF = "\r\n";
    private static final int TRIVTX = 3;
    private static final int HEADER_LENGTH = 7;
    private static final byte[] MAGIC_BYTES = new byte[]{80, 109, 100, 0, 0, -128, 63};
    private final TextDecoder decoderWin31j = new TextDecoder(CS_WIN31J);
    private PmdBasicHandler basicHandler = PmdUnifiedHandler.EMPTY;
    private PmdShapeHandler shapeHandler = PmdUnifiedHandler.EMPTY;
    private PmdMaterialHandler materialHandler = PmdUnifiedHandler.EMPTY;
    private PmdBoneHandler boneHandler = PmdUnifiedHandler.EMPTY;
    private PmdMorphHandler morphHandler = PmdUnifiedHandler.EMPTY;
    private int boneCount = -1;
    private int morphCount = -1;
    private int boneGroupCount = -1;

    public PmdParserBase(InputStream source) {
        super(source);
        this.decoderWin31j.setZeroChopMode(true);
    }

    public static String chopLastLF(String name) {
        String result = name.endsWith(LF) ? name.substring(0, name.length() - 1) : name;
        return result;
    }

    public void setBasicHandler(PmdBasicHandler handler) {
        this.basicHandler = handler == null ? PmdUnifiedHandler.EMPTY : handler;
    }

    public void setShapeHandler(PmdShapeHandler handler) {
        this.shapeHandler = handler == null ? PmdUnifiedHandler.EMPTY : handler;
    }

    public void setMaterialHandler(PmdMaterialHandler handler) {
        this.materialHandler = handler == null ? PmdUnifiedHandler.EMPTY : handler;
    }

    public void setBoneHandler(PmdBoneHandler handler) {
        this.boneHandler = handler == null ? PmdUnifiedHandler.EMPTY : handler;
    }

    public void setMorphHandler(PmdMorphHandler handler) {
        this.morphHandler = handler == null ? PmdUnifiedHandler.EMPTY : handler;
    }

    protected int getBoneCount() {
        return this.boneCount;
    }

    protected int getMorphCount() {
        return this.morphCount;
    }

    protected int getBoneGroupCount() {
        return this.boneGroupCount;
    }

    protected String parsePmdText(int byteLen) throws IOException, MmdEofException, MmdFormatException {
        String result = this.parseString(this.decoderWin31j, byteLen);
        return result;
    }

    public void parsePmd() throws IOException, MmdFormatException {
        this.basicHandler.pmdParseStart();
        this.parseBody();
        boolean hasMoreData = this.hasMore();
        this.basicHandler.pmdParseEnd(hasMoreData);
    }

    protected void parseBody() throws IOException, MmdFormatException {
        this.parsePmdHeader();
        this.parseVertexList();
        this.parseSurfaceList();
        this.parseMaterialList();
        this.parseBoneList();
        this.parseIKList();
        this.parseMorphList();
        this.parseMorphOrderList();
        this.parseBoneGroupList();
        this.parseGroupedBoneList();
    }

    private void parsePmdHeader() throws IOException, MmdFormatException {
        byte[] header = new byte[7];
        this.parseByteArray(header);
        if (!Arrays.equals(header, MAGIC_BYTES)) {
            throw new MmdFormatException("unknown PMD-header type");
        }
        String modelName = this.parsePmdText(20);
        String description = this.parsePmdText(256);
        description = description.replace(CRLF, LF);
        this.basicHandler.pmdHeaderInfo(header);
        this.basicHandler.pmdModelInfo(modelName, description);
    }

    private void parseVertexList() throws IOException, MmdFormatException {
        int vertexNum = this.parseLeInt();
        this.shapeHandler.loopStart(PmdShapeHandler.VERTEX_LIST, vertexNum);
        for (int ct = 0; ct < vertexNum; ++ct) {
            float xPos = this.parseLeFloat();
            float yPos = this.parseLeFloat();
            float zPos = this.parseLeFloat();
            this.shapeHandler.pmdVertexPosition(xPos, yPos, zPos);
            float xVec = this.parseLeFloat();
            float yVec = this.parseLeFloat();
            float zVec = this.parseLeFloat();
            this.shapeHandler.pmdVertexNormal(xVec, yVec, zVec);
            float uVal = this.parseLeFloat();
            float vVal = this.parseLeFloat();
            this.shapeHandler.pmdVertexUV(uVal, vVal);
            int boneId1 = this.parseLeUShortAsInt();
            int boneId2 = this.parseLeUShortAsInt();
            int weightForB1 = this.parseUByteAsInt();
            this.shapeHandler.pmdVertexWeight(boneId1, boneId2, weightForB1);
            boolean hideEdge = this.parseBoolean();
            this.shapeHandler.pmdVertexEdge(hideEdge);
            this.shapeHandler.loopNext(PmdShapeHandler.VERTEX_LIST);
        }
        this.shapeHandler.loopEnd(PmdShapeHandler.VERTEX_LIST);
    }

    private void parseSurfaceList() throws IOException, MmdFormatException {
        int vertexNum = this.parseLeInt();
        if (vertexNum % 3 != 0) {
            throw new MmdFormatException();
        }
        int surfaceNum = vertexNum / 3;
        this.shapeHandler.loopStart(PmdShapeHandler.SURFACE_LIST, surfaceNum);
        for (int ct = 0; ct < surfaceNum; ++ct) {
            int vertexId1 = this.parseLeUShortAsInt();
            int vertexId2 = this.parseLeUShortAsInt();
            int vertexId3 = this.parseLeUShortAsInt();
            this.shapeHandler.pmdSurfaceTriangle(vertexId1, vertexId2, vertexId3);
            this.shapeHandler.loopNext(PmdShapeHandler.SURFACE_LIST);
        }
        this.shapeHandler.loopEnd(PmdShapeHandler.SURFACE_LIST);
    }

    private void parseMaterialList() throws IOException, MmdFormatException {
        int materialNum = this.parseLeInt();
        this.materialHandler.loopStart(PmdMaterialHandler.MATERIAL_LIST, materialNum);
        for (int ct = 0; ct < materialNum; ++ct) {
            this.parseColor();
            int toonidx = this.parseUByteAsInt();
            boolean hasEdge = this.parseBoolean();
            int surfaceCount = this.parseLeInt();
            String shadingFile = this.parsePmdText(20);
            String[] splitted = ShadingUtil.splitShadingFileInfo(shadingFile);
            String textureFile = splitted[0];
            String sphereFile = splitted[1];
            this.materialHandler.pmdMaterialShading(toonidx, textureFile, sphereFile);
            this.materialHandler.pmdMaterialInfo(hasEdge, surfaceCount);
            this.materialHandler.loopNext(PmdMaterialHandler.MATERIAL_LIST);
        }
        this.materialHandler.loopEnd(PmdMaterialHandler.MATERIAL_LIST);
    }

    private void parseColor() throws IOException, MmdFormatException {
        float red = this.parseLeFloat();
        float green = this.parseLeFloat();
        float blue = this.parseLeFloat();
        float alpha = this.parseLeFloat();
        this.materialHandler.pmdMaterialDiffuse(red, green, blue, alpha);
        float shininess = this.parseLeFloat();
        red = this.parseLeFloat();
        green = this.parseLeFloat();
        blue = this.parseLeFloat();
        this.materialHandler.pmdMaterialSpecular(red, green, blue, shininess);
        red = this.parseLeFloat();
        green = this.parseLeFloat();
        blue = this.parseLeFloat();
        this.materialHandler.pmdMaterialAmbient(red, green, blue);
    }

    private void parseBoneList() throws IOException, MmdFormatException {
        this.boneCount = this.parseLeUShortAsInt();
        this.boneHandler.loopStart(PmdBoneHandler.BONE_LIST, this.boneCount);
        for (int ct = 0; ct < this.boneCount; ++ct) {
            String boneName = this.parsePmdText(20);
            int parentId = this.parseLeUShortAsInt();
            int tailId = this.parseLeUShortAsInt();
            byte boneKind = this.parseByte();
            int srcId = this.parseLeUShortAsInt();
            this.boneHandler.pmdBoneInfo(boneName, boneKind);
            this.boneHandler.pmdBoneLink(parentId, tailId, srcId);
            float xPos = this.parseLeFloat();
            float yPos = this.parseLeFloat();
            float zPos = this.parseLeFloat();
            this.boneHandler.pmdBonePosition(xPos, yPos, zPos);
            this.boneHandler.loopNext(PmdBoneHandler.BONE_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.BONE_LIST);
    }

    private void parseIKList() throws IOException, MmdFormatException {
        int ikCount = this.parseLeUShortAsInt();
        this.boneHandler.loopStart(PmdBoneHandler.IK_LIST, ikCount);
        for (int ct = 0; ct < ikCount; ++ct) {
            int boneId = this.parseLeUShortAsInt();
            int targetId = this.parseLeUShortAsInt();
            int chainLength = this.parseUByteAsInt();
            int depth = this.parseLeUShortAsInt();
            float weight = this.parseLeFloat();
            this.boneHandler.pmdIKInfo(boneId, targetId, depth, weight);
            this.parseIKChainList(chainLength);
            this.boneHandler.loopNext(PmdBoneHandler.IK_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.IK_LIST);
    }

    private void parseIKChainList(int chainLength) throws IOException, MmdFormatException {
        this.boneHandler.loopStart(PmdBoneHandler.IKCHAIN_LIST, chainLength);
        for (int ct = 0; ct < chainLength; ++ct) {
            int childId = this.parseLeUShortAsInt();
            this.boneHandler.pmdIKChainInfo(childId);
            this.boneHandler.loopNext(PmdBoneHandler.IKCHAIN_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.IKCHAIN_LIST);
    }

    private void parseMorphList() throws IOException, MmdFormatException {
        this.morphCount = this.parseLeUShortAsInt();
        this.morphHandler.loopStart(PmdMorphHandler.MORPH_LIST, this.morphCount);
        for (int ct = 0; ct < this.morphCount; ++ct) {
            String morphName = this.parsePmdText(20);
            int vertexCount = this.parseLeInt();
            byte morphType = this.parseByte();
            this.morphHandler.pmdMorphInfo(morphName, morphType);
            this.parseMorphVertexList(vertexCount);
            this.morphHandler.loopNext(PmdMorphHandler.MORPH_LIST);
        }
        this.morphHandler.loopEnd(PmdMorphHandler.MORPH_LIST);
    }

    private void parseMorphVertexList(int vertexCount) throws IOException, MmdFormatException {
        this.morphHandler.loopStart(PmdMorphHandler.MORPHVERTEX_LIST, vertexCount);
        for (int ct = 0; ct < vertexCount; ++ct) {
            int vertexId = this.parseLeInt();
            float xPos = this.parseLeFloat();
            float yPos = this.parseLeFloat();
            float zPos = this.parseLeFloat();
            this.morphHandler.pmdMorphVertexInfo(vertexId, xPos, yPos, zPos);
            this.morphHandler.loopNext(PmdMorphHandler.MORPHVERTEX_LIST);
        }
        this.morphHandler.loopEnd(PmdMorphHandler.MORPHVERTEX_LIST);
    }

    private void parseMorphOrderList() throws IOException, MmdFormatException {
        int morphOrderCount = this.parseUByteAsInt();
        this.morphHandler.loopStart(PmdMorphHandler.MORPHORDER_LIST, morphOrderCount);
        for (int ct = 0; ct < morphOrderCount; ++ct) {
            int morphId = this.parseLeUShortAsInt();
            this.morphHandler.pmdMorphOrderInfo(morphId);
            this.morphHandler.loopNext(PmdMorphHandler.MORPHORDER_LIST);
        }
        this.morphHandler.loopEnd(PmdMorphHandler.MORPHORDER_LIST);
    }

    private void parseBoneGroupList() throws IOException, MmdFormatException {
        this.boneGroupCount = this.parseUByteAsInt();
        this.boneHandler.loopStart(PmdBoneHandler.BONEGROUP_LIST, this.boneGroupCount);
        for (int ct = 0; ct < this.boneGroupCount; ++ct) {
            String groupName = this.parsePmdText(50);
            groupName = PmdParserBase.chopLastLF(groupName);
            this.boneHandler.pmdBoneGroupInfo(groupName);
            this.boneHandler.loopNext(PmdBoneHandler.BONEGROUP_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.BONEGROUP_LIST);
    }

    private void parseGroupedBoneList() throws IOException, MmdFormatException {
        int groupedBoneCount = this.parseLeInt();
        this.boneHandler.loopStart(PmdBoneHandler.GROUPEDBONE_LIST, groupedBoneCount);
        for (int ct = 0; ct < groupedBoneCount; ++ct) {
            int boneId = this.parseLeUShortAsInt();
            int groupId = this.parseUByteAsInt();
            this.boneHandler.pmdGroupedBoneInfo(boneId, groupId);
            this.boneHandler.loopNext(PmdBoneHandler.GROUPEDBONE_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.GROUPEDBONE_LIST);
    }

    static {
        assert (MAGIC_BYTES.length == 7);
    }
}

