/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import jp.sfjp.mikutoga.xml.BotherHandler;
import jp.sfjp.mikutoga.xml.LocalXmlResource;
import jp.sfjp.mikutoga.xml.XmlResourceResolver;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class SchemaUtil {
    private SchemaUtil() {
        assert (false);
        throw new AssertionError();
    }

    public static SchemaFactory newSchemaFactory() {
        SchemaFactory result = SchemaUtil.newSchemaFactory(null);
        return result;
    }

    public static SchemaFactory newSchemaFactory(LSResourceResolver resolver) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(BotherHandler.HANDLER);
        schemaFactory.setResourceResolver(resolver);
        return schemaFactory;
    }

    private static Source toLocalSource(LocalXmlResource resource) throws MalformedURLException, IOException {
        URI localUri = resource.getLocalResource();
        URL localUrl = localUri.toURL();
        InputStream is = localUrl.openStream();
        is = new BufferedInputStream(is);
        StreamSource result = new StreamSource(is);
        return result;
    }

    private static Source[] toLocalSourceArray(LocalXmlResource[] resArray) throws MalformedURLException, IOException {
        ArrayList<Source> sourceList = new ArrayList<Source>(resArray.length);
        for (LocalXmlResource resource : resArray) {
            Source localSource = SchemaUtil.toLocalSource(resource);
            sourceList.add(localSource);
        }
        Source[] result = new Source[sourceList.size()];
        result = sourceList.toArray(result);
        return result;
    }

    public static Schema newSchema(XmlResourceResolver resolver, LocalXmlResource ... resArray) {
        Schema result;
        Source[] sources;
        for (LocalXmlResource resource : resArray) {
            resolver.putRedirected(resource);
        }
        try {
            sources = SchemaUtil.toLocalSourceArray(resArray);
        }
        catch (IOException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        SchemaFactory schemaFactory = SchemaUtil.newSchemaFactory(resolver);
        try {
            result = sources.length <= 0 ? schemaFactory.newSchema() : schemaFactory.newSchema(sources);
        }
        catch (SAXException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return result;
    }
}

