/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion;

/**
 * MMD モーション内の一つのボーンやカメラパラメターなどのキーポーズ.
 * @author nazo
 * @param <T> Pose の継承先の型. 自分のクラス名を入れる.
 */
public abstract class Pose <T extends Pose<T>>{
    /**
     * ボーン(やカメラなど)の名前
     */
    public String nameOfBone;
    /**
     * フレームナンバー
     */
    public int frame;

    /**
     * 無名で、フレームナンバーが0のコンストラクター.
     * 名前をつけないとモーションに含めないので、早いうちにつけること.
     * 名前は{@link #nameOfBone} に直接代入する。
     */
    public Pose() {
        frame=0;
    }

    /**
     * ポーズのクローン.
     * @param other クローン元.
     */
    public Pose(T other){
        nameOfBone=other.nameOfBone;
        frame=other.frame;
    }

    /**
     * clone 関数. {@link #Pose(Pose) } 同様に
     * オーバーライドすること.
     * @return クローンしたPose.
     */
    @Override
    abstract public T clone() ;

//    abstract static public void fromCSV(String line);

    /**
     * CSV 化するためのメソッド.
     * @return CSV 文字列1行
     */
    abstract public String toCSV();

    /**
     * VMD 化するためのメソッド.
     * @return VMDデータバイトのアレイ.
     */
    abstract protected byte[] toVMD();

    /**
     * ボーン名の比較.
     * フレームナンバーは問わない. {@link Motion#gc()}用.
     * @param p 比較先
     * @return ture 名前が同じなら
     */
    abstract public boolean equals(T p);
    protected boolean equals2(T p){
        if(p==null)return false;
        if(nameOfBone==null)return false;
        return (nameOfBone.compareTo(p.nameOfBone)==0);
    }
}
