/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.parser;

import java.io.IOException;
import jp.sfjp.mikutoga.bin.parser.BinParser;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ProxyParser;
import jp.sfjp.mikutoga.vmd.parser.VmdCameraHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdUnifiedHandler;

class VmdCameraParser
extends ProxyParser {
    private static final int BZ_SIZE = 4;
    private static final int BZXYZ_SIZE = 12;
    private static final int BZETC_SIZE = 12;
    private final byte[] xyzIntplt = new byte[12];
    private final byte[] etcIntplt = new byte[12];
    private VmdCameraHandler handler = VmdUnifiedHandler.EMPTY;

    VmdCameraParser(BinParser parser) {
        super(parser);
    }

    void setCameraHandler(VmdCameraHandler cameraHandler) {
        this.handler = cameraHandler == null ? VmdUnifiedHandler.EMPTY : cameraHandler;
    }

    void parse() throws IOException, MmdFormatException {
        int cameraMotionNo = this.parseLeInt();
        this.handler.loopStart(VmdCameraHandler.CAMERA_LIST, cameraMotionNo);
        for (int ct = 0; ct < cameraMotionNo; ++ct) {
            int keyFrameNo = this.parseLeInt();
            this.handler.vmdCameraMotion(keyFrameNo);
            float range = this.parseLeFloat();
            this.handler.vmdCameraRange(range);
            float xPos = this.parseLeFloat();
            float yPos = this.parseLeFloat();
            float zPos = this.parseLeFloat();
            this.handler.vmdCameraPosition(xPos, yPos, zPos);
            float latitude = this.parseLeFloat();
            float longitude = this.parseLeFloat();
            float roll = this.parseLeFloat();
            this.handler.vmdCameraRotation(latitude, longitude, roll);
            this.parseCameraXyzInterpolation();
            this.parseCameraEtcInterpolation();
            int angle = this.parseLeInt();
            boolean hasPerspective = !this.parseBoolean();
            this.handler.vmdCameraProjection(angle, hasPerspective);
            this.handler.loopNext(VmdCameraHandler.CAMERA_LIST);
        }
        this.handler.loopEnd(VmdCameraHandler.CAMERA_LIST);
    }

    private void parseCameraXyzInterpolation() throws IOException, MmdFormatException {
        this.parseByteArray(this.xyzIntplt);
        int idx = 0;
        byte xP1x = this.xyzIntplt[idx++];
        byte xP2x = this.xyzIntplt[idx++];
        byte xP1y = this.xyzIntplt[idx++];
        byte xP2y = this.xyzIntplt[idx++];
        byte yP1x = this.xyzIntplt[idx++];
        byte yP2x = this.xyzIntplt[idx++];
        byte yP1y = this.xyzIntplt[idx++];
        byte yP2y = this.xyzIntplt[idx++];
        byte zP1x = this.xyzIntplt[idx++];
        byte zP2x = this.xyzIntplt[idx++];
        byte zP1y = this.xyzIntplt[idx++];
        byte zP2y = this.xyzIntplt[idx++];
        assert (idx == this.xyzIntplt.length);
        this.handler.vmdCameraIntpltXpos(xP1x, xP1y, xP2x, xP2y);
        this.handler.vmdCameraIntpltYpos(yP1x, yP1y, yP2x, yP2y);
        this.handler.vmdCameraIntpltZpos(zP1x, zP1y, zP2x, zP2y);
    }

    private void parseCameraEtcInterpolation() throws IOException, MmdFormatException {
        this.parseByteArray(this.etcIntplt);
        int idx = 0;
        byte rP1x = this.etcIntplt[idx++];
        byte rP2x = this.etcIntplt[idx++];
        byte rP1y = this.etcIntplt[idx++];
        byte rP2y = this.etcIntplt[idx++];
        byte dP1x = this.etcIntplt[idx++];
        byte dP2x = this.etcIntplt[idx++];
        byte dP1y = this.etcIntplt[idx++];
        byte dP2y = this.etcIntplt[idx++];
        byte pP1x = this.etcIntplt[idx++];
        byte pP2x = this.etcIntplt[idx++];
        byte pP1y = this.etcIntplt[idx++];
        byte pP2y = this.etcIntplt[idx++];
        assert (idx == this.etcIntplt.length);
        this.handler.vmdCameraIntpltRotation(rP1x, rP1y, rP2x, rP2y);
        this.handler.vmdCameraIntpltRange(dP1x, dP1y, dP2x, dP2y);
        this.handler.vmdCameraIntpltProjection(pP1x, pP1y, pP2x, pP2y);
    }
}

