/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.geo;

import jp.sourceforge.mmd.motion.geo.Vector3D;

public class Matrix
implements Cloneable {
    private final double[] r = new double[9];

    public Matrix() {
        this.r[8] = 1.0;
        this.r[4] = 1.0;
        this.r[0] = 1.0;
        this.r[3] = 0.0;
        this.r[2] = 0.0;
        this.r[1] = 0.0;
        this.r[7] = 0.0;
        this.r[6] = 0.0;
        this.r[5] = 0.0;
    }

    public Matrix(double[] r) {
        for (int i = 0; i < 9; ++i) {
            this.r[i] = r[i];
        }
    }

    public boolean equals(Matrix m) {
        if (this == m) {
            return true;
        }
        if (m == null) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (this.r[i] == m.r[i]) continue;
            return false;
        }
        return true;
    }

    public Matrix(Matrix b) {
        for (int i = 0; i < 9; ++i) {
            this.r[i] = b.r[i];
        }
    }

    public Matrix clone() {
        return new Matrix(this.r);
    }

    public Matrix(Vector3D lx, Vector3D lz) {
        int i;
        double[] v = lx.toDouble();
        for (i = 0; i < 3; ++i) {
            this.r[i] = v[i];
        }
        v = lz.toDouble();
        for (i = 0; i < 3; ++i) {
            this.r[i + 6] = v[i];
        }
        v = lz.cross(lx).toDouble();
        for (i = 0; i < 3; ++i) {
            this.r[i + 3] = v[i];
        }
    }

    public static Matrix rotation(double rx, double ry, double rz) {
        double[] a = new double[9];
        a[0] = a[4] = Math.cos(rz * Math.PI / 180.0);
        a[3] = Math.sin(rz * Math.PI / 180.0);
        a[1] = -a[3];
        a[8] = 1.0;
        a[7] = 0.0;
        a[6] = 0.0;
        a[5] = 0.0;
        a[2] = 0.0;
        Matrix c = new Matrix(a);
        a[4] = a[8] = Math.cos(rx * Math.PI / 180.0);
        a[5] = Math.sin(rx * Math.PI / 180.0);
        a[7] = -a[5];
        a[0] = 1.0;
        a[6] = 0.0;
        a[3] = 0.0;
        a[2] = 0.0;
        a[1] = 0.0;
        Matrix b = new Matrix(a);
        Matrix r = b.times(c);
        a[0] = a[8] = Math.cos(ry * Math.PI / 180.0);
        a[2] = Math.sin(ry * Math.PI / 180.0);
        a[6] = -a[2];
        a[4] = 1.0;
        a[7] = 0.0;
        a[5] = 0.0;
        a[3] = 0.0;
        a[1] = 0.0;
        c = new Matrix(a);
        return c.times(r);
    }

    public static Matrix rotationQ(double nx, double ny, double nz, double w) {
        double[] a = new double[9];
        double[] s = new double[10];
        double norm = Math.sqrt(nx * nx + ny * ny + nz * nz + w * w);
        if (norm <= 0.0) {
            return null;
        }
        s[0] = (w /= norm) * w;
        s[1] = (nx /= norm) * nx;
        s[2] = (ny /= norm) * ny;
        s[3] = (nz /= norm) * nz;
        s[4] = w * nx;
        s[5] = w * ny;
        s[6] = w * nz;
        s[7] = nx * ny;
        s[8] = nx * nz;
        s[9] = ny * nz;
        a[0] = s[0] + s[1] - s[2] - s[3];
        a[4] = s[0] - s[1] + s[2] - s[3];
        a[8] = s[0] - s[1] - s[2] + s[3];
        a[1] = 2.0 * (s[7] + s[6]);
        a[2] = 2.0 * (s[8] - s[5]);
        a[3] = 2.0 * (s[7] - s[6]);
        a[5] = 2.0 * (s[9] + s[4]);
        a[6] = 2.0 * (s[8] + s[5]);
        a[7] = 2.0 * (s[9] - s[4]);
        return new Matrix(a);
    }

    public double[] angles() {
        double[] rv = new double[3];
        Vector3D pz = new Vector3D(this.r[6], 0.0, this.r[8]);
        double rz = pz.norm();
        rv[0] = Math.atan2(-this.r[7], rz);
        rv[1] = this.r[7] <= -1.0 || this.r[7] >= 1.0 ? 0.0 : Math.atan2(-this.r[6], this.r[8]);
        Vector3D tz = pz.divide(rz);
        Vector3D tx = tz.cross(new Vector3D(0.0, 1.0, 0.0));
        Vector3D ty = new Vector3D(this.r[6], this.r[7], this.r[8]).cross(tx);
        Vector3D x = new Vector3D(this.r[0], this.r[1], this.r[2]);
        rv[2] = Math.atan2(x.times(ty), -x.times(tx));
        int i = 0;
        while (i < 3) {
            int n = i++;
            rv[n] = rv[n] * 57.29577951308232;
        }
        return rv;
    }

    public double[] getQuotanions() {
        double[] q = new double[4];
        q[3] = this.r[0] + this.r[4] + this.r[8] + 1.0;
        q[0] = this.r[0] - this.r[4] - this.r[8] + 1.0;
        q[1] = -this.r[0] + this.r[4] - this.r[8] + 1.0;
        q[2] = -this.r[0] - this.r[4] + this.r[8] + 1.0;
        int biggest = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(q[i] > q[biggest])) continue;
            biggest = i;
        }
        q[biggest] = Math.sqrt(q[biggest]) * 0.5;
        double mult = 0.25 / q[biggest];
        if (biggest == 0) {
            q[1] = (this.r[1] + this.r[3]) * mult;
            q[2] = (this.r[2] + this.r[6]) * mult;
            q[3] = (this.r[5] - this.r[7]) * mult;
        } else if (biggest == 1) {
            q[0] = (this.r[1] + this.r[3]) * mult;
            q[2] = (this.r[5] + this.r[7]) * mult;
            q[3] = (this.r[6] - this.r[2]) * mult;
        } else if (biggest == 2) {
            q[0] = (this.r[2] + this.r[6]) * mult;
            q[1] = (this.r[5] + this.r[7]) * mult;
            q[3] = (this.r[1] - this.r[3]) * mult;
        } else {
            q[0] = (this.r[5] - this.r[7]) * mult;
            q[1] = (this.r[6] - this.r[2]) * mult;
            q[2] = (this.r[1] - this.r[3]) * mult;
        }
        return q;
    }

    public Vector3D getLx() {
        return new Vector3D(this.r);
    }

    public Vector3D getLy() {
        return new Vector3D(this.r[3], this.r[4], this.r[5]);
    }

    public Vector3D getLz() {
        return new Vector3D(this.r[6], this.r[7], this.r[8]);
    }

    public double trace() {
        return this.r[0] + this.r[4] + this.r[8];
    }

    public double det() {
        return this.getLx().times(this.getLy().cross(this.getLz()));
    }

    public Matrix rotate(Vector3D axis_sin, double co) {
        Matrix ret = new Matrix();
        for (int i = 0; i < 3; ++i) {
            Vector3D t = new Vector3D(this.r[i * 3], this.r[i * 3 + 1], this.r[i * 3 + 2]);
            double[] dt = t.rotate_vector(axis_sin, co).toDouble();
            ret.r[i * 3] = dt[0];
            ret.r[i * 3 + 1] = dt[1];
            ret.r[i * 3 + 2] = dt[2];
        }
        return ret;
    }

    public Matrix transpose() {
        Matrix ret = new Matrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ret.r[j * 3 + i] = this.r[i * 3 + j];
            }
        }
        return ret;
    }

    public Matrix inverse() throws ArithmeticException {
        int k;
        Matrix ret = new Matrix();
        double[] temp = new double[9];
        System.arraycopy(this.r, 0, temp, 0, 9);
        for (int i = 0; i < 3; ++i) {
            int j = i;
            while (-0.01 < temp[i * 3 + j] && temp[i * 3 + j] < 0.01) {
                if (++j != 3) continue;
                throw new ArithmeticException("The inverse Matrix does not exist.");
            }
            if (j > i) {
                for (k = 0; k < 9; k += 3) {
                    double t = temp[i + k];
                    temp[i + k] = temp[j + k];
                    temp[j + k] = t;
                    t = ret.r[i + k];
                    ret.r[i + k] = ret.r[j + k];
                    ret.r[j + k] = t;
                }
            }
            for (k = 0; k < 3; ++k) {
                int n = i + k * 3;
                ret.r[n] = ret.r[n] / temp[i * 4];
            }
            for (j = i + 1; j < 3; ++j) {
                int n = i + j * 3;
                temp[n] = temp[n] / temp[i * 4];
            }
            for (j = i + 1; j < 3; ++j) {
                for (k = 0; k < 9; k += 3) {
                    int n = j + k;
                    ret.r[n] = ret.r[n] - temp[j + i * 3] * ret.r[i + k];
                }
                for (k = (i + 1) * 3; k < 9; k += 3) {
                    int n = j + k;
                    temp[n] = temp[n] - temp[j + i * 3] * temp[i + k];
                }
            }
        }
        for (k = 0; k < 9; k += 3) {
            int n = k;
            ret.r[n] = ret.r[n] - temp[6] * ret.r[2 + k];
            int n2 = 1 + k;
            ret.r[n2] = ret.r[n2] - temp[7] * ret.r[2 + k];
            int n3 = k;
            ret.r[n3] = ret.r[n3] - temp[3] * ret.r[1 + k];
        }
        return ret;
    }

    public Matrix times(Matrix b) {
        Matrix ret = new Matrix();
        for (int i = 0; i < 9; i += 3) {
            for (int j = 0; j < 3; ++j) {
                ret.r[i + j] = this.r[j] * b.r[i] + this.r[j + 3] * b.r[i + 1] + this.r[j + 6] * b.r[i + 2];
            }
        }
        return ret;
    }

    public Vector3D times(Vector3D b) {
        double[] dr = new double[3];
        for (int i = 0; i < 3; ++i) {
            Vector3D t = new Vector3D(this.r[i], this.r[i + 3], this.r[i + 6]);
            dr[i] = t.times(b);
        }
        return new Vector3D(dr);
    }

    public Matrix power(double p) {
        double co;
        double si;
        if (p == 0.0) {
            return new Matrix();
        }
        if (p == 1.0) {
            return this;
        }
        if (p == -1.0) {
            return this.inverse();
        }
        double[] q = this.getQuotanions();
        Vector3D n = new Vector3D(q);
        double norm = n.norm();
        if (p == 0.5 || p == -0.5) {
            si = Math.sqrt((1.0 - q[3]) / 2.0) * (double)(p < 0.0 ? -1 : 1);
            co = Math.sqrt((1.0 + q[3]) / 2.0);
        } else {
            double angle = Math.atan2(norm, q[3]);
            si = Math.sin(angle * p);
            co = Math.cos(angle * p);
        }
        if (norm > 0.0) {
            n = n.times(si / norm);
            q = n.toDouble();
        } else {
            q[1] = 0.0;
            q[0] = 0.0;
            q[2] = si;
        }
        return Matrix.rotationQ(q[0], q[1], q[2], co);
    }

    public String toString() {
        return "" + this.r[0] + "," + this.r[3] + "," + this.r[6] + System.lineSeparator() + this.r[1] + "," + this.r[4] + "," + this.r[7] + System.lineSeparator() + this.r[2] + "," + this.r[5] + "," + this.r[8] + System.lineSeparator();
    }

    public double[] toDouble() {
        double[] ret = new double[9];
        for (int i = 0; i < 9; ++i) {
            ret[i] = this.r[i];
        }
        return ret;
    }
}

