/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.pmx.BoneFlags;
import jp.sfjp.mikutoga.pmx.parser.PmxBasicHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxBoneHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxMorphHandler;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.model.Morph;

public class PmxFileHander
implements PmxBoneHandler,
PmxBasicHandler,
PmxMorphHandler {
    protected static Vector3D absoluteZ = Vector3D.unitZ;
    protected Model model;
    protected Bone bone;
    protected Morph morph;
    protected short boneFlags;
    protected ArrayList<String> idToName;
    protected TreeMap<Integer, Integer> childToParent;
    protected TreeMap<Integer, Number[]> childToLinkParent;
    protected TreeMap<Integer, Integer> parentToTail;
    protected TreeMap<Integer, Vector3D> parentToOffset;

    public PmxFileHander(Model model) {
        this.model = model;
    }

    @Override
    public void pmxParseStart() {
        this.bone = null;
        this.boneFlags = 0;
        this.morph = null;
    }

    @Override
    public void pmxHeaderInfo(float version, int encode, int uv) throws MmdFormatException {
        if (version < 2.0f) {
            throw new MmdFormatException("Too old PMX file.");
        }
    }

    @Override
    public void pmxModelName(String name, String nameE) {
        this.model.setName(name);
    }

    @Override
    public void pmxModelDescription(String description, String descriptionE) {
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        if (stage == PmxBoneHandler.BONE_LIST) {
            this.idToName = new ArrayList();
            this.childToParent = new TreeMap();
            this.childToLinkParent = new TreeMap();
            this.parentToTail = new TreeMap();
            this.parentToOffset = new TreeMap();
        }
    }

    @Override
    public void pmxBoneInfo(String name, String nameE) {
        this.bone = new Bone(this.model);
        this.bone.name = name;
        this.idToName.add(name);
        this.bone.id = this.idToName.size() - 1;
    }

    @Override
    public void pmxBonePosition(float xPos, float yPos, float zPos) {
        this.bone.gv = new Vector3D(xPos, yPos, zPos);
    }

    @Override
    public void pmxBoneStructure(int parentId, int depth) {
        if (parentId != -1) {
            this.childToParent.put(this.idToName.size() - 1, parentId);
        }
    }

    @Override
    public void pmxBoneFlags(short flags) {
        this.boneFlags = flags;
        this.bone.flags = flags;
    }

    @Override
    public void pmxBoneOffset(float offX, float offY, float offZ) {
        if (offX != 0.0f || offY != 0.0f || offZ != 0.0f) {
            this.parentToOffset.put(this.idToName.size() - 1, new Vector3D(offX, offY, offZ));
        }
    }

    @Override
    public void pmxBoneArrowhead(int arrowId) {
        if (arrowId >= 0) {
            this.parentToTail.put(this.idToName.size() - 1, arrowId);
        }
    }

    @Override
    public void pmxBoneLink(int linkParent, float ratio) throws MmdFormatException {
        if (linkParent >= 0) {
            this.childToLinkParent.put(this.idToName.size() - 1, new Number[]{linkParent, Float.valueOf(BoneFlags.MOVE_LINK.check(this.boneFlags) ? ratio : 0.0f), Float.valueOf(BoneFlags.ROTATE_LINK.check(this.boneFlags) ? ratio : 0.0f)});
        }
    }

    @Override
    public void pmxBoneLocalAxis(float xx, float xy, float xz, float zx, float zy, float zz) {
        this.bone.setInicialLocalCoordinate(new Vector3D(xx, xy, xz), new Vector3D(-zx, -zy, -zz));
    }

    @Override
    public void pmxBoneRotateAxe(float x, float y, float z) {
        this.bone.limitRot = new Vector3D(x, y, z);
    }

    @Override
    public void pmxBoneExtraParent(int extraParent) {
    }

    @Override
    public void pmxBoneIKInfo(int targetId, int depth, float weight) {
    }

    @Override
    public void pmxIKChainInfo(int childId, float[] limit_rotation) {
    }

    @Override
    public void loopNext(ParseStage stage) {
        if (stage == PmxBoneHandler.BONE_LIST) {
            this.model.put(this.bone);
            this.bone = null;
        } else if (stage == PmxMorphHandler.MORPH_LIST) {
            this.model.put(this.morph);
            this.morph = null;
        }
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
        if (stage == PmxBoneHandler.BONE_LIST) {
            Bone parent;
            String name;
            Bone child;
            for (Map.Entry<Integer, Integer> entry : this.childToParent.entrySet()) {
                child = this.model.get(this.idToName.get(entry.getKey()));
                try {
                    this.model.get(this.idToName.get(entry.getValue())).addChild(child);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new MmdFormatException("Parent ID is not found. id:" + entry.getValue() + " from bone:" + child.name);
                }
            }
            for (Map.Entry<Integer, Integer> entry : this.childToLinkParent.entrySet()) {
                child = this.model.get(this.idToName.get(entry.getKey()));
                Number[] link = (Number[])entry.getValue();
                try {
                    this.model.get(this.idToName.get((Integer)link[0])).addLinkChild(child, ((Float)link[1]).floatValue(), ((Float)link[2]).floatValue());
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new MmdFormatException("Link parent ID is not found. id:" + link[0] + " from bone:" + child.name);
                }
            }
            for (Map.Entry<Integer, Object> entry : this.parentToOffset.entrySet()) {
                name = this.idToName.get(entry.getKey());
                if (this.model.get(name + "\u5148") != null) continue;
                parent = this.model.get(name);
                Bone arrowhead = new Bone(this.model);
                arrowhead.setName(name + "\u5148");
                arrowhead.gv = parent.getPos().add((Vector3D)entry.getValue());
                parent.addChild(arrowhead);
                this.idToName.add(arrowhead.getName());
                this.parentToTail.put(entry.getKey(), this.idToName.size() - 1);
                this.model.put(arrowhead);
            }
            for (Map.Entry<Integer, Object> entry : this.parentToTail.entrySet()) {
                String tail;
                name = this.idToName.get(entry.getKey());
                if (!name.matches("((\u5de6|\u53f3)(\u8155|\u3072\u3058|\u624b\u9996)|.*(\u89aa|\u4eba|\u4e2d|\u85ac|\u5c0f)\u6307.*)") || !(parent = this.model.get(name)).getMatrix().equals(new Matrix())) continue;
                try {
                    tail = this.idToName.get((Integer)entry.getValue());
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new MmdFormatException("Arrowhead is not found. id:" + entry.getValue() + " from bone: " + name);
                }
                Vector3D arrow = this.model.get(tail).getPos().sub(parent.getPos());
                double norm = (arrow = arrow.sub(absoluteZ.times(arrow.times(absoluteZ)))).norm();
                if (!(norm > 0.0)) continue;
                parent.setInicialLocalCoordinate(arrow.divide(norm), absoluteZ);
            }
        }
    }

    @Override
    public void pmxMorphInfo(String morphName, String morphNameE, byte panelType) throws MmdFormatException {
        this.morph = new Morph(this.model);
        this.morph.setName(morphName);
    }

    @Override
    public void pmxMorphElementListHeader(byte morphType, int numOfOffsets) throws MmdFormatException {
    }

    @Override
    public void pmxMorphVertexInfo(int vertexId, float xPos, float yPos, float zPos) throws MmdFormatException {
    }

    @Override
    public void pmxMorphUVInfo(int vertexId, float uPos, float vPos, float zPos, float wPos) throws MmdFormatException {
    }

    @Override
    public void pmxMorphBoneInfo(int boneId, float xPos, float yPos, float zPos, float qx, float qy, float qz, float qw) throws MmdFormatException {
        Bone b = this.model.get(this.idToName.get(boneId));
        BonePose bp = new BonePose();
        bp.nameOfBone = b.getName();
        bp.v = new Vector3D(xPos, yPos, zPos);
        bp.mr = Matrix.rotationQ(qx, qy, qz, qw);
        this.morph.addChild(b, bp);
    }

    @Override
    public void pmxMorphMaterialInfo(int materialId, byte type) throws MmdFormatException {
    }

    @Override
    public void pmxMorphMaterialDiffuse(float red, float green, float blue, float alpha) throws MmdFormatException {
    }

    @Override
    public void pmxMorphMaterialSpecular(float red, float green, float blue, float shininess) throws MmdFormatException {
    }

    @Override
    public void pmxMorphMaterialAmbient(float red, float green, float blue) throws MmdFormatException {
    }

    @Override
    public void pmxMorphMaterialEdges(float red, float green, float blue, float alpha, float thick) throws MmdFormatException {
    }

    @Override
    public void pmxMorphMaterialTexture(float red, float green, float blue, float alpha) throws MmdFormatException {
    }

    @Override
    public void pmxMorphMaterialSphere(float red, float green, float blue, float alpha) throws MmdFormatException {
    }

    @Override
    public void pmxMorphMaterialToon(float red, float green, float blue, float alpha) throws MmdFormatException {
    }

    @Override
    public void pmxMorphGroupInfo(int morphId, float ratio) throws MmdFormatException {
    }

    @Override
    public void pmxParseEnd(boolean hasMoreData) {
    }
}

