﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Stages
{
    /// <summary>
    /// MikuMikuDanceで用いるカメラ
    /// 仮組み。最終的にどうするかは未定。
    /// このままでもいい気もするけど……
    /// </summary>
    public class MMDCamera
    {
        /// <summary>
        /// カメラのポジション
        /// </summary>
        public Vector3 CameraPos { get; set; }
        /// <summary>
        /// カメラの視点
        /// </summary>
        public Vector3 CameraTarget { get; set; }
        /// <summary>
        /// カメラの上方向を表すベクトル
        /// </summary>
        public Vector3 CameraUpVector { get; set; }
        /// <summary>
        /// 視野角
        /// </summary>
        public float FieldOfView { get; set; }
        /// <summary>
        /// Nearプレーン距離
        /// </summary>
        public float Near { get; set; }
        /// <summary>
        /// Farプレーン距離
        /// </summary>
        public float Far { get; set; }
        /// <summary>
        /// 既定のコンストラクタ
        /// </summary>
        internal MMDCamera()
        {
            //CameraPos = new Vector3(-35, 10, 0);
            CameraPos = new Vector3(0, 10, 35);
            CameraTarget = new Vector3(0, 10, 0);
            CameraUpVector = Vector3.Up;
            FieldOfView = MathHelper.PiOver4;
            Near = 1.0f;
            Far = 10000.0f;
        }
        /// <summary>
        /// ビューマトリックス取得
        /// </summary>
        /// <returns>ビューマトリックス</returns>
        public Matrix GetViewMatrix()
        {
            return Matrix.CreateLookAt(CameraPos, CameraTarget, CameraUpVector);
        }
        /// <summary>
        /// プロジェクションマトリックス取得
        /// </summary>
        /// <param name="graphics">グラフィックデバイスオブジェクト</param>
        /// <returns>プロジェクションマトリックス</returns>
        public Matrix GetProjectionMatrix(GraphicsDevice graphics)
        {
            Viewport viewport = graphics.Viewport;
            float aspectRatio = (float)viewport.Width / (float)viewport.Height;
            return Matrix.CreatePerspectiveFieldOfView(FieldOfView, aspectRatio, Near, Far);
        }
    }
}
