﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Stages
{
    /// <summary>
    /// ライト
    /// </summary>
    public struct MMDLight
    {
        /// <summary>
        /// ライトの方向ベクトル
        /// </summary>
        public Vector3 Direction;
        /// <summary>
        /// カラー
        /// </summary>
        public Color Color;
        internal MMDLight(Vector3 dir, Color color)
        {
            Direction = dir;
            Color = color;
        }
        internal void SetParameters(out Vector3 dir, out Vector3 color)
        {
            dir = Direction;
            dir.Normalize();
            color = Color.ToVector3();
        }
    }
    
}
