using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using Microsoft.Xna.Framework.Graphics;
using MikuMikuDance.Motion.Motion2;
using MikuMikuDance.XNA.Motion.MotionData;
using TInput = MikuMikuDance.XNA.Motion.BakeMotionSet;
using TOutput = MikuMikuDance.XNA.Motion.MMDBakedMotion;
using MikuMikuDance.Model;
using MikuMikuDance.XNA.Model;
using MikuMikuDance.XNA.Model.ModelData;
using MikuMikuDance.Motion;

namespace MikuMikuDance.XNA.Motion
{
    /// <summary>
    /// xCNς݃[V쐬vZbT
    /// </summary>
    [ContentProcessor(DisplayName = "MikuMikuDance[VxCN : MikuMikuDance for XNA")]
    public class MMDBakedMotionProcessor : ContentProcessor<TInput, TOutput>
    {
        /// <summary>
        /// [ṼxCN
        /// </summary>
        /// <param name="input">xCN[VZbg</param>
        /// <param name="context">xCNς݃[V</param>
        /// <returns></returns>
        public override TOutput Process(TInput input, ContentProcessorContext context)
        {
            //[V̕ϊ
            string modelName = input.model.Name;
            MMDMotion2 motion2 = MotionManager.Read(input.motion.Filename, MikuMikuDance.Motion.CoordinateType.LeftHanded) as MMDMotion2;
            MMDModelIntermediate modelInter = context.BuildAndLoadAsset<MMDModelIntermediate, MMDModelIntermediate>(input.model, null);
            MMDMotionProcessor motionProc = new MMDMotionProcessor();
            MMDProcessor modelProc = new MMDProcessor();
            MMDMotionData motionData = motionProc.Process(motion2, context);
            MMDModelContext model = modelProc.Process(modelInter, context);
            //xCN[`ŃxCN
            int NumThread;
            //_RA擾āAœKXbh擾
            Win32API.SYSTEM_INFO info = new Win32API.SYSTEM_INFO();
            Win32API.GetSystemInfo(ref info);
            NumThread = (int)info.dwNumberOfProcessors;
            //MikuMikuDance for XNÃxCN@\ĂяoāÃ^C~OŃxCNs
            //̏Ƀm[}[VgbN𐶐
            NormalMotionTrack normal = new NormalMotionTrack();
            MMDMotion motion = new MMDMotion();
            motion.Initialize(motionData);
            normal.Motion = motion;
            normal.IsEmpty = false;
            //MMDModelDatav̂Af|Sf[^זōȂ̂ŁAꔲŖ
            MMDModelData ModelData = new MMDModelData();
            ModelData.Bones = model.Bones;
            ModelData.Joints = model.Joints;
            ModelData.ModelData = null;//ꂾ͈xoȂƍȂccAxCNɂ͗vȂ̂Ŗ
            ModelData.NumVertexForFace = model.NumVertexForFace;
            ModelData.Rigids = model.Rigids;
            ModelData.Skins = model.Skins;
            //ff[^A{[}l[WƃtFCX}l[W𐶐
            MMDBoneManager BoneManager = new MMDBoneManager(ModelData);
            MMDFaceManager FaceManager = new MMDFaceManager(ModelData);
            //MikuMikuDance for XNÃxCN@\ĂяoăxCN
            TOutput result = AnimationBaker.Bake(NumThread, normal, BoneManager, FaceManager);
            //fi[
            result.ModelName = modelName;
            return result;
        }
    }
}