﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Stages
{
    /// <summary>
    /// ライトマネージャクラス
    /// </summary>
    public class MMDLightManager : GameComponent
    {
        //const int NumLight = 3;
        //Vector3[] m_dir = new Vector3[NumLight], m_color = new Vector3[NumLight], m_spec = new Vector3[NumLight];
        /// <summary>
        /// ライトアニメーションプレイヤー
        /// </summary>
        public LightAnimationPlayer Player { get; set; }

        /// <summary>
        /// 環境光の色
        /// </summary>
        /// <remarks>MMDにおける照明色はこの項目が相当</remarks>
        public Color AmbientLight = new Color(154, 154, 154);

        /// <summary>
        /// キーライト
        /// </summary>
        /// <remarks>MMDの照明方向はこの項目が相当</remarks>
        public MMDLight KeyLight = new MMDLight(new Vector3(-0.5f, -1f, -0.5f), new Color(80, 80, 80), LightType.DirectionalLight);//new Color(154, 154, 154));


        internal MMDLightManager(Game game)
            : base(game)
        {
            Player = new LightAnimationPlayer(this);
        }

        internal void GetParameters(out Vector3 dir, out Vector3 color)
        {
            KeyLight.SetParameters(out dir, out color);
        }
        /// <summary>
        /// ライトUpdate
        /// </summary>
        /// <param name="gameTime">ゲームタイムオブジェクト</param>
        public override void Update(GameTime gameTime)
        {
            Player.Update(-1);
        }

        //TODO: 1.2aには削除
        #region MMDのライトアニメーションに合わせるため、廃止
        /// <summary>
        /// フィルライト
        /// </summary>
        [Obsolete("Lightに統合", true)]
        public MMDLight FillLight = new MMDLight(new Vector3(-1, 1, -1),
                new Color(148, 139, 103),LightType.DirectionalLight);
        /// <summary>
        /// バックライト
        /// </summary>
        [Obsolete("Lightに統合", true)]
        public MMDLight BackLight = new MMDLight(new Vector3(-1, -1, -1),
                new Color(82, 92, 100), LightType.DirectionalLight);
        /// <summary>
        /// ライト
        /// </summary>
        /// <param name="i">0=キー、1=フィル、2=バック</param>
        /// <returns>ライト構造体</returns>
        [Obsolete("Lightを使用して下さい", true)]
        public MMDLight this[int i]
        {
            get
            {
                switch (i)
                {
                    case 0:
                        return KeyLight;
                    case 1:
                        return FillLight;
                    case 2:
                        return BackLight;
                }
                throw new ApplicationException();
            }
        }



        
        #endregion

        long beforeTicks = 0;//前回更新tick
        internal void SetEffectParam(Effect effect, long totalTicks)
        {
            if (beforeTicks == totalTicks)
                return;//このフレームは既にセット済み
            //エフェクトの中でsharedになっているパラメータなので、セットする
            //ライティング設定の取得
            Vector3 LightVector, LightColor;
            GetParameters(out LightVector, out LightColor);
            //ライティングセット
            effect.Parameters["AmbientLightColor"].SetValue(AmbientLight.ToVector3());
            effect.Parameters["DirLight0Direction"].SetValue(LightVector);
            effect.Parameters["DirLight0DiffuseColor"].SetValue(LightColor);
            beforeTicks = totalTicks;
        }
    }
}
