#!/usr/bin/env bash
#==========================================================================
# Initial author of this file: Martin.Vahi@softf1.com
# This file is in public domain.
# The following line is a spdx.org license label line:
# SPDX-License-Identifier: 0BSD
#
# The main control flow entry in this script is the func_main(),
# which resides near the end of this file. The structure of this file:
#
#     <boilerplate, the library of reusable Bash functions>
#     func_initialize_configuration_by_initializing_global_variables
#     func_main()
#
#==========================================================================
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
S_FP_ORIG="`pwd`"
#--------------------------------------------------------------------------

MMMV_BASH_BOILERPLATE_VERSION="subject_to_initialisation"
func_mmmv_bash_boilerplate_version(){
    local S_GUID="526be9e2-7b4f-4060-b4c0-c071704067e7"
    local S_TIMESTAMP="_subject_to_initialisation_"
# RENESSAATOR_BLOCK_START
# RENESSAATOR_BLOCK_ID=block_566c89e2-c6f0-12ed-9d8a-1c6f6552f9e6_city
# RENESSAATOR_SOURCE_LANGUAGE=Ruby
# RENESSAATOR_SOURCE_START
# ob_t=Time.now
# s_t="_⏳_"
# s_t<<("y"+ob_t.year.to_s)
# s_t<<"_"
# s_t<<("m"+ob_t.month.to_s)
# s_t<<"_"
# s_t<<("d"+ob_t.day.to_s)
# s_t<<"_"
# s_t<<("h"+ob_t.hour.to_s)
# s_t<<"_"
# s_t<<("m"+ob_t.min.to_s)
# s_t<<"_"
# s_t<<("s"+ob_t.sec.to_s)
# s_t<<"_"
# s_t<<("μ"+ob_t.usec.to_s)
# s_t<<"_☕_"
# puts("    S_TIMESTAMP=\""+s_t+"\"")
# RENESSAATOR_SOURCE_END
# 
# RENESSAATOR_AUTOGENERATED_TEXT_START
    S_TIMESTAMP="_⏳_y2023_m3_d21_h3_m7_s46_μ436937_☕_"

# RENESSAATOR_AUTOGENERATED_TEXT_END
# RENESSAATOR_BLOCK_END
    MMMV_BASH_BOILERPLATE_VERSION="mmmv_bash_boilerplate_t3_$S_TIMESTAMP$S_GUID"
} # func_mmmv_bash_boilerplate_version
func_mmmv_bash_boilerplate_version

#--------------------------------------------------------------------------

func_mmmv_wait_and_sync_t1(){
    wait # for background processes started by this Bash script to exit/finish
    sync # network drives, USB-sticks, etc.
    wait # for sync
} # func_mmmv_wait_and_sync_t1

#--------------------------------------------------------------------------
func_mmmv_init_s_timestamp_if_not_inited_t1(){
    if [ "$S_TIMESTAMP" == "" ]; then
        if [ "`which date 2> /dev/null`" != "" ]; then
            S_TIMESTAMP="`date +%Y`_`date +%m`_`date +%d`_T_`date +%H`h_`date +%M`min_`date +%S`s"
        else
            S_TIMESTAMP="0000_00_00_T_00h_00min_00s"
            echo ""
            echo -e "The console program \"\e[31mdate\e[39m\" is missing from the PATH."
            echo "Using a constant value, "
            echo ""
            echo "    S_TIMESTAMP=\"$S_TIMESTAMP\""
            echo ""
            echo "GUID=='2790c935-e30b-4c55-82c0-c071704067e7'"
            echo ""
        fi
    fi
} # func_mmmv_init_s_timestamp_if_not_inited_t1

#--------------------------------------------------------------------------

func_mmmv_verify_S_FP_ORIG_but_do_not_exit_t1(){
    SB_S_FP_ORIG_VERIFICATION_FAILED="f"
    if [ "$S_FP_ORIG" == "" ]; then 
        SB_S_FP_ORIG_VERIFICATION_FAILED="t"
        echo ""
        echo -e "\e[31mThe code of this script has the flaw\e[39m that"
        echo "the variable S_FP_ORIG has not been set."
        echo "GUID=='55afec62-ea8e-4d13-b3c0-c071704067e7'"
        echo ""
    else
        if [ ! -e "$S_FP_ORIG" ]; then 
            SB_S_FP_ORIG_VERIFICATION_FAILED="t"
            echo ""
            echo -e "\e[31mThe code of this script has the flaw\e[39m that "
            echo "the variable S_FP_ORIG has been declared, but "
            echo "its value is some string that is not a file or folder path."
            echo "It is expected to be a folder path."
            echo ""
            echo "    S_FP_ORIG==\"$S_FP_ORIG\""
            echo ""
            echo "GUID=='4ba56381-c99e-4682-97c0-c071704067e7'"
            echo ""
        else
            if [ ! -d "$S_FP_ORIG" ]; then 
                SB_S_FP_ORIG_VERIFICATION_FAILED="t"
                echo ""
                echo -e "\e[31mThe code of this script has the flaw\e[39m that "
                echo "the variable S_FP_ORIG references a file, but "
                echo "it is expected to reference a folder."
                echo ""
                echo "    S_FP_ORIG==$S_FP_ORIG"
                echo ""
                echo "GUID=='2eb83ee1-fd10-4e99-b9b0-c071704067e7'"
                echo ""
            fi
        fi
    fi
    #----------------------------------------------------------------------
    # exit 1 # must NOT be called in ~/.bashrc, because 
             # exiting from the ~/.bashrc exits the session.
    #----------------------------------------------------------------------
    # Usage example:
    #    func_mmmv_verify_S_FP_ORIG_but_do_not_exit_t1
    #    if [ "$SB_S_FP_ORIG_VERIFICATION_FAILED" == "f" ]; then 
    #        cd "$S_FP_ORIG"
    #    else 
    #        echo ""
    #        echo "The code of this script is flawed."
    #        echo "GUID=='15c8faa4-7d45-4007-bcb0-c071704067e7'"
    #        echo ""
    #    fi
} # func_mmmv_verify_S_FP_ORIG_but_do_not_exit_t1

#--------------------------------------------------------------------------
SB_FUNC_MMMV_VERIFY_S_FP_ORIG_BUT_DO_NOT_EXIT_T2_S_FB_ORIG_ALREADY_VERIFIED="f"
func_mmmv_verify_S_FP_ORIG_but_do_not_exit_t2(){
    if [ "$SB_FUNC_MMMV_VERIFY_S_FP_ORIG_BUT_DO_NOT_EXIT_T2_S_FB_ORIG_ALREADY_VERIFIED" != "t" ]; then
        if [ "$SB_FUNC_MMMV_VERIFY_S_FP_ORIG_BUT_DO_NOT_EXIT_T2_S_FB_ORIG_ALREADY_VERIFIED" != "f" ]; then
            echo ""
            echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
            echo "The global variable "
            echo ""
            echo "    SB_FUNC_MMMV_VERIFY_S_FP_ORIG_BUT_DO_NOT_EXIT_T2_S_FB_ORIG_ALREADY_VERIFIED==\"$SB_FUNC_MMMV_VERIFY_S_FP_ORIG_BUT_DO_NOT_EXIT_T2_S_FB_ORIG_ALREADY_VERIFIED\""
            echo ""
            echo "has a domain of {\"f\", \"t\"}."
            echo "GUID=='173f7042-eea9-4a1f-b2b0-c071704067e7'"
            echo ""
        else
            func_mmmv_verify_S_FP_ORIG_but_do_not_exit_t1
            SB_FUNC_MMMV_VERIFY_S_FP_ORIG_BUT_DO_NOT_EXIT_T2_S_FB_ORIG_ALREADY_VERIFIED="t"
        fi
    fi
} # func_mmmv_verify_S_FP_ORIG_but_do_not_exit_t2

#--------------------------------------------------------------------------
SB_NO_ERRORS_YET="t" # domain=={"t","f"} 
func_mmmv_assert_nonempty_string_but_do_not_exit_t1(){
    local S_IN="$1"
    local S_VARIABLE_NAME_IN_CALLING_CODE="$2"
    local S_GUID_CANDIDATE="$3"
    #----------------------------------------------------------------------
    local SB_NO_ERRORS_YET_1="t"
    if [ "$S_GUID_CANDIDATE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "GUID=='da03de14-6762-4ae0-85a0-c071704067e7'"
        echo ""
        SB_NO_ERRORS_YET_1="f"
    fi
    #--------------------
    if [ "$SB_NO_ERRORS_YET" != "t" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
        echo "The global variable "
        echo ""
        echo "    SB_NO_ERRORS_YET==\"$SB_NO_ERRORS_YET\""
        echo ""
        if [ "$SB_NO_ERRORS_YET" == "f" ]; then 
            echo "is expected to be initialized to \"t\" before calling this function."
            echo "GUID=='b4125021-fe9c-4240-85a0-c071704067e7'"
        else
            echo "is expected to be initialized to \"t\" before calling this function"
            echo "and its domain is {\"f\", \"t\"}."
            echo "GUID=='836fb84d-22aa-4600-85a0-c071704067e7'"
        fi
        if [ "$SB_NO_ERRORS_YET_1" == "t" ]; then 
            echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        fi
        echo ""
        SB_NO_ERRORS_YET="f"
    fi
    #--------------------
    if [ "$SB_NO_ERRORS_YET_1" == "f" ]; then 
        SB_NO_ERRORS_YET="f"
    fi
    #----------------------------------------------------------------------
    if [ "$SB_NO_ERRORS_YET" == "t" ]; then 
        if [ "$S_VARIABLE_NAME_IN_CALLING_CODE" == "" ]; then 
            echo ""
            echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
            echo ""
            echo "    S_VARIABLE_NAME_IN_CALLING_CODE==\"\""
            echo ""
            echo "GUID=='a1d72841-22bb-41b3-a290-c071704067e7'"
            if [ "$SB_NO_ERRORS_YET_1" == "t" ]; then  # should be always true at this line
                echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi
            echo ""
            SB_NO_ERRORS_YET="f"
        fi
    fi
    #----------------------------------------------------------------------
    if [ "$SB_NO_ERRORS_YET" == "t" ]; then 
        if [ "$S_IN" == "" ]; then 
            echo ""
            echo -e "\e[31mThere is a flaw somewhere in the code\e[39m that"
            echo "uses a variable named \"$S_VARIABLE_NAME_IN_CALLING_CODE\"." 
            echo ""
            echo "    $S_VARIABLE_NAME_IN_CALLING_CODE==\"$S_IN\""
            echo ""
            echo "but it is expected to be something other than an empty string."
            echo "GUID=='287a81f4-1875-41ac-9d80-c071704067e7'"
            if [ "$SB_NO_ERRORS_YET_1" == "t" ]; then  # should be always true at this line
                echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi
            echo ""
            SB_NO_ERRORS_YET="f"
        fi
    fi
    #----------------------------------------------------------------------
} # func_mmmv_assert_nonempty_string_but_do_not_exit_t1

#--------------------------------------------------------------------------
# SB_NO_ERRORS_YET="t" # domain=={"t","f"}, initial declaration resides upwards from this line
func_mmmv_assert_sbvar_domain_t_f_but_do_not_exit_t1(){
    local SB_VARIABLE_VALUE="$1"
    local S_VARIABLE_NAME_IN_CALLING_CODE="$2"
    local S_GUID_CANDIDATE="$3"
    #----------------------------------------------------------------------
    local SB_NO_ERRORS_YET_1="t"
    if [ "$S_GUID_CANDIDATE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "GUID=='548a81c9-981c-4992-9680-c071704067e7'"
        echo ""
        SB_NO_ERRORS_YET_1="f"
    fi
    #--------------------
    if [ "$SB_NO_ERRORS_YET" != "t" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
        echo "The global variable "
        echo ""
        echo "    SB_NO_ERRORS_YET==\"$SB_NO_ERRORS_YET\""
        echo ""
        if [ "$SB_NO_ERRORS_YET" == "f" ]; then 
            echo "is expected to be initialized to \"t\" before calling this function."
            echo "GUID=='b998f04c-32a7-4f86-a370-c071704067e7'"
        else
            echo "is expected to be initialized to \"t\" before calling this function"
            echo "and its domain is {\"f\", \"t\"}."
            echo "GUID=='23ce96b4-2a3c-45fe-b170-c071704067e7'"
        fi
        if [ "$SB_NO_ERRORS_YET_1" == "t" ]; then 
            echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        fi
        echo ""
        SB_NO_ERRORS_YET="f"
    fi
    #--------------------
    if [ "$SB_NO_ERRORS_YET_1" == "f" ]; then 
        SB_NO_ERRORS_YET="f"
    fi
    #----------------------------------------------------------------------
    if [ "$SB_NO_ERRORS_YET" == "t" ]; then 
        if [ "$S_VARIABLE_NAME_IN_CALLING_CODE" == "" ]; then 
            echo ""
            echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
            echo ""
            echo "    S_VARIABLE_NAME_IN_CALLING_CODE==\"\""
            echo ""
            echo "GUID=='6d0d8638-fbb6-4737-8270-c071704067e7'"
            if [ "$SB_NO_ERRORS_YET_1" == "t" ]; then  # should be always true at this line
                echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi
            echo ""
            SB_NO_ERRORS_YET="f"
        fi
    fi
    #----------------------------------------------------------------------
    if [ "$SB_NO_ERRORS_YET" == "t" ]; then 
        if [ "$SB_VARIABLE_VALUE" != "t" ]; then 
            if [ "$SB_VARIABLE_VALUE" != "f" ]; then 
                echo ""
                echo -e "\e[31mThere is a flaw somewhere in the code\e[39m that"
                echo "uses a variable named \"$S_VARIABLE_NAME_IN_CALLING_CODE\". The " 
                echo ""
                echo "    $S_VARIABLE_NAME_IN_CALLING_CODE==\"$SB_VARIABLE_VALUE\""
                echo ""
                echo "but it is expected to be either \"t\" or \"f\"."
                echo "GUID=='df20c43d-b7e9-43ee-8460-c071704067e7'"
                if [ "$SB_NO_ERRORS_YET_1" == "t" ]; then  # should be always true at this line
                    echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
                fi
                echo ""
                SB_NO_ERRORS_YET="f"
            fi
        fi
    fi
    #----------------------------------------------------------------------
} # func_mmmv_assert_sbvar_domain_t_f_but_do_not_exit_t1

#--------------------------------------------------------------------------

func_mmmv_report_an_error_but_do_not_exit_t1(){
    local S_GUID_CANDIDATE="$1" # first  function argument
    local S_ERR_MSG="$2"        # second function argument
    #----------------------------------------------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code of this script is flawed.\e[39m"
        if [ "$S_ERR_MSG" != "" ]; then 
            echo "$S_ERR_MSG"
        fi
        echo "GUID=='87fc0219-104d-4b4d-9260-c071704067e7'"
        echo ""
    else
        echo ""
        echo -e "\e[31mThe code of this script is flawed.\e[39m"
        if [ "$S_ERR_MSG" != "" ]; then 
            echo "$S_ERR_MSG"
        fi
        echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo "GUID=='820b8b15-fd21-4abc-8160-c071704067e7'"
        echo ""
    fi
    #----------------------------------------------------------------------
    # exit 1 # must NOT be called in ~/.bashrc, because 
             # exiting from the ~/.bashrc exits the session.
} # func_mmmv_report_an_error_but_do_not_exit_t1

#--------------------------------------------------------------------------

func_mmmv_report_missing_from_path_and_do_NOT_exit_t1() {
    local S_NAME_OF_THE_EXECUTABLE=$1 # first function argument
    #----------------------------------------------------------------------
    local S_TMP_0="\`which $S_NAME_OF_THE_EXECUTABLE 2>/dev/null\`"
    local S_TMP_1=""
    local S_TMP_2="S_TMP_1=$S_TMP_0"
    eval ${S_TMP_2}
    if [ "$S_TMP_1" == "" ] ; then
        echo ""
        echo "This bash script wished to use the "
        echo "\"$S_NAME_OF_THE_EXECUTABLE\" from the PATH, but "
        echo "it was missing from the PATH."
        echo "GUID=='08c91c12-2e91-451d-8550-c071704067e7'"
        echo ""
    fi
    #----------------------------------------------------------------------
    # exit 1 # must NOT be called in ~/.bashrc, because 
             # exiting from the ~/.bashrc exits the session.
} # func_mmmv_report_missing_from_path_and_do_NOT_exit_t1

#func_mmmv_report_missing_from_path_and_do_NOT_exit_t1 "ln"
#func_mmmv_report_missing_from_path_and_do_NOT_exit_t1 "date"
#func_mmmv_report_missing_from_path_and_do_NOT_exit_t1 "printf"
#func_mmmv_report_missing_from_path_and_do_NOT_exit_t1 "grep"
#func_mmmv_report_missing_from_path_and_do_NOT_exit_t1 "git"

#--------------------------------------------------------------------------

func_mmmv_verify_that_the_file_exists_but_do_not_exit_t1() {  # S_FP, S_GUID_CANDIDATE
    local S_FP="$1"
    local S_GUID_CANDIDATE="$2"
    local SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE="$3" # domain: {"t","f",""}
                                                       # ""==="t", default "t"
    #----------------------------------------------------------------------
    # A global variable for storing function output.
    SB_VERIFICATION_FAILED="f" # domain: "t", "f" .
    #------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m"
        echo "This function requires 2 parameters: S_FP, S_GUID_CANDIDATE"
        echo "and has an optional 3. parameter: SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE"
        echo "GUID=='517475d5-6243-4bf6-be50-c071704067e7'"
        echo ""
        #--------
        SB_VERIFICATION_FAILED="t"
    fi
    #------------------------------
    local SB_DISPLAY_VERIF_FAILURE_MSG="t" # the default
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        if [ "$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE" != "" ]; then
            if [ "$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE" == "f" ]; then
                SB_DISPLAY_VERIF_FAILURE_MSG="f"
            else
                if [ "$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE" != "t" ]; then
                    echo ""
                    echo -e "\e[31mThe code that calls this function is flawed.\e[39m"
                    echo ""
                    echo "  SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE==\"$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE\""
                    echo ""
                    echo "Valid values are: \"t\", \"f\", \"\" ."
                    echo "\"\" defaults to \"t\"."
                    echo "GUID=='63dddb40-611a-4748-9440-c071704067e7'"
                    echo ""
                    #--------
                    SB_VERIFICATION_FAILED="t"
                fi
            fi
        fi
    fi
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        if [ ! -e "$S_FP" ]; then
            if [ -h "$S_FP" ]; then
                if [ "$SB_DISPLAY_VERIF_FAILURE_MSG" == "t" ]; then
                    echo ""
                    echo "The path "
                    echo ""
                    echo "    $S_FP "
                    echo ""
                    echo -e "points to a\e[31m broken symlink\e[39m, but a file or"
                    echo "a symlink to a file is expected."
                    echo "GUID==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='d038c037-b9e3-49f4-b340-c071704067e7'"
                    echo ""
                fi
                #--------
                SB_VERIFICATION_FAILED="t"
            else
                if [ "$SB_DISPLAY_VERIF_FAILURE_MSG" == "t" ]; then
                    echo ""
                    echo "The file "
                    echo ""
                    echo "    $S_FP "
                    echo ""
                    echo -e "\e[31mdoes not exist\e[39m."
                    echo "GUID==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='03dc4b3a-8c7d-4a57-9440-c071704067e7'"
                    echo ""
                fi
                #--------
                SB_VERIFICATION_FAILED="t"
            fi
        else
            if [ -d "$S_FP" ]; then
                if [ "$SB_DISPLAY_VERIF_FAILURE_MSG" == "t" ]; then
                    echo ""
                    if [ -h "$S_FP" ]; then
                        echo "The symlink to the folder "
                    else
                        echo "The folder "
                    fi
                    echo ""
                    echo "    $S_FP "
                    echo ""
                    echo -e "exists, but a\e[31m file or a symlink to a file is expected\e[39m."
                    echo "GUID==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='15d4561c-cbb9-4ae1-8330-c071704067e7'"
                    echo ""
                fi
                #--------
                SB_VERIFICATION_FAILED="t"
            fi
        fi
    fi #  "$SB_VERIFICATION_FAILED" == "f"
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" != "t" ]; then
        if [ "$SB_VERIFICATION_FAILED" != "f" ]; then
            echo ""
            echo -e "\e[31mThe code of this Bash function is flawed.\e[39m"
            echo "GUID=='6fd5cb23-531f-4dba-b430-c071704067e7'"
            echo ""
        fi
    fi
    #------------------------------
} # func_mmmv_verify_that_the_file_exists_but_do_not_exit_t1

#--------------------------------------------------------------------------

func_mmmv_verify_that_the_folder_exists_but_do_not_exit_t1() {  # S_FP, S_GUID_CANDIDATE
    local S_FP="$1"
    local S_GUID_CANDIDATE="$2"
    local SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE="$3" # domain: {"t","f",""}
                                                       # ""==="t", default "t"
    #----------------------------------------------------------------------
    # A global variable for storing function output.
    SB_VERIFICATION_FAILED="f" # domain: "t", "f" .
    #------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m"
        echo "This function requires 2 parameters: S_FP, S_GUID_CANDIDATE"
        echo "and has an optional 3. parameter: SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE"
        echo "GUID=='372e7922-fbf0-4760-a430-c071704067e7'"
        echo ""
        #--------
        SB_VERIFICATION_FAILED="t"
    fi
    #------------------------------
    local SB_DISPLAY_VERIF_FAILURE_MSG="t" # the default
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        if [ "$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE" != "" ]; then
            if [ "$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE" == "f" ]; then
                SB_DISPLAY_VERIF_FAILURE_MSG="f"
            else
                if [ "$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE" != "t" ]; then
                    echo ""
                    echo -e "\e[31mThe code that calls this function is flawed.\e[39m"
                    echo ""
                    echo "  SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE==\"$SB_DISPLAY_VERIFICATION_FAILURE_MESSAGE\""
                    echo ""
                    echo "Valid values are: \"t\", \"f\", \"\" ."
                    echo "\"\" defaults to \"t\"."
                    echo "GUID=='be5264d1-e1bb-4334-8220-c071704067e7'"
                    echo ""
                    #--------
                    SB_VERIFICATION_FAILED="t"
                fi
            fi
        fi
    fi
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        if [ ! -e "$S_FP" ]; then
            if [ -h "$S_FP" ]; then
                if [ "$SB_DISPLAY_VERIF_FAILURE_MSG" == "t" ]; then
                    echo ""
                    echo "The path "
                    echo ""
                    echo "    $S_FP "
                    echo ""
                    echo -e "points to a\e[31m broken symlink\e[39m, but a folder "
                    echo "or a symlink to a folder is expected."
                    echo "GUID==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='e3e5df34-e0ed-40ed-a220-c071704067e7'"
                    echo ""
                fi
                #--------
                SB_VERIFICATION_FAILED="t"
            else
                if [ "$SB_DISPLAY_VERIF_FAILURE_MSG" == "t" ]; then
                    echo ""
                    echo "The folder "
                    echo ""
                    echo "    $S_FP "
                    echo ""
                    echo -e "\e[31mdoes not exist\e[39m."
                    echo "GUID==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='d9bd5054-f0fe-4d34-9520-c071704067e7'"
                    echo ""
                fi
                #--------
                SB_VERIFICATION_FAILED="t"
            fi
        else
            if [ ! -d "$S_FP" ]; then
                if [ "$SB_DISPLAY_VERIF_FAILURE_MSG" == "t" ]; then
                    echo ""
                    if [ -h "$S_FP" ]; then
                        echo "The symlink to an existing file "
                    else
                        echo "The file "
                    fi
                    echo ""
                    echo "    $S_FP "
                    echo ""
                    echo -e "exists, but a\e[31m folder is expected\e[39m."
                    echo "GUID==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='51893869-b12f-41bc-a310-c071704067e7'"
                    echo ""
                fi
                #--------
                SB_VERIFICATION_FAILED="t"
            fi
        fi
    fi #  "$SB_VERIFICATION_FAILED" == "f"
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" != "t" ]; then
        if [ "$SB_VERIFICATION_FAILED" != "f" ]; then
            echo ""
            echo -e "\e[31mThe code of this Bash function is flawed.\e[39m"
            echo "GUID=='2edb0a75-1378-4294-a710-c071704067e7'"
            echo ""
        fi
    fi
    #------------------------------
} # func_mmmv_verify_that_the_folder_exists_but_do_not_exit_t1

#--------------------------------------------------------------------------

func_mmmv_add_bin_2_Z_PATH_and_optionally_share_man_2_MANPATH_t1(){
    local S_FP_INSTALLATION_FOLDER="$1" # is 
                      # the folder with the $S_FP_INSTALLATION_FOLDER/bin 
                      # and optionally  the $S_FP_INSTALLATION_FOLDER/share/man
    local S_GUID_CANDIDATE="$2"
    local SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY="$3" # domain: {"t","f"} Default: "f"
    #----------------------------------------------------------------------
    # A global variable for storing function output.
    SB_VERIFICATION_FAILED="f" # domain: "t", "f" .
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        if [ "$S_GUID_CANDIDATE" == "" ]; then
            echo ""
            echo -e "\e[31mThe code that calls this function is flawed.\e[39m"
            echo ""
            echo "    S_GUID_CANDIDATE==\"\""
            echo ""
            echo "GUID=='cd60e851-4892-4d57-8210-c071704067e7'"
            echo ""
            #--------
            SB_VERIFICATION_FAILED="t"
        fi
    fi
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        if [ "$S_FP_INSTALLATION_FOLDER" == "" ]; then
            echo ""
            echo -e "\e[31mThe code that calls this function is flawed.\e[39m"
            echo ""
            echo "    S_FP_INSTALLATION_FOLDER==\"\""
            echo ""
            echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            echo "GUID=='05eb1fa3-0ca6-4076-8400-c071704067e7'"
            echo ""
            #--------
            SB_VERIFICATION_FAILED="t"
        fi
    fi
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        if [ "$SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY" == "" ]; then
            SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY="f" # the default value
        else
            if [ "$SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY" != "t" ]; then
                if [ "$SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY" != "f" ]; then
                    echo ""
                    echo -e "\e[31mThe code that calls this function is flawed.\e[39m"
                    echo ""
                    echo "    SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY==\"$SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY\""
                    echo ""
                    echo "but its valid values are \"t\" and \"f\" and "
                    echo "\"\", which is automatically converted to the "
                    echo "default value of \"f\"."
                    echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
                    echo "GUID=='64362144-9bbd-4ad3-a500-c071704067e7'"
                    echo ""
                    #--------
                    SB_VERIFICATION_FAILED="t"
                fi
            fi
        fi
    fi
    #------------------------------
    local SB_MAN_FOLDER_OR_NONBROKEN_SYMLINK_TO_IT_EXISTS="f"
    if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
        func_mmmv_verify_that_the_folder_exists_but_do_not_exit_t1 \
            "$S_FP_INSTALLATION_FOLDER" "46434b50-3866-49c3-a5c0-c071704067e7"
        if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
            #--------------
            func_mmmv_verify_that_the_folder_exists_but_do_not_exit_t1 \
                "$S_FP_INSTALLATION_FOLDER/bin" "33447c03-d0d0-4ea0-beb0-c071704067e7"
            if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
                Z_PATH="$S_FP_INSTALLATION_FOLDER/bin:$Z_PATH"
            fi
            #--------------
            if [ -e "$S_FP_INSTALLATION_FOLDER/share/man" ]; then
                if [ -d "$S_FP_INSTALLATION_FOLDER/share/man" ]; then
                    SB_MAN_FOLDER_OR_NONBROKEN_SYMLINK_TO_IT_EXISTS="t"
                fi
            fi
            if [ "$SB_MAN_FOLDER_OR_NONBROKEN_SYMLINK_TO_IT_EXISTS" == "f" ]; then
                if [ "$SB_MAN_FOLDER_EXISTENCE_IS_MANDATORY" == "t" ]; then
                    # The next 2 lines are for displaying an error message.
                    func_mmmv_verify_that_the_folder_exists_but_do_not_exit_t1 \
                        "$S_FP_INSTALLATION_FOLDER/share/man" "23654747-8a42-4b48-85b0-c071704067e7"
                fi
            else
                MANPATH="$S_FP_INSTALLATION_FOLDER/share/man:$MANPATH"
            fi
            #--------------
        fi
    fi
    #------------------------------
    if [ "$SB_VERIFICATION_FAILED" != "t" ]; then
        if [ "$SB_VERIFICATION_FAILED" != "f" ]; then
            echo ""
            echo -e "\e[31mThe code of this Bash function is flawed.\e[39m"
            echo "GUID=='a7d39438-8be3-4984-b300-c071704067e7'"
            echo ""
        fi
    fi
    #------------------------------
} # func_mmmv_add_bin_2_Z_PATH_and_optionally_share_man_2_MANPATH_t1

#--------------------------------------------------------------------------

#==========================================================================
#::the::::end::of::2022_02_08_version_of_bashrc_subpart_func_core_t2:::::::
#::the::start::of::2021_06_10_version_of_a_set_of_throwing_bash_functions::

func_mmmv_assert_error_code_zero_t1(){
    local S_ERR_CODE="$1" # the "$?"
    local S_GUID_CANDIDATE="$2"
    #----------------------------------------------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mThe Bash code that calls this function is flawed. \e[39m"
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "Aborting script."
        echo "GUID=='385c4293-6188-4c20-ab5f-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1
    fi
    #------------------------------
    # If the "$?" were evaluated in this function, 
    # then it would be "0" even, if it is
    # something else at the calling code.
    if [ "$S_ERR_CODE" != "0" ];then
        echo ""
        echo "Something went wrong. Error code: $S_ERR_CODE"
        echo -e "\e[31mAborting script. \e[39m"
        echo "GUID=='1a3397e9-3319-4290-951f-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1
    fi
    #------------------------------
} # func_mmmv_assert_error_code_zero_t1

#--------------------------------------------------------------------------

# It differs form the 
# func_mmmv_assert_error_code_zero_t1 
# by the fact that it does not include the 
#
#     cd "$S_FP_ORIG"
#
func_mmmv_assert_error_code_zero_t2(){
    local S_ERR_CODE="$1" # the "$?"
    local S_GUID_CANDIDATE="$2"
    #----------------------------------------------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mThe Bash code that calls this function is flawed. \e[39m"
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "Aborting script."
        echo "GUID=='12448ea2-1077-48b0-bf4f-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        exit 1
    fi
    #------------------------------
    # If the "$?" were evaluated in this function, 
    # then it would be "0" even, if it is
    # something else at the calling code.
    if [ "$S_ERR_CODE" != "0" ];then
        echo ""
        echo "Something went wrong. Error code: $S_ERR_CODE"
        echo -e "\e[31mAborting script. \e[39m"
        echo "GUID=='53b675c4-418c-405a-873f-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        exit 1
    fi
    #------------------------------
} # func_mmmv_assert_error_code_zero_t2

#--------------------------------------------------------------------------

func_mmmv_assert_error_code_zero_t3(){
    local S_ERR_CODE="$1" # the "$?"
    local S_GUID_CANDIDATE="$2"
    #----------------------------------------------------------------------
    func_mmmv_assert_error_code_zero_t1 "$S_ERR_CODE" "$S_GUID_CANDIDATE"
    func_mmmv_wait_and_sync_t1
    #------------------------------
} # func_mmmv_assert_error_code_zero_t3

func_mmmv_assert_error_code_zero_t4(){
    local S_ERR_CODE="$1" # the "$?"
    local S_GUID_CANDIDATE="$2"
    #----------------------------------------------------------------------
    func_mmmv_assert_error_code_zero_t2 "$S_ERR_CODE" "$S_GUID_CANDIDATE"
    func_mmmv_wait_and_sync_t1
    #------------------------------
} # func_mmmv_assert_error_code_zero_t4

#--------------------------------------------------------------------------

func_mmmv_exc_verify_S_FP_ORIG_t1() {
    if [ "$S_FP_ORIG" == "" ]; then
        echo ""
        echo -e "\e[31mThe code of this script is flawed. \e[39m"
        echo "The environment variable S_FP_ORIG is expected "
        echo "to be initialized at the start of the script by "
        echo ""
        echo "    S_FP_ORIG=\"\`pwd\`\""
        echo ""
        echo "Aborting script."
        echo "GUID=='34f44934-04db-4492-9a4e-c071704067e7'"
        echo ""
        exit 1 # exit with an error
    fi
    #------------------------
    local SB_IS_SYMLINK="f"      # possible values: "t", "f"
    if [ -h "$S_FP_ORIG" ]; then # Returns "false" for paths that 
                                 # do not refer to anything.
        SB_IS_SYMLINK="t"
    fi
    #--------
    if [ ! -e "$S_FP_ORIG" ]; then
        if [ "$SB_IS_SYMLINK" == "t" ]; then
            echo "The "
        else
            echo "The file or folder "
        fi
        echo ""
        echo "    S_FP_ORIG==$S_FP_ORIG "
        echo ""
        if [ "$SB_IS_SYMLINK" == "t" ]; then
            echo -e "is a\e[31m broken symlink\e[39m. It is expected to be a folder that "
        else
            echo -e "\e[31mdoes not exist\e[39m. It is expected to be a folder that "
        fi
        echo "contains the script that prints this error message."
        echo -e "\e[31mAborting script. \e[39m"
        echo "GUID=='1ee54292-1665-4608-8c1e-c071704067e7'"
        echo ""
        exit 1 # exit with an error
    fi
    #------------------------
    if [ ! -d "$S_FP_ORIG" ]; then
        echo "The "
        echo ""
        echo "    S_FP_ORIG==$S_FP_ORIG "
        echo ""
        echo -e "is\e[31m not a folder\e[39m. It is expected to be a folder that "
        echo "contains the script that prints this error message."
        echo -e "\e[31mAborting script. \e[39m"
        echo "GUID=='10bb8ad2-6474-428c-b91e-c071704067e7'"
        echo ""
        exit 1 # exit with an error
    fi
} # func_mmmv_exc_verify_S_FP_ORIG_t1

#--------------------------------------------------------------------------

FUNC_MMMV_EXC_VERIFY_S_FP_ORIG_T2_S_FB_ORIG_ALREADY_VERIFIED="f"
func_mmmv_exc_verify_S_FP_ORIG_t2(){
    if [ "$FUNC_MMMV_EXC_VERIFY_S_FP_ORIG_T2_S_FB_ORIG_ALREADY_VERIFIED" != "t" ]; then
        if [ "$FUNC_MMMV_EXC_VERIFY_S_FP_ORIG_T2_S_FB_ORIG_ALREADY_VERIFIED" != "f" ]; then
            echo ""
            echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
            echo "The global variable "
            echo ""
            echo "    FUNC_MMMV_EXC_VERIFY_S_FP_ORIG_T2_S_FB_ORIG_ALREADY_VERIFIED==\"$FUNC_MMMV_EXC_VERIFY_S_FP_ORIG_T2_S_FB_ORIG_ALREADY_VERIFIED\""
            echo ""
            echo "has a domain of {\"f\", \"t\"}."
            echo "GUID=='a722d405-63f4-458f-8b3d-c071704067e7'"
            echo ""
        else
            func_mmmv_exc_verify_S_FP_ORIG_t1
            FUNC_MMMV_EXC_VERIFY_S_FP_ORIG_T2_S_FB_ORIG_ALREADY_VERIFIED="t"
        fi
    fi
} # func_mmmv_exc_verify_S_FP_ORIG_t2

#--------------------------------------------------------------------------

func_mmmv_cd_S_FP_ORIG_and_exit_t1(){
    func_mmmv_exc_verify_S_FP_ORIG_t1
    cd "$S_FP_ORIG"
    func_mmmv_assert_error_code_zero_t2 "$?" \
        "8ca1bd76-8229-4b55-95b0-c071704067e7"
    exit 0
} # func_mmmv_cd_S_FP_ORIG_and_exit_t1

#--------------------------------------------------------------------------

func_mmmv_assert_nonempty_string_t1(){
    local S_IN="$1"
    local S_VARIABLE_NAME_IN_CALLING_CODE="$2"
    local S_GUID_CANDIDATE="$3"
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    if [ "$S_GUID_CANDIDATE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "GUID=='431aab35-2ea3-4a9b-9c4c-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    fi
    #----------------------------------------------------------------------
    if [ "$S_VARIABLE_NAME_IN_CALLING_CODE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
        echo ""
        echo "    S_VARIABLE_NAME_IN_CALLING_CODE==\"\""
        echo ""
        echo "GUID=='27b8bdb2-3fbb-4e14-af2b-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    fi
    #----------------------------------------------------------------------
    if [ "$S_IN" == "" ]; then 
        echo ""
        echo -e "\e[31mThere is a flaw somewhere in the code\e[39m that"
        echo "uses a variable named \"$S_VARIABLE_NAME_IN_CALLING_CODE\"." 
        echo ""
        echo "    $S_VARIABLE_NAME_IN_CALLING_CODE==\"$S_IN\""
        echo ""
        echo "but it is expected to be something other than an empty string."
        echo "GUID=='62d38ae8-5472-40f1-832b-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    fi
    #----------------------------------------------------------------------
} # func_mmmv_assert_nonempty_string_t1

#--------------------------------------------------------------------------

func_mmmv_assert_sbvar_domain_t_f_t1(){
    local SB_VARIABLE_VALUE="$1"
    local S_VARIABLE_NAME_IN_CALLING_CODE="$2"
    local S_GUID_CANDIDATE="$3"
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    if [ "$S_GUID_CANDIDATE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "GUID=='3e338e51-af42-45a3-ae1b-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    fi
    #----------------------------------------------------------------------
    if [ "$S_VARIABLE_NAME_IN_CALLING_CODE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed.\e[39m The"
        echo ""
        echo "    S_VARIABLE_NAME_IN_CALLING_CODE==\"\""
        echo ""
        echo "GUID=='1f58d8b1-1c44-4c8e-9e1a-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    fi
    #----------------------------------------------------------------------
    if [ "$SB_VARIABLE_VALUE" != "t" ]; then 
        if [ "$SB_VARIABLE_VALUE" != "f" ]; then 
            echo ""
            echo -e "\e[31mThere is a flaw somewhere in the code\e[39m that"
            echo "uses a variable named \"$S_VARIABLE_NAME_IN_CALLING_CODE\". The " 
            echo ""
            echo "    $S_VARIABLE_NAME_IN_CALLING_CODE==\"$SB_VARIABLE_VALUE\""
            echo ""
            echo "but it is expected to be either \"t\" or \"f\"."
            echo "GUID=='4e8f0941-c920-4e46-ae4a-c071704067e7'"
            echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        fi
    fi
    #----------------------------------------------------------------------
} # func_mmmv_assert_sbvar_domain_t_f_t1

#--------------------------------------------------------------------------

func_mmmv_assert_file_exists_t1() {
    local S_FP="$1"
    local S_GUID_CANDIDATE="$2"
    local SB_OPTIONAL_BAN_SYMLINKS="$3" # domain: {"t", "f", ""} default: "f"
                                        # is the last formal parameter 
                                        # in stead of the S_GUID_CANDIDATE, 
                                        # because that way this function is 
                                        # backwards compatible with 
                                        # an earlier version of this 
                                        # function.
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    local SB_LACK_OF_PARAMETERS="f"
    if [ "$S_FP" == "" ]; then
        SB_LACK_OF_PARAMETERS="t"
    fi
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        SB_LACK_OF_PARAMETERS="t"
    fi
    if [ "$SB_LACK_OF_PARAMETERS" == "t" ]; then
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
        echo "This function requires 2 parameters, which are "
        echo "S_FP, S_GUID_CANDIDATE, and it has an optional 3. parameter, "
        echo "which is SB_OPTIONAL_BAN_SYMLINKS."
        if [ "$S_GUID_CANDIDATE" != "" ]; then
            echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        fi
        echo "GUID=='142023cb-2de1-475c-85ca-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    else
        if [ "$SB_LACK_OF_PARAMETERS" != "f" ]; then
            echo -e "\e[31mThis code is flawed. \e[39m"
            echo "GUID=='49255761-bcfb-4336-b81a-c071704067e7'"
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        fi
    fi
    #------------------------------
    if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "" ]; then
        # The default value of the 
        SB_OPTIONAL_BAN_SYMLINKS="f"
        # must be backwards compatible with the
        # version of this function, where 
        # symlinks to files were treated as actual files.
    else
        if [ "$SB_OPTIONAL_BAN_SYMLINKS" != "t" ]; then
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" != "f" ]; then
                echo ""
                echo "The "
                echo ""
                echo "    SB_OPTIONAL_BAN_SYMLINKS==\"$SB_OPTIONAL_BAN_SYMLINKS\""
                echo ""
                echo "but the valid values for the SB_OPTIONAL_BAN_SYMLINKS"
                echo "are: \"t\", \"f\", \"\"."
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
                echo "GUID=='4a31b803-c6bc-4600-b34a-c071704067e7'"
                echo ""
                #--------
                cd "$S_FP_ORIG"
                exit 1 # exiting with an error
            fi
        fi
    fi
    #------------------------------
    if [ ! -e "$S_FP" ]; then
        if [ -h "$S_FP" ]; then
            echo ""
            echo "The path "
            echo ""
            echo "    $S_FP "
            echo ""
            echo -e "points to a\e[31m broken symlink\e[39m, but "
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                echo "a file is expected."
            else
                echo "a file or a symlink to a file is expected."
            fi
            echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
            echo "GUID=='425fc0a5-d69d-469b-a619-c071704067e7'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        else
            echo ""
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                echo "The file "
            else
                echo "The file or a symlink to a file "
            fi
            echo ""
            echo "    $S_FP "
            echo ""
            echo -e "\e[31mdoes not exist\e[39m."
            echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
            echo "GUID=='922cea3e-cc32-4279-a0c9-c071704067e7'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        fi
    else
        if [ -d "$S_FP" ]; then
            echo ""
            if [ -h "$S_FP" ]; then
                echo "The symlink to an existing folder "
            else
                echo "The folder "
            fi
            echo ""
            echo "    $S_FP "
            echo ""
            printf "exists, but "
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                echo -e "a\e[31m file is expected\e[39m."
            else
                echo -e "a\e[31m file or a symlink to a file is expected\e[39m."
            fi
            echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
            echo "GUID=='3be439f4-8408-4068-b049-c071704067e7'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        else
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                if [ -h "$S_FP" ]; then 
                    echo ""
                    echo "The "
                    echo ""
                    echo "    $S_FP"
                    echo ""
                    echo -e "is a symlink to a file, but a\e[31m file is expected\e[39m."
                    echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='30450202-4dfe-4540-8b79-c071704067e7'"
                    echo ""
                    #--------
                    cd "$S_FP_ORIG"
                    exit 1 # exiting with an error
                fi
            fi
        fi
    fi
} # func_mmmv_assert_file_exists_t1

#--------------------------------------------------------------------------

func_mmmv_assert_folder_exists_t1() {
    local S_FP="$1"
    local S_GUID_CANDIDATE="$2"
    local SB_OPTIONAL_BAN_SYMLINKS="$3" # domain: {"t", "f", ""} default: "f"
                                        # is the last formal parameter 
                                        # in stead of the S_GUID_CANDIDATE, 
                                        # because that way this function is 
                                        # backwards compatible with 
                                        # an earlier version of this 
                                        # function.
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    local SB_LACK_OF_PARAMETERS="f"
    if [ "$S_FP" == "" ]; then
        SB_LACK_OF_PARAMETERS="t"
    fi
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        SB_LACK_OF_PARAMETERS="t"
    fi
    if [ "$SB_LACK_OF_PARAMETERS" == "t" ]; then
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
        echo "This function requires 2 parameters, which are "
        echo "S_FP, S_GUID_CANDIDATE, and it has an optional 3. parameter, "
        echo "which is SB_OPTIONAL_BAN_SYMLINKS."
        if [ "$S_GUID_CANDIDATE" != "" ]; then
            echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        fi
        echo "GUID=='a49a1942-6c0d-4f5a-b049-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    else
        if [ "$SB_LACK_OF_PARAMETERS" != "f" ]; then
            echo -e "\e[31mThis code is flawed. \e[39m"
            echo "GUID=='3c471cb4-1e3b-4635-9549-c071704067e7'"
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        fi
    fi
    #------------------------------
    if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "" ]; then
        # The default value of the 
        SB_OPTIONAL_BAN_SYMLINKS="f"
        # must be backwards compatible with the
        # version of this function, where 
        # symlinks to folders were treated as actual folders.
    else
        if [ "$SB_OPTIONAL_BAN_SYMLINKS" != "t" ]; then
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" != "f" ]; then
                echo ""
                echo "The "
                echo ""
                echo "    SB_OPTIONAL_BAN_SYMLINKS==\"$SB_OPTIONAL_BAN_SYMLINKS\""
                echo ""
                echo "but the valid values for the SB_OPTIONAL_BAN_SYMLINKS"
                echo "are: \"t\", \"f\", \"\"."
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
                echo "GUID=='f05d8a6e-e704-4927-85d8-c071704067e7'"
                echo ""
                #--------
                cd "$S_FP_ORIG"
                exit 1 # exiting with an error
            fi
        fi
    fi
    #------------------------------
    if [ ! -e "$S_FP" ]; then
        if [ -h "$S_FP" ]; then
            echo ""
            echo "The path "
            echo ""
            echo "    $S_FP "
            echo ""
            echo -e "points to a\e[31m broken symlink\e[39m, but "
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                echo -e "a\e[31m folder is expected\e[39m."
            else
                echo -e "a\e[31m folder or a symlink to a folder is expected\e[39m."
            fi
            echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
            echo "GUID=='1b1733e3-cfd8-4f52-8958-c071704067e7'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        else
            echo ""
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                echo "The folder "
            else
                echo "The folder or a symlink to a folder "
            fi
            echo ""
            echo "    $S_FP "
            echo ""
            echo -e "\e[31mdoes not exist\e[39m."
            echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
            echo "GUID=='82b827d8-e1bb-4aa2-9548-c071704067e7'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        fi
    else
        if [ ! -d "$S_FP" ]; then
            echo ""
            if [ -h "$S_FP" ]; then
                echo "The symlink to an existing file "
            else
                echo "The file "
            fi
            echo ""
            echo "    $S_FP "
            echo ""
            printf "exists, but "
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                echo -e "a\e[31m folder is expected\e[39m."
            else
                echo -e "a\e[31m folder or a symlink to a folder is expected\e[39m."
            fi
            echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
            echo "GUID=='52fb604f-d7ee-48b5-a528-c071704067e7'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        else
            if [ "$SB_OPTIONAL_BAN_SYMLINKS" == "t" ]; then
                if [ -h "$S_FP" ]; then 
                    echo ""
                    echo "The "
                    echo ""
                    echo "    $S_FP"
                    echo ""
                    echo -e "is a symlink to a folder, but a\e[31m folder is expected\e[39m."
                    echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
                    echo "GUID=='c44ea4a6-6cb8-44b8-8058-c071704067e7'"
                    echo ""
                    #--------
                    cd "$S_FP_ORIG"
                    exit 1 # exiting with an error
                fi
            fi
        fi
    fi
} # func_mmmv_assert_folder_exists_t1

#--------------------------------------------------------------------------

func_mmmv_exit_if_not_on_path_t2() { # S_COMMAND_NAME
    local S_COMMAND_NAME="$1"
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    local S_LOCAL_VARIABLE="`which $S_COMMAND_NAME 2>/dev/null`"
    if [ "$S_LOCAL_VARIABLE" == "" ]; then
        echo ""
        echo -e "\e[31mCommand \"$S_COMMAND_NAME\" could not be found from the PATH. \e[39m"
        echo "The execution of this Bash script is aborted."
        echo "GUID=='eb8d9421-bfc2-4b4c-a647-c071704067e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1;
    fi
} # func_mmmv_exit_if_not_on_path_t2

#--------------------------------------------------------------------------

func_mmmv_exit_t1(){
    local S_GUID_CANDIDATE="$1" # first function argument
    #----------------------------------------------------------------------
    echo ""
    echo -e "\e[32m\e[7m#======================================================="
    echo -e "\e[0m\e[32mIf You want to run this Bash script, the "
    echo "#--------------"
    echo "$S_FP_DIR/$S_FN_SCRIPTFILE_NAME"
    echo "#--------------"
    echo "then please edit it by outcommenting the line with the "
    echo "\"$S_GUID_CANDIDATE\"."
    echo "Thank You."
    echo -e "\e[32m\e[7m#======================================================="
    echo -e "\e[0m" # resets the text terminal style
    cd "$S_FP_ORIG"
    exit 1
} # func_mmmv_exit_t1

#--------------------------------------------------------------------------

func_mmmv_exc_exit_with_an_error_t1(){
    local S_GUID_CANDIDATE="$1" # first function argument
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t1
    echo ""
    echo -e "\e[31mThe code of this script is flawed. \e[39m"
    echo "Aborting script."
    if [ "$S_GUID_CANDIDATE" != "" ]; then 
        echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
    fi
    echo "GUID=='113beef1-f485-499a-8b47-c071704067e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1 # exit with an error
} # func_mmmv_exc_exit_with_an_error_t1

#--------------------------------------------------------------------------

func_mmmv_exc_exit_with_an_error_t2(){
    local S_GUID_CANDIDATE="$1"   # first function argument
    local S_OPTIONAL_ERR_MSG="$2" # second function argument
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t1
    if [ "$S_GUID_CANDIDATE" == "" ]; then 
        echo ""
        echo -e "\e[31mThe code of this script is flawed. \e[39m"
        if [ "$S_OPTIONAL_ERR_MSG" != "" ]; then 
            echo -e "$S_OPTIONAL_ERR_MSG"
        fi
        echo "Aborting script."
        echo "GUID=='27fe2915-7a3a-40e5-8b57-c071704067e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1 # exit with an error
    else
        echo ""
        echo -e "\e[31mSomething went wrong. \e[39m"
        if [ "$S_OPTIONAL_ERR_MSG" != "" ]; then 
            echo "$S_OPTIONAL_ERR_MSG"
        fi
        echo "Aborting script."
        echo "GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo "GUID=='641bf676-7e04-4214-92a7-c071704067e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1 # exit with an error
    fi
} # func_mmmv_exc_exit_with_an_error_t2

#--------------------------------------------------------------------------

S_AWK_CMD="exit 1;"
func_mmmv_exc_determine_Awk_command_t1() {
    func_mmmv_exc_verify_S_FP_ORIG_t2
    S_AWK_CMD="exit 1;" # for reliability
    local SB_THROW="f"
    if [ "`which gawk`" != "" ]; then
        S_AWK_CMD="gawk"
    else
        if [ "`which awk`" != "" ]; then
            S_AWK_CMD="awk"
        else
            SB_THROW="t"
        fi
    fi
    if [ "$SB_THROW" != "f" ]; then
        echo ""
        echo -e "\e[31mNeither 'gawk', nor 'awk' was available on PATH. \e[39m"
        echo "The execution of this Bash script is aborted."
        echo "GUID=='48ad9e72-112b-4524-9c37-c071704067e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1;
    fi
} # func_mmmv_exc_determine_Awk_command_t1

#--------------------------------------------------------------------------

func_mmmv_exc_is_file_t1() {
    local S_FP_CANDIDATE="$1" # folder path
    #----------------------------------------------------------------------
    if [ ! -e "$S_FP_CANDIDATE" ]; then 
        echo ""
        echo "The file"
        echo ""
        echo "    $S_FP_CANDIDATE "
        echo ""
        echo -e "\e[31mdoes not exist\e[39m."
        echo "GUID=='b1b19fa1-df57-4009-8956-c071704067e7'"
        echo "Aborting without doing anything."
        echo ""
        exit 1 # exit with an error
    fi
    if [ -d "$S_FP_CANDIDATE" ]; then 
        echo ""
        echo "The path"
        echo ""
        echo "    $S_FP_CANDIDATE "
        echo ""
        if [ -h "$S_FP_CANDIDATE" ]; then 
            echo "references a symbolic link to a folder, "
        else
            echo "references a folder, "
        fi
        echo -e "but it is\e[31m required to reference a file\e[39m."
        echo "GUID=='35914ed2-5268-4a19-8146-c071704067e7'"
        echo "Aborting without doing anything."
        echo ""
        exit 1 # exit with an error
    fi
} # func_mmmv_exc_is_file_t1

#--------------------------------------------------------------------------

func_mmmv_exc_is_folder_t1() {
    local S_FP_CANDIDATE="$1" # folder path
    #----------------------------------------------------------------------
    if [ ! -e "$S_FP_CANDIDATE" ]; then 
        echo ""
        echo "The folder"
        echo ""
        echo "    $S_FP_CANDIDATE "
        echo ""
        echo -e "\e[31mdoes not exist\e[39m."
        echo "GUID=='405acf73-2c04-41be-9446-c071704067e7'"
        echo "Aborting without doing anything."
        echo ""
        exit 1 # exit with an error
    fi
    if [ ! -d "$S_FP_CANDIDATE" ]; then 
        echo ""
        echo "The path"
        echo ""
        echo "    $S_FP_CANDIDATE "
        echo ""
        if [ -h "$S_FP_CANDIDATE" ]; then 
            echo "references a symbolic link to a file, "
        else
            echo "references a file, "
        fi
        echo -e "but it is\e[31m required to reference a folder\e[39m."
        echo "GUID=='8515a169-f953-4334-9666-c071704067e7'"
        echo "Aborting without doing anything."
        echo ""
        exit 1 # exit with an error
    fi
} # func_mmmv_exc_is_folder_t1

# S_FP_TMP_0="/tmp/fff_testimine"
# S_FP_TMP_FF1="$S_FP_TMP_0/ff1"
# S_FP_TMP_FILE_1="$S_FP_TMP_0/file1.txt"
# S_FP_TMP_0_SYM_FLDR_OK="$S_FP_TMP_0/sym_folder_exists"
# S_FP_TMP_0_SYM_X_MISSING="$S_FP_TMP_0/sym_x_missing"
# S_FP_TMP_0_SYM_FILE_OK="$S_FP_TMP_0/sym_file_exists"
# rm -fr $S_FP_TMP_0
# mkdir -p $S_FP_TMP_FF1
# echo "Hello World :-)" > $S_FP_TMP_FILE_1
# ln -s $S_FP_TMP_FILE_1  $S_FP_TMP_0_SYM_FILE_OK
# ln -s $S_FP_TMP_FF1  $S_FP_TMP_0_SYM_FLDR_OK
# ln -s $S_FP_TMP_FF1/this_does_not_exist $S_FP_TMP_0_SYM_X_MISSING
# 
# # The following assertions must pass:
#     func_mmmv_exc_is_folder_t1 "$S_FP_TMP_FF1"
#     func_mmmv_exc_is_folder_t1 "$S_FP_TMP_0_SYM_FLDR_OK"
#     func_mmmv_exc_is_file_t1 "$S_FP_TMP_FILE_1"
#     func_mmmv_exc_is_file_t1 "$S_FP_TMP_0_SYM_FILE_OK"
# 
# # The following assertions must fail:
#     #func_mmmv_exc_is_folder_t1 "$S_FP_TMP_0_SYM_X_MISSING"
#     #func_mmmv_exc_is_file_t1 "$S_FP_TMP_0_SYM_X_MISSING"
# 
# rm -fr $S_FP_TMP_0
# exit 0

#--------------------------------------------------------------------------

func_mmmv_create_folder_t1(){
    local S_FP_FOLDER="$1" # first function argument
    #--------
    # The reason, why this function is used instead of the 
    #     mkdir -p $S_FP_FOLDER
    # is that there is no guarantee that the 
    #     mkdir -p $S_FP_FOLDER
    # succeeds and it would be a waste of
    # development time to write the file system related
    # tests from scratch every time a folder 
    # needs to be created.
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    if [ "$S_FP_FOLDER" == "" ]; then
        echo ""
        echo "The function formal parameter S_FP_FOLDER "
        echo "is expected to be a full path to a folder that "
        echo "either already exists or that has to be created."
        echo "Aborting script."
        echo "GUID=='1a2df592-32fc-4366-a346-c071704067e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1 # exit with an error
    fi
    #--------
    if [ -e "$S_FP_FOLDER" ]; then 
        if [ ! -d "$S_FP_FOLDER" ]; then 
            echo ""
            echo "The "
            echo ""
            echo "    $S_FP_FOLDER"
            echo ""
            echo "is a file or a symlink to a file, but it "
            echo "is expected to be a full path to a folder, "
            echo "a symlink to a folder or it should not "
            echo "reference anything that already exists."
            echo "Aborting script."
            echo "GUID=='349f0f72-d480-4e11-b436-c071704067e7'"
            echo ""
            cd "$S_FP_ORIG"
            exit 1 # exit with an error
        fi
    else
        mkdir -p $S_FP_FOLDER
        local S_TMP_0="$?"
        wait # just in case
        sync # for network drives and USB-sticks
        wait # just in case
        if [ "$S_TMP_0" != "0" ]; then 
            func_mmmv_exc_exit_with_an_error_t2 "54a29f47-ef59-40e5-81b0-c071704067e7" \
                "S_FP_FOLDER==$S_FP_FOLDER"
        fi
        if [ ! -e "$S_FP_FOLDER" ]; then 
            func_mmmv_exc_exit_with_an_error_t2 "3d60a251-0390-4171-a2a0-c071704067e7" \
                "Folder creation failed. S_FP_FOLDER==$S_FP_FOLDER"
        fi
    fi
    #--------
} # func_mmmv_create_folder_t1

#--------------------------------------------------------------------------

func_mmmv_exc_assure_tmp_folder_existence_t1() {  # S_FP_TMP, S_GUID
    local S_FP_TMP="$1"
    local S_GUID="$2"
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    if [ "$S_GUID" == "" ]; then
        echo ""
        echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
        echo "This function requires 2 parameters: S_FP_TMP, S_GUID"
        echo "GUID=='899564a5-3ec3-4aa9-af15-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    fi
    #------------------------------
    if [ ! -e "$S_FP_TMP" ]; then
        if [ -h "$S_FP_TMP" ]; then
            rm -f "$S_FP_TMP" # deletes a broken symlink
            func_mmmv_assert_error_code_zero_t1 \
                "$?" "4506fac4-f0b5-41e4-a3a0-c071704067e7"
            func_mmmv_wait_and_sync_t1
            if [ -h "$S_FP_TMP" ]; then
                echo ""
                echo "The path "
                echo ""
                echo "    $S_FP_TMP"
                echo ""
                echo -e "points to a\e[31m broken symlink\e[39m, but a folder "
                echo "or a symlink to a folder is expected."
                echo "An attempt to delete the broken symlink failed."
                echo "GUID==\"$S_GUID\""
                echo "GUID=='d4785d60-27df-4426-9fd5-c071704067e7'"
                echo ""
                #--------
                cd "$S_FP_ORIG"
                exit 1 # exiting with an error
            fi
        fi
        mkdir -p "$S_FP_TMP"
        func_mmmv_assert_error_code_zero_t1 \
            "$?" "90cf6325-e706-4f25-8390-c071704067e7"
        func_mmmv_wait_and_sync_t1
        func_mmmv_assert_folder_exists_t1 "$S_FP_TMP" \
            '4cc41c21-be20-43fc-b615-c071704067e7'
    else
        if [ ! -d "$S_FP_TMP" ]; then
            echo ""
            if [ -h "$S_FP_TMP" ]; then
                echo "The symlink to an existing file "
            else
                echo "The file "
            fi
            echo ""
            echo "    $S_FP_TMP"
            echo ""
            echo -e "exists, but a\e[31m folder or a symlink to a folder is expected\e[39m."
            echo "GUID==\"$S_GUID\""
            echo "GUID=='820b7ac2-2df3-4685-ba25-c071704067e7'"
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1 # exiting with an error
        fi
    fi
} # func_mmmv_exc_assure_tmp_folder_existence_t1

#--------------------------------------------------------------------------

func_mmmv_ln_create_hardlink_t1() { # S_FP_TARGET  S_FP_LINK
    local S_FP_TARGET="$1" # is allowed to be a broken symlink, but 
                           # must NOT be a folder and must be 
                           # on the same filesystem volume with the S_FP_LINK .

    local S_FP_LINK="$2"   # must not exist during the call of this function .

    local SB_THROW_ON_INVALID_DATA="$3" # Optional.
                                        # Domain: {"t","f","",<unassigned>}.
                                        # default=="t"
    #----------------------------------------------------------------------
    if [ "$SB_THROW_ON_INVALID_DATA" == "" ]; then
        SB_THROW_ON_INVALID_DATA="t"
    else
        if [ "$SB_THROW_ON_INVALID_DATA" != "t" ]; then
            if [ "$SB_THROW_ON_INVALID_DATA" != "f" ]; then
                echo ""
                echo -e "\e[31mThe code that calls this function is flawed. \e[39m"
                echo "Domain(SB_THROW_ON_INVALID_DATA) == "
                echo "    {\"t\",\"f\",\"\",<unassigned>}"
                echo ""
                echo "    SB_THROW_ON_INVALID_DATA==\"$SB_THROW_ON_INVALID_DATA\""
                echo ""
                echo "Aborting script."
                echo "GUID=='50edc2a1-6004-48b4-9915-c071704067e7'"
                echo ""
                exit 1 # because of a code defect, not just invalid data.
            fi
        fi
    fi
    local SB_DO_NOT_CREATE_THE_HARDLINK="f" #a fallback for not throwing/exiting
    #----------------------------------------------------------------------
    # The original file and the hardlink share the same inode 
    # and therefore the original file and the hardlink are
    # distinguishable from each other only by their paths. Hardlinks
    # to folders do not exist, can not be made, because that would
    # change a file system tree into a graph that has true loops,
    # not just symlink based loops. Hardlinks form a relation
    # between a file path and an inode of a file. Hardlinks to 
    # symlinks are possible, because symlinks are special purpose files
    # regardless of whether the symlinks reference a folder or a file or another symlink.
    # Revision control systems (Git, Subversion, etc.)
    # can/at_least_sometimes_do break hardlinks by making physical
    # copies of the files that are referenced by hardlinks.
    #
    #     https://superuser.com/questions/12972/how-can-you-see-the-actual-hard-link-by-ls
    #     (archival copy: https://archive.is/8feTw )
    #
    #     http://www.linfo.org/hard_link.html
    #     (archival copy: https://archive.is/HXFYC )
    #
    # Inode numbers can be displayed by executing
    #
    #     ls -l --inode   # short version is: "ls -li "
    # 
    # A 2019_06_30 citation of user "ninjalj" 2017_05_02 comment from  
    # 
    #     https://stackoverflow.com/questions/43733893/when-rm-a-file-but-hard-link-still-there-the-inode-will-be-marked-unused
    #     (archival copy: https://archive.is/5j0cv )
    #     ----citation--start----
    #     i-nodes contain a link count (visible in ls -l output). 
    #     Each hard link increments that count. Unlinking 
    #     (removing a link, be it the original filename->inode 
    #     link, or some hard link added later, which is the only thing 
    #     users can request) decrements the count.  
    #     ----citation--end------
    #
    #----------------------------------------------------------------------
    if [ -e "$S_FP_LINK" ]; then 
        if [ -d "$S_FP_LINK" ]; then # folder or a symlink to a folder
            if [ ! -h "$S_FP_LINK" ]; then # not a symlink, therefore a folder
                echo ""
                echo "The hardlink candidate, the "
                echo ""
                echo "    $S_FP_LINK"
                echo ""
                echo "already exists and it is a folder, not a symlink."
                echo "According to the implementation of this function "
                echo "this is a situation, where there is probably something wrong,"
                echo "because hardlinks can be made only to files and symlinks, "
                echo "regardless of whether the symlinks are broken or not."
                echo "Skipping the creation of the hardlink with the target path of "
                echo ""
                echo "    $S_FP_TARGET"
                echo ""
                echo "GUID=='432a48bb-8cc5-4cb9-9015-c071704067e7'"
                echo ""
                if [ "$SB_THROW_ON_INVALID_DATA" == "t" ]; then
                    exit 1
                fi
                SB_DO_NOT_CREATE_THE_HARDLINK="t"
            # else # symlink to a folder
            fi
        # else # file or a symlink to a file
        fi
        if [ "$SB_DO_NOT_CREATE_THE_HARDLINK" == "f" ]; then
            echo ""
            echo "According to the specification of this function "
            echo "the hardlink, which in the case of this function call "
            echo "has the path of "
            echo ""
            echo "    $S_FP_LINK"
            echo ""
            echo "must not exist before the call to this function."
            echo "GUID=='5af99501-ade5-4362-b534-c071704067e7'"
            echo ""
            if [ "$SB_THROW_ON_INVALID_DATA" == "t" ]; then
                exit 1
            fi
            SB_DO_NOT_CREATE_THE_HARDLINK="t"
        fi
    else # missing or a broken symlink
        if [ "$SB_DO_NOT_CREATE_THE_HARDLINK" == "f" ]; then
            if [ -h "$S_FP_LINK" ]; then # a broken symlink, therefore NOT missing
                echo ""
                echo "The hardlink candidate, the "
                echo ""
                echo "    $S_FP_LINK"
                echo ""
                echo "already exists and it is a broken symlink. According to "
                echo "the specification of this function the hardlink "
                echo "must not exist before the call to this function."
                echo "GUID=='1d594874-f1f9-4141-b854-c071704067e7'"
                echo ""
                if [ "$SB_THROW_ON_INVALID_DATA" == "t" ]; then
                    exit 1
                fi
                SB_DO_NOT_CREATE_THE_HARDLINK="t"
            fi
        fi
    fi
    #----------------------------------------------------------------------
    if [ "$SB_DO_NOT_CREATE_THE_HARDLINK" == "f" ]; then
        if [ -e "$S_FP_TARGET" ]; then
            if [ -d "$S_FP_TARGET" ]; then # a folder or a symlink to a folder
                if [ ! -h "$S_FP_TARGET" ]; then # not a symlink, therefore a folder
                    echo ""
                    echo "The hardlink target candidate, the "
                    echo ""
                    echo "    $S_FP_TARGET"
                    echo ""
                    echo "is a folder, not a symlink to a folder. "
                    echo "Hardlinks can be made only to files and symlinks, "
                    echo "regardless of whether the symlinks are broken or not."
                    echo "Skipping the creation of the hardlink with the path of "
                    echo ""
                    echo "    $S_FP_LINK"
                    echo ""
                    echo "GUID=='42f497e2-ca91-4f13-a414-c071704067e7'"
                    echo ""
                    if [ "$SB_THROW_ON_INVALID_DATA" == "t" ]; then
                        exit 1
                    fi
                    SB_DO_NOT_CREATE_THE_HARDLINK="t"
                # else # symlink to a folder
                fi
            # else # file or a symlink to a file
            fi
        else # missing or a broken symlink
            if [ ! -h "$S_FP_TARGET" ]; then # not a symlink, therefore missing
                echo ""
                echo "The hardlink target candidate with the path of  "
                echo ""
                echo "    $S_FP_TARGET"
                echo ""
                echo -e "\e[31mdoes not exist\e[39m. Skipping the creation of a hardlink"
                echo "with the path of "
                echo ""
                echo "    $S_FP_LINK"
                echo ""
                echo "GUID=='5a0559d1-479e-48b6-9934-c071704067e7'"
                echo ""
                if [ "$SB_THROW_ON_INVALID_DATA" == "t" ]; then
                    exit 1
                fi
                SB_DO_NOT_CREATE_THE_HARDLINK="t"
            # else # broken symlink
                   # It is possible to create hardlinks to broken symlinks.
            fi
        fi
    fi
    #----------------------------------------------------------------------
    local S_TMP_0="not_set_yet GUID=='5caec2f1-4b60-432c-bd14-c071704067e7'"
    if [ "$SB_DO_NOT_CREATE_THE_HARDLINK" == "f" ]; then
        ln  "$S_FP_TARGET" "$S_FP_LINK" 
        S_TMP_0="$?"
        if [ "$S_TMP_0" != "0" ]; then
            echo ""
            echo "The creation of a hardlink with the path of "
            echo ""
            echo "    $S_FP_LINK"
            echo ""
            echo "and the target path of "
            echo ""
            echo "    $S_FP_TARGET"
            echo ""
            echo -e "\e[31mfailed\e[39m. The ln exited with the error code of $S_TMP_0 ."
            echo "GUID=='27914263-6740-4aa2-8734-c071704067e7'"
            echo ""
            if [ "$SB_THROW_ON_INVALID_DATA" == "t" ]; then
                exit 1
            fi
            SB_DO_NOT_CREATE_THE_HARDLINK="t" # here to skip some tests later
        fi
        #------------------------------------------------------------------
        #func_mmmv_wait_and_sync_t1 # inlined at the next 2 lines
        wait # for background processes started by this Bash script to exit/finish
        sync # USB-sticks, etc.
        wait # for sync
        #------------------------------------------------------------------
        if [ "$SB_DO_NOT_CREATE_THE_HARDLINK" == "f" ]; then
            #--------------------------------------------------------------
            S_TMP_0="f" # "t" --- potential error condition detected
                        # "f" --- no error detected
            #--------------------------------------------------------------
            if [ -h "$S_FP_TARGET" ]; then
                # A broken symlink, including a hardlink to a broken symlink
                # gives "false" with the Bash "-e".
                if [ ! -h "$S_FP_LINK" ]; then
                    echo ""
                    echo "Problem detection branch marker "
                    echo "GUID=='3b2177c2-fcab-4d9f-ad13-c071704067e7'"
                    echo ""
                    S_TMP_0="t"
                else
                    if [ -e "$S_FP_TARGET" ]; then # symlink to a folder or a file
                        if [ ! -e "$S_FP_LINK" ]; then
                            echo ""
                            echo "Problem detection branch marker "
                            echo "GUID=='2ccd5214-60ce-492b-9353-c071704067e7'"
                            echo ""
                            S_TMP_0="t"
                        else
                            if [ -d "$S_FP_TARGET" ]; then
                                if [ ! -d "$S_FP_LINK" ]; then
                                    echo ""
                                    echo "Problem detection branch marker "
                                    echo "GUID=='3b1dc51f-5af3-439a-ba33-c071704067e7'"
                                    echo ""
                                    S_TMP_0="t"
                                fi
                            else
                                if [ -d "$S_FP_LINK" ]; then
                                    echo ""
                                    echo "Problem detection branch marker "
                                    echo "GUID=='a6494b14-2bac-46a6-b333-c071704067e7'"
                                    echo ""
                                    S_TMP_0="t"
                                fi
                            fi
                        fi
                    else # broken symlink
                        if [ -e "$S_FP_LINK" ]; then
                            echo ""
                            echo "Problem detection branch marker "
                            echo "GUID=='bcbac9fc-5445-4590-ba23-c071704067e7'"
                            echo ""
                            S_TMP_0="t"
                        fi
                    fi
                fi
            else # As the S_FP_LINK can never be a hardlink to a folder and
                 # the S_FP_TARGET is not a symlink at this branch, the 
                 # S_FP_TARGET is a file. Therefore at this branch 
                 # the S_FP_LINK is also a file.
                if [ ! -e "$S_FP_TARGET" ]; then # just an extra test
                    echo ""
                    echo "Problem detection branch marker "
                    echo "GUID=='d268c0bf-281f-4a06-ae43-c071704067e7'"
                    echo ""
                    S_TMP_0="t"
                else
                    if [ -d "$S_FP_TARGET" ]; then # just an extra test
                        echo ""
                        echo "Problem detection branch marker "
                        echo "GUID=='c6cfd603-db53-45fb-8323-c071704067e7'"
                        echo ""
                        S_TMP_0="t"
                    else
                        if [ -h "$S_FP_LINK" ]; then
                            echo ""
                            echo "Problem detection branch marker "
                            echo "GUID=='19a17195-67f4-437f-b153-c071704067e7'"
                            echo ""
                            S_TMP_0="t"
                        else
                            if [ ! -e "$S_FP_LINK" ]; then
                                echo ""
                                echo "Problem detection branch marker "
                                echo "GUID=='52c2b483-a428-4fea-9023-c071704067e7'"
                                echo ""
                                S_TMP_0="t"
                            else
                                if [ -d "$S_FP_LINK" ]; then
                                    echo ""
                                    echo "Problem detection branch marker "
                                    echo "GUID=='aa863b83-a0c6-48e2-a952-c071704067e7'"
                                    echo ""
                                    S_TMP_0="t"
                                fi
                            fi
                        fi
                    fi
                fi
            fi
            #--------------------------------------------------------------
            if [ "$S_TMP_0" == "t" ]; then
                echo ""
                echo "The creation of a hardlink with the path of "
                echo ""
                echo "    $S_FP_LINK "
                echo ""
                echo "and the target path of "
                echo ""
                echo "    $S_FP_TARGET"
                echo ""
                echo "might have succeeded, but did not go as expected."
                echo "The ln command succeeded, but there might have been "
                echo "some other operating system processes that altered some "
                echo "related files or folders or symlinks on disk before "
                echo "this Bash function could exit. One possible debugging "
                echo "idea is that it is possible to chain symlinks "
                echo "together by making a symlink to symlink that references "
                echo "a symlink that references "
                echo "a symlink that references "
                echo "a symlink that references "
                echo "a symlink that references ..."
                echo "and the operating system processes might have "
                echo "altered any of the symlinks in the chain, including "
                echo "the file or folder at the very end of the symlink chain."
                echo "GUID=='407ac745-60ef-4c95-bf32-c071704067e7'"
                echo ""
                if [ "$SB_THROW_ON_INVALID_DATA" == "t" ]; then
                    exit 1
                fi
            else
                if [ "$S_TMP_0" != "f" ]; then
                    echo ""
                    echo -e "\e[31mThe implementation of this function is flawed. \e[39m"
                    echo "Aborting script."
                    echo "GUID=='3c45fe21-e233-405e-8552-c071704067e7'"
                    echo ""
                    exit 1
                fi
            fi
            #--------------------------------------------------------------
        fi
        #------------------------------------------------------------------
    else
        if [ "$SB_DO_NOT_CREATE_THE_HARDLINK" != "t" ]; then
            echo ""
            echo -e "\e[31mThe implementation of this function is flawed. \e[39m"
            echo "Aborting script."
            echo "GUID=='215ccf85-688b-4bf0-aa12-c071704067e7'"
            echo ""
            exit 1
        fi
    fi
} # func_mmmv_ln_create_hardlink_t1

#--------------------------------------------------------------------------

func_mmmv_assert_environment_variable_set_t1() { 
    local S_ENVIRONMENT_VARIABLE_NAME="$1"
    local S_GUID_CANDIDATE="$2" 
    local S_OPTIONAL_ERR_MSG="$3" # will be appended to failure-message
    #----------------------------------------------------------------------
    local S_ENVIR_VALUE=""
    local S_SCRIPT_0="S_ENVIR_VALUE=\"\`echo \\\"\$$S_ENVIRONMENT_VARIABLE_NAME\\\" \`\""
    eval "$S_SCRIPT_0"
    if [ "$S_ENVIR_VALUE" == "" ]; then
        echo ""
        echo "The environment variable $S_ENVIRONMENT_VARIABLE_NAME is "
        echo -e "\e[31meither not set or it has the value of an empty string\e[39m."
        if [ "$S_OPTIONAL_ERR_MSG" != "" ]; then
            printf "%b" "$S_OPTIONAL_ERR_MSG"
        fi
        if [ "$S_GUID_CANDIDATE" != "" ]; then
            echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        fi 
        echo "GUID=='1fda9e55-5e46-4199-a622-c071704067e7'"
        echo ""
        exit 1 # exit with an error
    #else 
         # echo "S_ENVIR_VALUE==\"$S_ENVIR_VALUE\""
    fi
} # func_mmmv_assert_environment_variable_set_t1

#--------------------------------------------------------------------------

func_mmmv_ar_ls_t1() { # S_ARRAY_VARIABLE_NAME S_FP_LS
    local S_ARRAY_VARIABLE_NAME="$1"
    local S_FP_LS="$2"
    #----------------------------------------------------------------------
    # The "ls -m " works on both, BSD and Linux.
    local AR_0=$( ls -m $S_FP_LS )
    #--------
    local S_SCRIPT_0="$S_ARRAY_VARIABLE_NAME=()"
    eval "$S_SCRIPT_0"
    local s_iter=""
    S_SCRIPT_0="$S_ARRAY_VARIABLE_NAME+=(\$s_iter)"
    local S_TMP_IFS="$IFS"
    # The IFS is an internal Bash variable, "Internal Field Separator".
    IFS="," # That should handle file names that contain spaces.
    for s_iter in ${AR_0[@]}; do
        eval "$S_SCRIPT_0"
    done
    IFS="$S_TMP_IFS"
    if [ -z "$IFS" ]; then  # The "-z" returns true, if the string length is zero.
        unset IFS
    fi
} # func_mmmv_ar_ls_t1

# Test/demo code:
#    func_mmmv_ar_ls_t1 "AR_X" "$HOME"
# 
#    AR_2=${AR_X[@]}  # flawed array assignment that tokenizes by space
#    S_TMP=${#AR_X[@]}
#    echo "AR_X length: $S_TMP"
#    echo ""
#    for s_iter in ${AR_X[@]}; do
#         echo "AR_X element:[$s_iter]" 
#    done
#--------------------------------------------------------------------------

func_mmmv_exec_with_every_ar_element_t1() { # S_CMD_PART_0  S_ARRAY_VARIABLE_NAME_OF_AR_S_CMD_PART_1 S_CMD_PART_2
    local S_CMD_PART_0="$1"
    local S_ARRAY_VARIABLE_NAME_OF_AR_S_CMD_PART_1="$2"
    local S_CMD_PART_2="$3"
    #----------------------------------------------------------------------
    local S_SCRIPT_0=""
    local S_SCRIPT_1=""
    local S_SCRIPT_2=""
    local S_SCRIPT_x0=""
    local S_SCRIPT_x1=""
    local S_SCRIPT_x2=""
    #----------------
    # Wastefully left uncommented to detect flaws and to make life more comfortable :-)
    local S_TMP=""
    S_SCRIPT_0="S_TMP=\${#"
    S_SCRIPT_1="$S_ARRAY_VARIABLE_NAME_OF_AR_S_CMD_PART_1"
    S_SCRIPT_2="[@]}"
    eval "$S_SCRIPT_0$S_SCRIPT_1$S_SCRIPT_2" 
    #echo "The length of the $S_ARRAY_VARIABLE_NAME_OF_AR_S_CMD_PART_1 is: $S_TMP"
    #----------------
    # The newline trick 
    local S_NEWLINE=$'\n'
    # originates from the answer of Gordon Davisson:
    # https://stackoverflow.com/questions/17821277/how-to-separate-multiple-commands-passed-to-eval-in-bash
    # archival copy: https://archive.fo/7XI3a 
    #--------
    local S_ITER=""
    S_SCRIPT_0="for S_ITER in \${$S_ARRAY_VARIABLE_NAME_OF_AR_S_CMD_PART_1[@]}; do " 
    S_SCRIPT_x0="echo \"\"; echo \"\$S_ITER\""
    #S_SCRIPT_1="echo \"\$S_ITER\" " 
    S_SCRIPT_1="$S_CMD_PART_0 \$S_ITER  $S_CMD_PART_2 ;" 
    S_SCRIPT_x1="echo \"\""
    S_SCRIPT_2="done"
    S_SCRIPT_x2=""
    #----
    local S_TMP_0="$S_SCRIPT_0$S_NEWLINE$S_SCRIPT_x0$S_NEWLINE"
    local S_TMP_1="$S_SCRIPT_1$S_NEWLINE$S_SCRIPT_x1$S_NEWLINE"
    local S_TMP_2="$S_SCRIPT_2$S_NEWLINE$S_SCRIPT_x2$S_NEWLINE"
    eval "$S_TMP_0$S_TMP_1$S_TMP_2"
} # func_mmmv_exec_with_every_ar_element_t1

#--------------------------------------------------------------------------

func_mmmv_ar_range_t1() { #S_ARRAY_VARIABLE_NAME I_MINIMUM_INDEX I_MAXIMUM_INDEX
    local S_ARRAY_VARIABLE_NAME="$1"
    local I_MIN=$2
    local I_MAX_PLUS_ONE=`expr $3 + 1`
    #----------------------------------------------------------------------
    local S_SCRIPT_0="$S_ARRAY_VARIABLE_NAME=()"
    eval "$S_SCRIPT_0"
    local i_n=""
    S_SCRIPT_0="$S_ARRAY_VARIABLE_NAME+=(\$i_n)"
    for ((i_n=$I_MIN;i_n<$I_MAX_PLUS_ONE;i_n++))
    do
        eval "$S_SCRIPT_0"
    done
} # func_mmmv_ar_range_t1

# Test/demo code:
#     S_TMP="9"
#     func_mmmv_ar_range_t1 "AR_A_GLOBAL_VARIABLE" 4 $S_TMP
#     for s_iter in ${AR_A_GLOBAL_VARIABLE[@]}; do
#             echo "s_iter==[$s_iter]"
#     done
#--------------------------------------------------------------------------

func_mmmv_create_array_t1() {
    local ARRR=()
    #------- 
    ARRR+=("first value as string")
    ARRR+=("second value as string") 
    ARRR+=("third value as string")
    ARRR+=("fourth value as string")
    #------- 
    export ARRR_sz=`declare -p ARRR`
} # func_mmmv_create_array_t1

#--------------------------------------------------------------------------

func_mmmv_iterate_over_array_02n_t1() {
    local S_ARRAY_VARIABLE_NAME="$1" 
    local S_ARRAY_SERIALIZED="$2" # `declare -p VARIABLENAME` or an empty string
    local S_ITERATION_FUNCTION_NAME="$3" # that accepts "$s_iter" as a parameter
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    if [ "$S_ARRAY_VARIABLE_NAME" == "" ]; then
        echo ""
        echo -e "\e[31mS_ARRAY_VARIABLE_NAME\e[39m is not allowed to be an empty string."
        echo "GUID=='3ea3ec84-20d4-4877-bb52-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1
    fi
    #----------------------------------------------------------------------
    if [ "$S_ITERATION_FUNCTION_NAME" == "" ]; then
        echo ""
        echo -e "\e[31mS_ITERATION_FUNCTION_NAME\e[39m is not allowed to be an empty string."
        echo "GUID=='d415e3a3-18be-486c-a711-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1
    fi
    #----------------------------------------------------------------------
    eval ${S_ARRAY_SERIALIZED}
    #-------
    local S_SCRIPT_0="local S_LEN=\${#$S_ARRAY_VARIABLE_NAME[@]}"
    eval ${S_SCRIPT_0}
    #echo "ARRR length: $S_LEN"
    local I_MAX=`expr $S_LEN + 0`
    #-------
    local i_n=42
    local s_iter=""
    local S_SCRIPT_LINE_1="for ((i_n=0;i_n<\$I_MAX;i_n++))"
    local S_SCRIPT_LINE_2="s_iter=\${$S_ARRAY_VARIABLE_NAME[\$i_n]}"
    local S_SCRIPT_LINE_3="$S_ITERATION_FUNCTION_NAME \"\$s_iter\""
    S_SCRIPT_0="$S_SCRIPT_LINE_1 "$'\n'"do"$'\n'"$S_SCRIPT_LINE_2 "$'\n'"$S_SCRIPT_LINE_3 "$'\n'"done"
    #echo "$S_SCRIPT_0"
    eval "$S_SCRIPT_0"
} # func_mmmv_iterate_over_array_02n_t1

# Test/demo code:
#     func_iter() {
#         local S_ITER="$1"
#         echo "Greetings from func_iter: $S_ITER"
#     } # func_iter
#     
#     func_mmmv_create_array_t1
#     func_mmmv_iterate_over_array_02n_t1 "ARRR" "$ARRR_sz" "func_iter"
#--------------------------------------------------------------------------

func_mmmv_sb_head_exists_t1() { # S_OUTPUT_VARIABLE_NAME, S_HEAD_REGEX , S_HAYSTACK
    local S_OUTPUT_VARIABLE_NAME="$1"
    local S_HEAD_REGEX="$2"
    local S_HAYSTACK="$3"
    #----------------------------------------------------------------------
    local S_SCRIPT_0="$S_OUTPUT_VARIABLE_NAME=\"f\""
    eval "$S_SCRIPT_0"
    local S_NUMBER_OF_MATCHING_CHARACTERS=`expr match "$S_HAYSTACK" "$S_HEAD_REGEX"`
    if [ "$S_NUMBER_OF_MATCHING_CHARACTERS" != "0" ]; then
        S_SCRIPT_0="$S_OUTPUT_VARIABLE_NAME=\"t\""
        eval "$S_SCRIPT_0"
    fi
} # func_mmmv_sb_head_exists_t1 

# Test/demo code:
#     S_RGX="/home/ts2/tmp"
#     S_FP="/home/ts2/tmp/uuuuu/eee"
#     
#     func_mmmv_sb_head_exists_t1 "S_CC" $S_RGX $S_FP
#     echo "S_CC: $S_CC"
#--------------------------------------------------------------------------

func_mmmv_include_bashfile_if_possible_t1(){ # S_FP_BASHFILE S_GUID_CANDIDATE SB_THROW_ON_ERROR
    local S_FP_BASHFILE="$1" # Full path to the file   
    local S_GUID_CANDIDATE="$2" 
    local SB_THROW_ON_ERROR="$3" # ~/.bashrc must not call the "exit" command.
                                 # If the SB_THROW_ON_ERROR=="t", the 
                                 # "exit" command can be called in case of error.
                                 # If the SB_THROW_ON_ERROR=="f", the 
                                 # "exit" command will not be called, 
                                 # only an error message is printed to console.
                                 # default: "f"
    #----------------------------------------------------------------------
    if [ "$SB_THROW_ON_ERROR" == "" ]; then
        SB_THROW_ON_ERROR="f" # the default value
    else
        if [ "$SB_THROW_ON_ERROR" != "t" ]; then
            if [ "$SB_THROW_ON_ERROR" != "f" ]; then
                echo ""
                echo "The SB_THROW_ON_ERROR(==$SB_THROW_ON_ERROR)"
                echo -e "\e[31mhas a wrong vaue\e[39m. Only \"t\" and \"f\" are allowed."
                if [ "$S_GUID_CANDIDATE" != "" ]; then
                    echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
                fi 
                echo "GUID=='52119f37-577b-4447-ae71-c071704067e7'"
                echo ""
            fi
        fi
    fi
    #-----------------------------------------
    local SB_INCLUSION_POSSIBLE="t"
    if [ "$S_FP_BASHFILE" == "" ]; then
        SB_INCLUSION_POSSIBLE="f"
        echo ""
        echo -e "The S_FP_BASHFILE \e[31mhad a value of an empty string\e[39m."
        if [ "$S_GUID_CANDIDATE" != "" ]; then
            echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        fi 
        echo "GUID=='d4195461-b48c-43ce-b551-c071704067e7'"
        echo ""
        if [ "$SB_THROW_ON_ERROR" == "t" ]; then
            exit 1
        fi
    fi
    #-----------------------------------------
    if [ "$SB_INCLUSION_POSSIBLE" == "t" ]; then
        if [ ! -e "$S_FP_BASHFILE" ]; then
            SB_INCLUSION_POSSIBLE="f"
            echo ""
            echo "The "
            echo ""
            echo "    $S_FP_BASHFILE"
            echo ""
            echo -e "\e[31mdoes not exist or it is a broken symlink\e[39m."
            if [ "$S_GUID_CANDIDATE" != "" ]; then
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi 
            echo "GUID=='1b002624-cb73-494b-a641-c071704067e7'"
            echo ""
            if [ "$SB_THROW_ON_ERROR" == "t" ]; then
                exit 1
            fi
        fi
    fi
    #-----------------------------------------
    if [ "$SB_INCLUSION_POSSIBLE" == "t" ]; then
        if [ -d "$S_FP_BASHFILE" ]; then
            SB_INCLUSION_POSSIBLE="f"
            echo ""
            echo "The "
            echo ""
            echo "    $S_FP_BASHFILE"
            echo ""
            echo -e "\e[31mreferences a folder\e[39m, but it must reference a file."
            if [ "$S_GUID_CANDIDATE" != "" ]; then
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi 
            echo "GUID=='86937e2e-d4a7-46b0-bd71-c071704067e7'"
            echo ""
            if [ "$SB_THROW_ON_ERROR" == "t" ]; then
                exit 1
            fi
        fi
    fi
    #----------------------------------------------------------------------
    if [ "$SB_INCLUSION_POSSIBLE" == "t" ]; then
        source "$S_FP_BASHFILE"
    else
        if [ "$SB_INCLUSION_POSSIBLE" != "f" ]; then
            echo ""
            echo -e "\e[31mThe implementation of this function is flawed. \e[39m"
            echo "SB_INCLUSION_POSSIBLE==$SB_INCLUSION_POSSIBLE"
            if [ "$S_GUID_CANDIDATE" != "" ]; then
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi 
            echo "GUID=='03527e03-66b3-4136-9941-c071704067e7'"
            echo ""
            if [ "$SB_THROW_ON_ERROR" == "t" ]; then
                exit 1 
            fi
        fi
    fi
} # func_mmmv_include_bashfile_if_possible_t1

#--------------------------------------------------------------------------

func_mmmv_include_bashfile_if_possible_t2(){ # S_FP_BASHFILE S_GUID_CANDIDATE 
    local S_FP_BASHFILE="$1" # Full path to the file   
    local S_GUID_CANDIDATE="$2" 
    #----------------------------------------------------------------------
    # ~/.bashrc must not call the "exit" command.
    #-----------------------------------------
    local SB_INCLUSION_POSSIBLE="t"
    if [ "$S_FP_BASHFILE" == "" ]; then
        SB_INCLUSION_POSSIBLE="f"
        echo ""
        echo -e "The S_FP_BASHFILE \e[31mhad a value of an empty string\e[39m."
        if [ "$S_GUID_CANDIDATE" != "" ]; then
            echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        fi 
        echo "GUID=='4f76d486-c7cb-427e-b940-c071704067e7'"
        echo ""
    fi
    #-----------------------------------------
    if [ "$SB_INCLUSION_POSSIBLE" == "t" ]; then
        if [ ! -e "$S_FP_BASHFILE" ]; then
            SB_INCLUSION_POSSIBLE="f"
            echo ""
            echo "The "
            echo ""
            echo "    $S_FP_BASHFILE"
            echo ""
            echo -e "\e[31mdoes not exist or it is a broken symlink\e[39m."
            if [ "$S_GUID_CANDIDATE" != "" ]; then
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi 
            echo "GUID=='62f12cf6-1ef9-4176-be30-c071704067e7'"
            echo ""
        fi
    fi
    #-----------------------------------------
    if [ "$SB_INCLUSION_POSSIBLE" == "t" ]; then
        if [ -d "$S_FP_BASHFILE" ]; then
            SB_INCLUSION_POSSIBLE="f"
            echo ""
            echo "The "
            echo ""
            echo "    $S_FP_BASHFILE"
            echo ""
            echo -e "\e[31mreferences a folder\e[39m, but it must reference a file."
            if [ "$S_GUID_CANDIDATE" != "" ]; then
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi 
            echo "GUID=='d2c7d50c-e641-4994-9330-c071704067e7'"
            echo ""
        fi
    fi
    #----------------------------------------------------------------------
    if [ "$SB_INCLUSION_POSSIBLE" == "t" ]; then
        source "$S_FP_BASHFILE"
        func_mmmv_wait_and_sync_t1
        S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )" # to restore its value
    else
        if [ "$SB_INCLUSION_POSSIBLE" != "f" ]; then
            echo ""
            echo -e "\e[31mThe implementation of this function is flawed. \e[39m"
            echo "SB_INCLUSION_POSSIBLE==$SB_INCLUSION_POSSIBLE"
            if [ "$S_GUID_CANDIDATE" != "" ]; then
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi 
            echo "GUID=='d4f8584a-8fe1-45ec-aa40-c071704067e7'"
            echo ""
        fi
    fi
} # func_mmmv_include_bashfile_if_possible_t2

#--------------------------------------------------------------------------

func_mmmv_assert_exists_on_path_t1() {
    local S_NAME_OF_THE_EXECUTABLE="$1" # first function argument
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    local S_TMP_0="\`which $S_NAME_OF_THE_EXECUTABLE 2>/dev/null\`"
    local S_TMP_1=""
    local S_TMP_2="S_TMP_1=$S_TMP_0"
    eval ${S_TMP_2}
    if [ "$S_TMP_1" == "" ]; then
        S_TMP_0="This bash script requires the \""
        S_TMP_1="\" to be on the PATH."
        #--------
        echo ""
        echo -e "$S_TMP_0\e[31m$S_NAME_OF_THE_EXECUTABLE\e[39m$S_TMP_1"
        echo "GUID=='18b62811-95da-4db9-a510-c071704067e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1 # exit with an error
    fi
} # func_mmmv_assert_exists_on_path_t1

# Test/demo code:
#     func_mmmv_assert_exists_on_path_t1 "ruby"
#     func_mmmv_assert_exists_on_path_t1 "rubyy"
#--------------------------------------------------------------------------

func_mmmv_ln_create_or_overwrite_symlink_t1() { # S_FP_TARGET  S_FP_LINK
    local S_FP_TARGET="$1"
    local S_FP_LINK="$2"
    #----------------------------------------------------------------------
    local S_CMD_LN="ln -s $S_FP_TARGET $S_FP_LINK"
    if [ -e "$S_FP_LINK" ]; then
        local S_FP_OLDTARGET="`readlink $S_FP_LINK`"
        if [ "$S_FP_OLDTARGET" != "$S_FP_TARGET" ]; then
            rm -f $S_FP_LINK
            $S_CMD_LN
        fi
    else
        $S_CMD_LN
    fi
    if [ ! -e "$S_FP_LINK" ]; then
        echo ""
        echo ""
        echo -e "\e[31mBash function execution failed.  \e[39m"
        echo "Could not execute the command:"
        echo "$S_CMD_LN"
        echo ""
        echo "PWD==`pwd`"
        echo "GUID=='3778e9e5-59ee-4704-a62f-c071704067e7'"
        echo ""
        echo ""
        exit 1 # exit with an error
    fi
} # func_mmmv_ln_create_or_overwrite_symlink_t1

#--------------------------------------------------------------------------

func_mmmv_operatingsystem_is_Linux() { # S_OUTPUT_VARIABLE_NAME
    local S_OUTPUT_VARIABLE_NAME="$1"
    #----------------------------------------------------------------------
    local S_OUT="f"
    local S_X="`uname -a | grep -l Linux `"
    if [ "$S_X" == "(standard input)" ]; then
        S_OUT="t"
    fi
    local S_SCRIPT_0="$S_OUTPUT_VARIABLE_NAME=\"$S_OUT\""
    eval ${S_SCRIPT_0}
    # echo "ANSWER: $S_OUT"
} # func_mmmv_operatingsystem_is_Linux

#--------------------------------------------------------------------------

func_mmmv_operatingsystem_is_FreeBSD() { # S_SB_ANSWER
    local S_OUTPUT_VARIABLE_NAME="$1"
    #----------------------------------------------------------------------
    local S_OUT="f"
    local S_X="`uname -a | grep -l FreeBSD`"
    if [ "$S_X" == "(standard input)" ]; then
        S_OUT="t"
    fi
    local S_SCRIPT_0="$S_OUTPUT_VARIABLE_NAME=\"$S_OUT\""
    eval ${S_SCRIPT_0}
    # echo "ANSWER: $S_OUT"
} # func_mmmv_operatingsystem_is_FreeBSD

#--------------------------------------------------------------------------

func_mmmv_determine_operatingsystem_t1() {
    local SB_TMP_0_orig="$SB_TMP_0"
        func_mmmv_operatingsystem_is_Linux "SB_TMP_0"
        if [ "$SB_TMP_0" == "t" ]; then
            export S_MMMV_OPERATING_SYSTEM="linux"
        fi
        func_mmmv_operatingsystem_is_FreeBSD "SB_TMP_0"
        if [ "$SB_TMP_0" == "t" ]; then
            export S_MMMV_OPERATING_SYSTEM="freebsd"
        fi
    export SB_TMP_0="$SB_TMP_0_orig"
} # func_mmmv_determine_operatingsystem_t1

# Test/demo code:
#     func_mmmv_operatingsystem_is_Linux "S_OUTPUT_VARIABLE_NAME"
#     func_mmmv_operatingsystem_is_FreeBSD "S_SB_ANSWER"
#     func_mmmv_determine_operatingsystem_t1
#--------------------------------------------------------------------------

func_mmmv_exit_if_environment_variable_not_set_t1() { # S_ENVIRONMENT_VARIABLE_NAME
    local S_ENVIRONMENT_VARIABLE_NAME="$1"
    local S_ENVIRONMENT_VARIABLE_DOCSTRING="$2" # will be appended to failure-message
    #----------------------------------------------------------------------
    local S_ENVIR_VALUE=""
    local S_SCRIPT_0="S_ENVIR_VALUE=\"\`echo \$$S_ENVIRONMENT_VARIABLE_NAME\`\""
    eval "$S_SCRIPT_0"
    if [ "$S_ENVIR_VALUE" == "" ]; then
        echo ""
        echo -e "The environment variable $S_ENVIRONMENT_VARIABLE_NAME \e[31mis not set\e[39m, but "
        echo "it must be set or this script will not run (properly)."
        if [ "$S_ENVIRONMENT_VARIABLE_DOCSTRING" != "" ]; then
            echo ""
            echo "$S_ENVIRONMENT_VARIABLE_DOCSTRING"
        fi
        echo ""
        exit 1;
    #else 
         # echo "S_ENVIR_VALUE==\"$S_ENVIR_VALUE\""
    fi
} # func_mmmv_exit_if_environment_variable_not_set_t1

# Test/demo code:
#     func_mmmv_exit_if_environment_variable_not_set_t1 "CFLAGS" 

#--------------------------------------------------------------------------

func_mmmv_assert_Linux_or_BSD_t1(){
    local S_GUID_CANDIDATE="$1"
    #----------------------------------------------------------------------
    func_mmmv_exc_verify_S_FP_ORIG_t2
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mS_GUID_CANDIDATE==\"\", but it is expected to be a GUID. \e[39m"
        echo "GUID=='1afdad75-8c1f-4455-854f-c071704067e7'"
        echo ""
        # if [ "$S_FP_ORIG" != "" ]; then
        #     func_mmmv_exc_verify_S_FP_ORIG_t1
        #     cd "$S_FP_ORIG"
        # fi
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exit with an error
    fi 
    #--------------------
    #S_TMP_0="`uname -a | grep -E \"([Ll][Ii][Nn][Uu][Xx]|[Bb][Ss][Dd]|[Cc][Yy][Gg][Ww][Ii][Nn])\"`"
    S_TMP_0="`uname -a | grep -E \"([Ll][Ii][Nn][Uu][Xx]|[Bb][Ss][Dd])\"`"
    if [ "$S_TMP_0" == "" ]; then
        echo ""
        echo "The classical command line utilities at "
        echo "different operating systems, for example, Linux and BSD,"
        echo "differ. This script is designed to run only on Linux and BSD."
        echo "If You are willing to risk that some of Your data "
        echo "is deleted and/or Your operating system instance"
        echo "becomes permanently flawed, to the point that "
        echo "it will not even boot, then You may edit the Bash script that "
        echo "calls the function that displays this error message "
        echo "by uncommenting that function."
        echo ""
        echo "If You do decide to edit the Bash script, then "
        echo "a recommendation is to test Your modifications "
        echo "within a virtual appliance or, if virtual appliances are not"
        echo "an option, as some new operating system user that does not have "
        echo "any access to the vital data/files."
        echo ""
        echo "Aborting script without doing anything."
        echo ""
        echo "GUID=='6a1133c7-f361-4d6c-bd4f-c071704067e7'"
        echo ""
        # if [ "$S_FP_ORIG" != "" ]; then
        #     func_mmmv_exc_verify_S_FP_ORIG_t1
        #     cd "$S_FP_ORIG"
        # fi
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exit with an error
    fi
} # func_mmmv_assert_Linux_or_BSD_t1

#--------------------------------------------------------------------------

func_mmmv_verify_that_internet_connection_exists_but_do_not_exit_t1(){
    #----------------------------------------------------------------------
    local S_GUID_CANDIDATE="$1"
    local SB_DISPLAY_NONERROR_FEEDBACK="$2" # domain: {"t","f",""}
                                            # ""==="f", default "f"
    #----------------------------------------------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mThe Bash code that calls this function is flawed \e[39m."
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "GUID=='2627dd02-5f4c-420e-852f-c071704067e7'"
        echo ""
    fi
    #----------------------------------------------------------------------
    if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "" ]; then
        SB_DISPLAY_NONERROR_FEEDBACK="f"
    else
        #----------------------------------------
        if [ "$SB_DISPLAY_NONERROR_FEEDBACK" != "t" ]; then
            if [ "$SB_DISPLAY_NONERROR_FEEDBACK" != "f" ]; then
                #----------------------------------------
                if [ "$S_GUID_CANDIDATE" != "" ]; then
                    func_mmmv_assert_sbvar_domain_t_f_but_do_not_exit_t1 \
                        "$SB_DISPLAY_NONERROR_FEEDBACK" \
                        "SB_DISPLAY_NONERROR_FEEDBACK" \
                        "$S_GUID_CANDIDATE"
                else
                    func_mmmv_assert_sbvar_domain_t_f_but_do_not_exit_t1 \
                        "$SB_DISPLAY_NONERROR_FEEDBACK" \
                        "SB_DISPLAY_NONERROR_FEEDBACK" \
                        "80c46e37-c071-422f-b480-c071704067e7"
                fi
                SB_DISPLAY_NONERROR_FEEDBACK="f"
                #----------------------------------------
            fi
        fi
        #----------------------------------------
    fi
    #----------------------------------------------------------------------
    func_mmmv_assert_exists_on_path_t1 "timeout"
    func_mmmv_assert_exists_on_path_t1 "ping"
    #----------------------------------------------------------------------
    # A global variable for storing function output.
    SB_VERIFICATION_FAILED="t" # domain: "t", "f" .
    #----------------------------------------
    local SB_DOMAIN_IS_REACHABLE="f"
    local S_CMD_PREFIX="timeout 3s nice -n 5 ping -c 30 "
    local SI_ERR_CODE="1" 
    #----------------------------------------------------------------------
    if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
        echo "Testing, whether there is internet connectivity..."
    fi
    #----------------------------------------------------------------------
# RENESSAATOR_BLOCK_START
# RENESSAATOR_BLOCK_ID=block_e6295e62-4c0c-4fef-a19e-02f1e0f337e7_city
# RENESSAATOR_SOURCE_LANGUAGE=Ruby
# RENESSAATOR_SOURCE_START
# s=""
# s<<'    #----------------------------------------------------------------------'
# s<<"\n"
# s<<'    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then '
# s<<"\n"
# s<<"        # The redirection to /dev/null at the next line \n"
# s<<'        timeout BLANK41s nice -n 5 ping -c 30 "BLANK42" 2> /dev/null 1> /dev/null '
# s<<"\n"
# s<<"        # has been tested to work on both, Linux and FreeBSD. \n"
# s<<'        SI_ERR_CODE="$?" ; wait ; '
# s<<"\n"
# s<<'        if [ "$SI_ERR_CODE" == "0" ]; then '
# s<<"\n"
# s<<'            SB_DOMAIN_IS_REACHABLE="t" '
# s<<"\n"
# s<<'        else '
# s<<"\n"
# s<<'            if [ "$SI_ERR_CODE" == "124" ]; then '
# s<<"\n"
# s<<'                SB_DOMAIN_IS_REACHABLE="t" '
# s<<"\n"
# s<<'            fi '
# s<<"\n"
# s<<'        fi '
# s<<"\n"
# s<<'    fi '
# s<<"\n"
# ar=["softf1.com", "softf1.net", "google.com", "bing.com", "ibm.com", "eesti.ee"]
# puts((""+s).sub(/BLANK41/,"1").sub(/BLANK42/,ar[0])) # to make the Bash script faster
# ar.each do |s_domain|
# puts((""+s).sub(/BLANK41/,"3").sub(/BLANK42/,s_domain))
# end # loop
# RENESSAATOR_SOURCE_END
# 
# RENESSAATOR_AUTOGENERATED_TEXT_START
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then 
        # The redirection to /dev/null at the next line 
        timeout 1s nice -n 5 ping -c 30 "softf1.com" 2> /dev/null 1> /dev/null 
        # has been tested to work on both, Linux and FreeBSD. 
        SI_ERR_CODE="$?" ; wait ; 
        if [ "$SI_ERR_CODE" == "0" ]; then 
            SB_DOMAIN_IS_REACHABLE="t" 
        else 
            if [ "$SI_ERR_CODE" == "124" ]; then 
                SB_DOMAIN_IS_REACHABLE="t" 
            fi 
        fi 
    fi 
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then 
        # The redirection to /dev/null at the next line 
        timeout 3s nice -n 5 ping -c 30 "softf1.com" 2> /dev/null 1> /dev/null 
        # has been tested to work on both, Linux and FreeBSD. 
        SI_ERR_CODE="$?" ; wait ; 
        if [ "$SI_ERR_CODE" == "0" ]; then 
            SB_DOMAIN_IS_REACHABLE="t" 
        else 
            if [ "$SI_ERR_CODE" == "124" ]; then 
                SB_DOMAIN_IS_REACHABLE="t" 
            fi 
        fi 
    fi 
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then 
        # The redirection to /dev/null at the next line 
        timeout 3s nice -n 5 ping -c 30 "softf1.net" 2> /dev/null 1> /dev/null 
        # has been tested to work on both, Linux and FreeBSD. 
        SI_ERR_CODE="$?" ; wait ; 
        if [ "$SI_ERR_CODE" == "0" ]; then 
            SB_DOMAIN_IS_REACHABLE="t" 
        else 
            if [ "$SI_ERR_CODE" == "124" ]; then 
                SB_DOMAIN_IS_REACHABLE="t" 
            fi 
        fi 
    fi 
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then 
        # The redirection to /dev/null at the next line 
        timeout 3s nice -n 5 ping -c 30 "google.com" 2> /dev/null 1> /dev/null 
        # has been tested to work on both, Linux and FreeBSD. 
        SI_ERR_CODE="$?" ; wait ; 
        if [ "$SI_ERR_CODE" == "0" ]; then 
            SB_DOMAIN_IS_REACHABLE="t" 
        else 
            if [ "$SI_ERR_CODE" == "124" ]; then 
                SB_DOMAIN_IS_REACHABLE="t" 
            fi 
        fi 
    fi 
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then 
        # The redirection to /dev/null at the next line 
        timeout 3s nice -n 5 ping -c 30 "bing.com" 2> /dev/null 1> /dev/null 
        # has been tested to work on both, Linux and FreeBSD. 
        SI_ERR_CODE="$?" ; wait ; 
        if [ "$SI_ERR_CODE" == "0" ]; then 
            SB_DOMAIN_IS_REACHABLE="t" 
        else 
            if [ "$SI_ERR_CODE" == "124" ]; then 
                SB_DOMAIN_IS_REACHABLE="t" 
            fi 
        fi 
    fi 
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then 
        # The redirection to /dev/null at the next line 
        timeout 3s nice -n 5 ping -c 30 "ibm.com" 2> /dev/null 1> /dev/null 
        # has been tested to work on both, Linux and FreeBSD. 
        SI_ERR_CODE="$?" ; wait ; 
        if [ "$SI_ERR_CODE" == "0" ]; then 
            SB_DOMAIN_IS_REACHABLE="t" 
        else 
            if [ "$SI_ERR_CODE" == "124" ]; then 
                SB_DOMAIN_IS_REACHABLE="t" 
            fi 
        fi 
    fi 
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then 
        # The redirection to /dev/null at the next line 
        timeout 3s nice -n 5 ping -c 30 "eesti.ee" 2> /dev/null 1> /dev/null 
        # has been tested to work on both, Linux and FreeBSD. 
        SI_ERR_CODE="$?" ; wait ; 
        if [ "$SI_ERR_CODE" == "0" ]; then 
            SB_DOMAIN_IS_REACHABLE="t" 
        else 
            if [ "$SI_ERR_CODE" == "124" ]; then 
                SB_DOMAIN_IS_REACHABLE="t" 
            fi 
        fi 
    fi 

# RENESSAATOR_AUTOGENERATED_TEXT_END
# RENESSAATOR_BLOCK_END
    #----------------------------------------------------------------------
    if [ "$SB_DOMAIN_IS_REACHABLE" == "f" ]; then
        SB_VERIFICATION_FAILED="t"
        if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
            echo -e "\e[33mTest failed\e[39m. Replies to pings were NOT received."
            echo "GUID=='ef424826-ec92-4a4c-865f-c071704067e7'"
            if [ "$S_GUID_CANDIDATE" != "" ]; then
                echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
            fi
        fi
    else
        SB_VERIFICATION_FAILED="f"
        if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
            echo -e "\e[32mTest passed\e[39m. It was possible to receive replies to pings."
        fi
    fi
    wait # to make sure that the echo commands 
         # complete before anything else is printed to stdout
    #----------------------------------------------------------------------
} # func_mmmv_verify_that_internet_connection_exists_but_do_not_exit_t1

#--------------------------------------------------------------------------

SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_RESULT_CACHED="f"
SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_INTERNET_CONNECTION_EXISTS="f"
func_mmmv_assert_internet_connection_exists_t1(){
    #----------------------------------------------------------------------
    local S_GUID_CANDIDATE="$1"
    local SB_OK_TO_CACHE="$2" # domain: {"t","f",""}
                              # ""==="f", default "f"
    local SB_DISPLAY_NONERROR_FEEDBACK="$3" # domain: {"t","f",""}
                                            # ""==="f", default "f"
    #----------------------------------------------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mThe Bash code that calls this function is flawed \e[39m."
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "Aborting script."
        echo "GUID=='5c7a0821-5665-418c-941f-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1
    fi
    #----------------------------------------------------------------------
    if [ "$SB_OK_TO_CACHE" == "" ]; then
        SB_OK_TO_CACHE="f"
    else
        func_mmmv_assert_sbvar_domain_t_f_t1 \
            "$SB_OK_TO_CACHE" "SB_OK_TO_CACHE" \
            "129d98ee-52fc-4274-9580-c071704067e7"
    fi
    #----------------------------------------------------------------------
    if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "" ]; then
        SB_DISPLAY_NONERROR_FEEDBACK="f"
    else
        func_mmmv_assert_sbvar_domain_t_f_t1 \
            "$SB_DISPLAY_NONERROR_FEEDBACK" "SB_DISPLAY_NONERROR_FEEDBACK" \
            "13d8cd3b-e47f-40de-9180-c071704067e7" 
    fi
    #----------------------------------------------------------------------
    func_mmmv_assert_sbvar_domain_t_f_t1 \
        "$SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_RESULT_CACHED" \
        "SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_RESULT_CACHED" \
        "4b89c34e-0c34-4f54-9370-c071704067e7"
    func_mmmv_assert_sbvar_domain_t_f_t1 \
        "$SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_INTERNET_CONNECTION_EXISTS" \
        "SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_INTERNET_CONNECTION_EXISTS" \
        "0c09755e-8e4a-4e37-a470-c071704067e7"
    #----------------------------------------------------------------------
    local SB_INTERNET_AVAILABLE="f"
    local SB_STUDY_INTERNET_AVAILABILITY="f"
    #----------------------------------------------------------------------
    if [ "$SB_OK_TO_CACHE" == "t" ]; then
        if [ "$SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_RESULT_CACHED" == "t" ]; then
            SB_INTERNET_AVAILABLE="$SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_INTERNET_CONNECTION_EXISTS"
            #SB_STUDY_INTERNET_AVAILABILITY="f"
        else
            SB_STUDY_INTERNET_AVAILABILITY="t"
        fi
    else
        SB_STUDY_INTERNET_AVAILABILITY="t"
    fi
    #----------------------------------------------------------------------
    if [ "$SB_STUDY_INTERNET_AVAILABILITY" == "t" ]; then
        #----------------------------------------
        # The 
        func_mmmv_verify_that_internet_connection_exists_but_do_not_exit_t1 \
            "3012a1c1-70dd-4bae-8360-c071704067e7" \
            "$SB_DISPLAY_NONERROR_FEEDBACK"
        # retunrs its result in a global variable named 
        # SB_VERIFICATION_FAILED="t" # domain: "t", "f" .
        if [ "$SB_VERIFICATION_FAILED" == "t" ]; then
            SB_INTERNET_AVAILABLE="f"
        else
            if [ "$SB_VERIFICATION_FAILED" == "f" ]; then
                SB_INTERNET_AVAILABLE="t"
            else
                func_mmmv_assert_sbvar_domain_t_f_t1 \
                    "$SB_VERIFICATION_FAILED" \
                    "SB_VERIFICATION_FAILED" \
                    "13971f40-d0d9-4583-b260-c071704067e7"
            fi
        fi
        #----------------------------------------
        SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_INTERNET_CONNECTION_EXISTS="$SB_INTERNET_AVAILABLE"
        SB_FUNC_MMMV_ASSERT_INTERNET_CONNECTION_EXISTS_T1_RESULT_CACHED="t"
        #----------------------------------------
    fi
    #----------------------------------------------------------------------
    if [ "$SB_INTERNET_AVAILABLE" == "f" ]; then
        echo ""
        echo -e "\e[31mInternet could not be reached\e[39m."
        echo -e "Aborting script."
        echo "GUID=='45f76de1-ff74-44cd-b1de-c071704067e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1
    fi
    #----------------------------------------------------------------------
} # func_mmmv_assert_internet_connection_exists_t1

#--------------------------------------------------------------------------

SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_RESULT_CACHED="f"
SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_GUI_IS_LAUNCHABLE="f"
func_mmmv_assert_GUI_applications_can_be_launched_t1(){
    #----------------------------------------------------------------------
    local S_GUID_CANDIDATE="$1"
    local SB_OK_TO_CACHE="$2" # domain: {"t","f",""}
                              # ""==="f", default "f"
    local SB_DISPLAY_NONERROR_FEEDBACK="$3" # domain: {"t","f",""}
                                            # ""==="f", default "f"
    #----------------------------------------------------------------------
    if [ "$S_GUID_CANDIDATE" == "" ]; then
        echo ""
        echo -e "\e[31mThe Bash code that calls this function is flawed \e[39m."
        echo ""
        echo "    S_GUID_CANDIDATE==\"\""
        echo ""
        echo "but it is expected to be a GUID."
        echo "Aborting script."
        echo "GUID=='323edbc8-fa85-4360-958e-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1
    fi
    #----------------------------------------------------------------------
    if [ "$SB_OK_TO_CACHE" == "" ]; then
        SB_OK_TO_CACHE="f"
    else
        func_mmmv_assert_sbvar_domain_t_f_t1 \
            "$SB_OK_TO_CACHE" "SB_OK_TO_CACHE" \
            "b3dc6d22-2ed1-462b-9560-c071704067e7"
    fi
    #----------------------------------------------------------------------
    if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "" ]; then
        SB_DISPLAY_NONERROR_FEEDBACK="f"
    else
        func_mmmv_assert_sbvar_domain_t_f_t1 \
            "$SB_DISPLAY_NONERROR_FEEDBACK" "SB_DISPLAY_NONERROR_FEEDBACK" \
            "fc21be2b-204f-4035-8550-c071704067e7" 
    fi
    #----------------------------------------------------------------------
    func_mmmv_assert_sbvar_domain_t_f_t1 \
        "$SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_RESULT_CACHED" \
        "SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_RESULT_CACHED" \
        "bf8b1141-12b1-4284-b350-c071704067e7"
    func_mmmv_assert_sbvar_domain_t_f_t1 \
        "$SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_GUI_IS_LAUNCHABLE" \
        "SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_GUI_IS_LAUNCHABLE" \
        "165d2830-bc88-41c2-a550-c071704067e7"
    #----------------------------------------------------------------------
    local SB_RUN_TEST="t"
    if [ "$SB_OK_TO_CACHE" == "t" ]; then
        if [ "$SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_RESULT_CACHED" == "t" ]; then
            SB_RUN_TEST="f"
            if [ "$SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_GUI_IS_LAUNCHABLE" == "f" ]; then
                echo ""
                echo -e "\e[31mThis Bash function is flawed \e[39m."
                echo "The control flow should have never reached this if-statement, because"
                echo "the Bash program should have terminated at the "
                echo "previous run of this function, when it was discovered that "
                echo "GUI applications can not be launched."
                echo "Aborting script."
                echo "GUID=='7c6f1743-f7ad-44c3-b75e-c071704067e7'"
                echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
                echo ""
                #--------
                cd "$S_FP_ORIG"
                exit 1
            fi
        fi
    fi
    #----------------------------------------------------------------------
    if [ "$SB_RUN_TEST" == "t" ]; then
        #------------------------------------------------------------------
        func_mmmv_assert_exists_on_path_t1 "timeout"
        func_mmmv_assert_exists_on_path_t1 "xeyes" # needed for fast testing
        #------------------------------------------------------------------
        if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
            echo "Launching the xeyes application for about 2 seconds to test, "
            echo "whether it is possible to launch GUI applications..."
        fi
        nice -n 5 timeout 2s xeyes
        local S_TMP_0="$?"
        if [ "$S_TMP_0" != "124" ]; then
            #--------
            SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_GUI_IS_LAUNCHABLE="f"
            SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_RESULT_CACHED="t"
            #--------
            echo ""
            echo -e "It seems that it is\e[31m NOT possible to launch GUI applications\e[39m."
            echo "Aborting script."
            echo "GUID=='7240c057-f959-42eb-931e-c071704067e7'"
            echo "S_GUID_CANDIDATE==\"$S_GUID_CANDIDATE\""
            echo ""
            #--------
            cd "$S_FP_ORIG"
            exit 1
        fi
        wait ;
        if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
            echo -e "\e[32mTest passed\e[39m. The xeyes could be launched successfully."
        fi
        SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_GUI_IS_LAUNCHABLE="t"
        SB_FUNC_MMMV_ASSERT_GUI_APPLICATIONS_CAN_BE_LAUNCHED_T1_RESULT_CACHED="t"
        wait ;
        #------------------------------------------------------------------
    fi
    #----------------------------------------------------------------------
} # func_mmmv_assert_GUI_applications_can_be_launched_t1

#--------------------------------------------------------------------------

func_mmmv_exc_initialize_wine_C_drive_if_needed_t1(){
    #----------------------------------------------------------------------
    local SB_DISPLAY_NONERROR_FEEDBACK="$1" # domain: {"t","f",""}
                                            # ""==="f", default "f"
    #----------------------------------------------------------------------
    if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "" ]; then
        SB_DISPLAY_NONERROR_FEEDBACK="f"
    else
        func_mmmv_assert_sbvar_domain_t_f_t1 \
            "$SB_DISPLAY_NONERROR_FEEDBACK" "SB_DISPLAY_NONERROR_FEEDBACK" \
            "0a514933-2ce3-42db-a240-c071704067e7" 
    fi
    #----------------------------------------------------------------------
    local S_FP_WINE_HOME="$HOME/.wine"
    local S_FP_C="$S_FP_WINE_HOME/drive_c"
    local SB_OPTIONAL_BAN_SYMLINKS="f"
    local SB_OK_TO_CACHE="t"
    #----------------------------------------------------------------------
    if [ ! -d "$S_FP_C" ]; then # for speed optimisation
        if [ ! -e "$S_FP_C" ]; then
            #--------------------------------------------------------------
            if [ ! -e "$S_FP_WINE_HOME" ]; then
                # The if-clause at the next line is to improve error messages.
                if [ -h "$S_FP_WINE_HOME" ]; then # a broken symlink
                    func_mmmv_assert_folder_exists_t1 "$S_FP_WINE_HOME" \
                        "a80a0021-6284-4a90-9140-c071704067e7" \
                        "$SB_OPTIONAL_BAN_SYMLINKS"
                fi
            fi
            if [ -h "$S_FP_C" ]; then # a broken symlink
                func_mmmv_assert_folder_exists_t1 "$S_FP_C" \
                    "35984571-053e-4004-9240-c071704067e7" \
                    "$SB_OPTIONAL_BAN_SYMLINKS"
            fi
            #--------------------------------------------------------------
            if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
                echo -e "Starting to create \"\e[33m$S_FP_C\e[39m\" by using wine ..."
            fi
            func_mmmv_assert_exists_on_path_t1 "wine"
            if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
                echo "Wine dialogs use GUI."
            fi
            SB_OK_TO_CACHE="t" # domain: {"t","f",""}; default: "" -> "f"
            func_mmmv_assert_GUI_applications_can_be_launched_t1 \
                "a1e2fb35-de3e-4cff-9430-c071704067e7" \
                "$SB_OK_TO_CACHE" "$SB_DISPLAY_NONERROR_FEEDBACK"
            if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
                echo -e "Creating the \"\e[33m$S_FP_C\e[39m\" and executing the "
                echo -e "Wine version of \"\e[33mC:\\windows\\system32\\hostname.exe\e[39m\" ..."
            fi
            if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
                nice -n 5 wine 'hostname' # creates ~/.wine/drive_c and
                                          # executes C:\windows\system32\hostname.exe
            else
                # The redirection part of the 
                nice -n 5 wine 'hostname' 2> /dev/null 1> /dev/null 
                # has been tested to work on both, Linux and FreeBSD. 
            fi
            func_mmmv_assert_error_code_zero_t1 "$?" \
                "28921e74-3cf5-4033-a430-c071704067e7"
            func_mmmv_wait_and_sync_t1
            func_mmmv_assert_folder_exists_t1 "$S_FP_C" \
                "b9ad8d23-fcbc-4084-9430-c071704067e7" \
                "$SB_OPTIONAL_BAN_SYMLINKS"
            if [ "$SB_DISPLAY_NONERROR_FEEDBACK" == "t" ]; then
                echo -e "Creation of \"$S_FP_C\"\e[32m complete\e[39m." ; wait;
            fi
            #--------------------------------------------------------------
        else
            #--------------------------------------------------------------
            func_mmmv_assert_folder_exists_t1 "$S_FP_C" \
                "07436353-5c4c-4870-9520-c071704067e7" \
                "$SB_OPTIONAL_BAN_SYMLINKS"
            #--------------------------------------------------------------
        fi
    fi
    #----------------------------------------------------------------------
} # func_mmmv_exc_initialize_wine_C_drive_if_needed_t1

#--------------------------------------------------------------------------

#S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
if [ "$S_FP_DIR" == "" ]; then
    echo ""
    echo "The environment variable S_FP_DIR has not been defined."
    echo -e "\e[31mExiting with an error. \e[39m"
    echo "GUID=='402cae04-2cd4-4f4c-815e-c071704067e7'"
    echo ""
    if [ "$S_FP_ORIG" != "" ]; then
        func_mmmv_exc_verify_S_FP_ORIG_t1
        cd "$S_FP_ORIG"
    fi
    exit 1
fi
#-------------------------------------------
if [ "$S_FP_ORIG" == "" ]; then
    echo ""
    echo "The environment variable S_FP_ORIG has not been defined."
    echo -e "\e[31mExiting with an error. \e[39m"
    echo "GUID=='c8161248-2352-4a2b-a84e-c071704067e7'"
    echo ""
    exit 1
else
    func_mmmv_exc_verify_S_FP_ORIG_t2
fi


#--------------------------------------------------------------------------

S_FP_PARENT_FOLDER="$S_FP_DIR"  # will be overwritten by the 
func_mmmv_uncompress_tar_dot_foo_and_enter_t1(){
    #----------------------------------------
    local S_FN_FOLDER_NAME="$1"
    local S_FILE_EXTENTION_OF_A_COMPRESSED_FILE="$2"
    #----------------------------------------
    local SB_COMPRESSION_TYPE_RECOGNIZED="f"
    local S_CMD_NICE_PREFIX="nice -n 5 "
    local S_CMD_UNCOMPRESS="not_set"
    local SB_COMPRESSIONLESS_TAR="f"
    #----------------------------------------
    #if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "tar" ]; then
            SB_COMPRESSIONLESS_TAR="t"
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "TAR" ]; then
                SB_COMPRESSIONLESS_TAR="t"
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    #fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "7z" ]; then
            S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX 7z x " # The "x" is not a typo.
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "7Z" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX 7z x " # The "x" is not a typo.
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "t7z" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX 7z x " # The "x" is not a typo.
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "T7Z" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX 7z x " # The "x" is not a typo.
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "xz" ]; then
            S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unxz "
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "XZ" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unxz "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "txz" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unxz "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "TXZ" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unxz "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "gz" ]; then
            S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX gunzip "
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "GZ" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX gunzip "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "tgz" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX gunzip "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "TGZ" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX gunzip "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "bz2" ]; then
            S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX bunzip2 "
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "BZ2" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX bunzip2 "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "tbz2" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX bunzip2 "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "TBZ2" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX bunzip2 "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "zip" ]; then
            S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unzip "
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "ZIP" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unzip "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "tzip" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unzip "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "TZIP" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unzip "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "rar" ]; then
            S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unrar x " # The "x" is not a typo
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "RAR" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unrar x " # The "x" is not a typo
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "trar" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unrar x " # The "x" is not a typo
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "TRAR" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX unrar x " # The "x" is not a typo
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" == "f" ]; then
        if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "xar" ]; then
            S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX xar -xf "
            SB_COMPRESSION_TYPE_RECOGNIZED="t"
        else
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "XAR" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX xar -xf "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "txar" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX xar -xf "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
            if [ "$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE" == "TXAR" ]; then
                S_CMD_UNCOMPRESS="$S_CMD_NICE_PREFIX xar -xf "
                SB_COMPRESSION_TYPE_RECOGNIZED="t"
            fi
        fi
    fi
    #----------------------------------------
    if [ "$SB_COMPRESSION_TYPE_RECOGNIZED" != "t" ]; then
        echo ""
        echo "Failed to recognize compression type."
        echo "Aborting script."
        echo "GUID=='141b69af-3b75-4259-b5ed-c071704067e7'"
        echo ""
        #--------
        cd "$S_FP_ORIG"
        exit 1 # exiting with an error
    fi
    #----------------------------------------
    func_mmmv_assert_folder_exists_t1 "$S_FP_PARENT_FOLDER" \
        "485721b5-5a2a-4e7e-b220-c071704067e7"
    cd $S_FP_PARENT_FOLDER
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "f86f185c-1719-4f55-8510-c071704067e7"
    #----------------------------------------
    local S_FP_NEXT_PARENT_FOLDER="$S_FP_PARENT_FOLDER/$S_FN_FOLDER_NAME"
    local S_TMP_0=".tar"
    local S_FP_TAR="$S_FP_NEXT_PARENT_FOLDER$S_TMP_0"
    S_TMP_0=".$S_FILE_EXTENTION_OF_A_COMPRESSED_FILE"
    local S_FP_COMPRESSED="$S_FP_TAR$S_TMP_0"
    #----------------------------------------
    if [ "$SB_COMPRESSIONLESS_TAR" == "f" ]; then
        func_mmmv_assert_file_exists_t1 "$S_FP_COMPRESSED" \
            "63f15e5c-4add-491e-b510-c071704067e7"
        $S_CMD_UNCOMPRESS $S_FP_COMPRESSED
        func_mmmv_assert_error_code_zero_t1 "$?" \
            "e3608242-372e-4d92-8110-c071704067e7"
        func_mmmv_wait_and_sync_t1
    fi
    #----------------------------------------
    func_mmmv_assert_file_exists_t1 "$S_FP_TAR" \
        "53b06593-1d1b-46c1-9700-c071704067e7"
    $S_CMD_NICE_PREFIX tar -xf $S_FP_TAR
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "f387cc6f-7598-4be1-a300-c071704067e7"
    func_mmmv_wait_and_sync_t1
    #----------------------------------------
    func_mmmv_assert_folder_exists_t1 "$S_FP_NEXT_PARENT_FOLDER" \
        "cd2f9bf7-2199-4720-9800-c071704067e7"
    S_FP_PARENT_FOLDER="$S_FP_NEXT_PARENT_FOLDER"
    #----------------------------------------
} # func_mmmv_uncompress_tar_dot_foo_and_enter_t1

#--------------------------------------------------------------------------
#
func_first_use_message(){
    echo ""
    echo -e "\e[33mPlease customise this script to Your needs.\e[39m"
    echo "GUID=='d7d06ff4-a399-4134-bb1d-c071704067e7'"
    echo ""
    #------------------------------
    cd "$S_FP_ORIG"
    exit 1
    #------------------------------
} # func_first_use_message

#--------------------------------------------------------------------------

func_display_help_message(){
    echo ""
    echo "This script does not take any configuration command line arguments."
    echo "It's current parameters, which are menat to be manually updated at "
    echo ""
    echo "    func_initialize_configuration_by_initializing_global_variables()"
    echo ""
    echo "are:"
    echo ""
    echo -e "    S_FP_BUILD_FOLDER=\"\e[96m$S_FP_BUILD_FOLDER\e[39m\""
    echo ""
    echo -e "    S_FP_INSTALLATION_FOLDER=\"\e[96m$S_FP_INSTALLATION_FOLDER\e[39m\""
    echo ""
    echo -e "    S_FP_SRC=\"\e[96m$S_FP_SRC\e[39m\""
    echo ""
    echo "Thank You for trying out this script. "
    echo ""
} # func_display_help_message

#--------------------------------------------------------------------------

S_CMD_GNU_MAKE="make"
S_CMD_GNU_SED="sed"
func_check_for_some_dependencies(){
    #----------------------------------------------------------------------
    #func_mmmv_assert_exists_on_path_t1 "ar"
    func_mmmv_assert_exists_on_path_t1 "cat"
    func_mmmv_assert_exists_on_path_t1 "sh"
    #func_mmmv_assert_exists_on_path_t1 "grep" # already checked at help func
    #func_mmmv_assert_exists_on_path_t1 "flex"
    #func_mmmv_assert_exists_on_path_t1 "ranlib"
    #------------------------------
    if [ "$CC" == "" ]; then
        export CC="gcc"
    fi
    if [ "$CXX" == "" ]; then
        export CXX="g++"
    fi
    func_mmmv_assert_exists_on_path_t1 "$CC"
    func_mmmv_assert_exists_on_path_t1 "$CXX"
    #------------------------------
    func_mmmv_assert_exists_on_path_t1 "gunzip"   # .gz
    func_mmmv_assert_exists_on_path_t1 "tar"      # .tar
    func_mmmv_assert_exists_on_path_t1 "unxz"     # .xz
    #func_mmmv_assert_exists_on_path_t1 "bunzip2" # .bz2
    #func_mmmv_assert_exists_on_path_t1 "unzip"   # .zip
    #func_mmmv_assert_exists_on_path_t1 "unrar"   # .rar
    #func_mmmv_assert_exists_on_path_t1 "xar"   # .xar
    #------------------------------
    # The test for the availability of grep is 
    # expected to be somewhere above this line.
    if [ "`uname -a | grep -i 'BSD' `" != '' ]; then 
        S_CMD_GNU_MAKE="gmake"
        S_CMD_GNU_SED="gsed" 
    fi 
    func_mmmv_assert_exists_on_path_t1 "$S_CMD_GNU_MAKE"
    func_mmmv_assert_exists_on_path_t1 "$S_CMD_GNU_SED"
    #----------------------------------------------------------------------
} # func_check_for_some_dependencies

#--------------------------------------------------------------------------
S_ARGV_0="$1" # Bash style command line argument indices versus 
              # Ruby style command line argument indices. 

func_display_help_message_and_exit_if_needed(){
    #----------------------------------------------------------------------
    func_mmmv_assert_exists_on_path_t1 "grep" 
    #------------------------------
    local SB_0="f"
    if [ "$S_ARGV_0" != "" ]; then
        if [ "`echo \"$S_ARGV_0\" | grep -E '^((([-][-]?)?[hH][eE][lL][pP])|([-]?[hH?]))$' `" == "" ]; then
            echo ""
            echo -e "\e[31mUnsupported \e[39mcommand line argument: \"\e[31m$S_ARGV_0\e[39m\""
            echo "GUID=='55c79e62-8450-4272-a42d-c071704067e7'"
            echo "The only command line argument that is supported is \"help\", which"
            echo "does nothing other than display the following message:"
            func_display_help_message
            #--------
            cd "$S_FP_ORIG"
            exit 1
        else
            SB_0="t"
        fi
    fi
    if [ "$SB_0" == "t" ]; then
        func_display_help_message
        #--------
        cd "$S_FP_ORIG"
        exit 0
    fi
    #----------------------------------------------------------------------
} # func_display_help_message_and_exit_if_needed

#--------------------------------------------------------------------------

func_initialize_configuration_by_initializing_global_variables(){
    #func_first_use_message # Please outcomment this line during the customisation.
    #----------------------------------------------------------------------
    func_mmmv_init_s_timestamp_if_not_inited_t1
    #----------------------------------------------------------------------
    # The parts that probably need to be customised:
    S_FP_INSTALLATION_FOLDER="`cd $S_FP_DIR/../../ ; pwd `/v2015_03_xx/bonnet"
    S_FP_BUILD_FOLDER="$S_FP_INSTALLATION_FOLDER/build_folder_$S_TIMESTAMP"
    S_FP_SRC="$S_FP_DIR/mined-2015.25_modified_by_3rd_party.tar.xz"
    S_CMD_PREFIX_NICE="nice -n 4 "
    #----------------------------------------------------------------------
} # func_initialize_configuration_by_initializing_global_variables

#--------------------------------------------------------------------------

func_main(){
    #------------------------------
    func_initialize_configuration_by_initializing_global_variables
    func_display_help_message_and_exit_if_needed
    func_check_for_some_dependencies
    #------------------------------
    func_mmmv_assert_folder_exists_t1 "$S_FP_DIR" \
        "24adc434-fdcb-47b3-8400-c071704067e7"
    cd $S_FP_DIR
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "17d79c43-194d-4d56-b72f-c071704067e7"
    func_mmmv_assert_file_exists_t1 "$S_FP_SRC" \
        "33bc3093-419a-44c8-8c5f-c071704067e7"
    #------------------------------
    mkdir -p $S_FP_BUILD_FOLDER
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "57fc5974-f0e3-46fd-a92f-c071704067e7"
    func_mmmv_wait_and_sync_t1
    func_mmmv_assert_folder_exists_t1 "$S_FP_BUILD_FOLDER" \
        "e150171a-9cc7-427c-923f-c071704067e7"
    # In this case the build folder is a sub-folder of the installation folder.
    func_mmmv_assert_folder_exists_t1 "$S_FP_INSTALLATION_FOLDER" \
        "42e12132-886a-4682-ab2e-c071704067e7"
    #------------------------------
    $S_CMD_PREFIX_NICE cp -f $S_FP_SRC $S_FP_BUILD_FOLDER/
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "954d6102-1084-4681-821e-c071704067e7"
    func_mmmv_wait_and_sync_t1
    cd $S_FP_BUILD_FOLDER
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "9460684d-7ed5-460d-8c1e-c071704067e7"
    #------------------------------
    S_FP_PARENT_FOLDER="$S_FP_BUILD_FOLDER"
    func_mmmv_uncompress_tar_dot_foo_and_enter_t1 \
        "mined-2015.25_modified_by_3rd_party" "xz"
    local S_FP_SRC_FOLDER="$S_FP_PARENT_FOLDER" # as assigned by the 
                                                # func_mmmv_uncompress_tar_dot_foo_and_enter_t1 
    func_mmmv_assert_folder_exists_t1 "$S_FP_SRC_FOLDER" \
        "9173fa08-36b1-44ae-981d-c071704067e7"
    cd "$S_FP_SRC_FOLDER"
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "41f06fa1-283a-45a5-9f4b-c071704067e7"
    $S_CMD_PREFIX_NICE $S_CMD_GNU_MAKE
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "48cdb663-a718-4244-9d5b-c071704067e7"
    func_mmmv_wait_and_sync_t1
    #------------------------------
    local S_FP_BUILD_RESULTS="$S_FP_SRC_FOLDER/bin/Linux.x86_64"
    func_mmmv_assert_folder_exists_t1 "$S_FP_SRC_FOLDER" \
        "2c44ee84-7ee5-4fe8-a34b-c071704067e7"
    #------------------------------
    # Foo/bonnet/../bin
    local SB_FP_BIN="`cd $S_FP_INSTALLATION_FOLDER/../ ; pwd`/bin"
    mkdir -p $SB_FP_BIN
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "4a3f3b74-5f90-436d-a83b-c071704067e7"
    func_mmmv_wait_and_sync_t1
    func_mmmv_assert_folder_exists_t1 "$SB_FP_BIN" \
        "4e78c961-e52d-4394-8a4a-c071704067e7"
    #------------------------------
    ln -s "$S_FP_BUILD_RESULTS/mined" "$SB_FP_BIN/mined"
    func_mmmv_assert_error_code_zero_t1 "$?" \
        "158f08f4-7030-43c3-895a-c071704067e7"
    func_mmmv_assert_file_exists_t1 "$S_FP_BUILD_RESULTS/mined" \
        "72448539-e332-4544-849a-c071704067e7"
    func_mmmv_wait_and_sync_t1
    #------------------------------
    echo ""
    echo "The location of the compiled binaries is:"
    echo -e "\e[92m    `cd $S_FP_INSTALLATION_FOLDER/../ ; pwd` \e[39m"
    echo ""
    echo "The MinEd Text Editor TUI(Text User Interface)"
    echo "might be usable also with a mouse."
    echo "Thank You for trying out this script. "
    echo ""
    #------------------------------
} # func_main
func_main

#--------------------------------------------------------------------------
cd "$S_FP_ORIG"
exit 0
#--------------------------------------------------------------------------
# S_VERSION_OF_THIS_FILE="14605b65-c1a9-4b9c-954a-c071704067e7"
#==========================================================================
