#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'
require 'rexml/document'
require 'fileutils'

require 'mmon/plugin'
require 'mmon/item'

require 'mmon/plugin/itemaclock'
require 'mmon/plugin/itemdclock'
require 'mmon/plugin/itemcal'
require 'mmon/plugin/itemcpu'
require 'mmon/plugin/itemmem'
require 'mmon/plugin/itemnet'
require 'mmon/plugin/itemtemp'
require 'mmon/plugin/itemvol'
require 'mmon/plugin/itemlauncher'

class AppMmon
    def initialize
        @item_list = []
        @plugin_list = []

        @plugin_list << Plugin.new('ItemAClock')
        @plugin_list << Plugin.new('ItemDClock')
        @plugin_list << Plugin.new('ItemCal')
        @plugin_list << Plugin.new('ItemCpu')
        @plugin_list << Plugin.new('ItemMem')
        @plugin_list << Plugin.new('ItemNet')
        @plugin_list << Plugin.new('ItemTemp')
        @plugin_list << Plugin.new('ItemVol')
        @plugin_list << Plugin.new('ItemLauncher')

        @stick = false
        @keep_above = false


        @conf_file = nil
        @plugin_dir = nil
        if ENV.key?('HOME')
            homedir = ENV['HOME']

            @conf_file = homedir + '/.mmon/mmon_conf'
            @plugin_dir = homedir + '/.mmon/plugin'

            FileUtils.mkdir_p(@plugin_dir)
        end

        check_plugin()
        
        read_conf() if FileTest.exist?(@conf_file)

        show_dialog() if @item_list.size == 0
    end

    def add_menu(menu)
        submenu = Gtk::Menu.new
        @plugin_list.each do |plugin|
            menuitem = Gtk::MenuItem.new(plugin.item_name)
            menuitem.signal_connect('activate', plugin) do |w, p|
                create_item(p)
            end
            submenu.append(menuitem)
        end
        menuitem_add = Gtk::MenuItem.new('Add Item')
        menuitem_add.set_submenu(submenu)

        menuitem_quit_mmon = Gtk::MenuItem.new('Quit mmon')
        menuitem_save = Gtk::MenuItem.new('Save')
        menuitem_quit_mmon.signal_connect('activate') { |menuitem| quit_mmon() }
        menuitem_save.signal_connect('activate') { |menuitem| write_conf() }

        menu.append(Gtk::SeparatorMenuItem.new)
        menu.append(menuitem_add)
        menu.append(menuitem_save)
        menu.append(menuitem_quit_mmon)
    end

    def quit_mmon
        puts 'quit_mmon'

        write_conf()
        
        # 配列の要素をループ中に削除するのでコピーを作ってそちらでループを回す
        item_list_tmp = @item_list.clone
        item_list_tmp.each do |item| 
            item.destroy()
        end
    end

    def setting_widget
        title = Gtk::Label.new
        title.set_markup('<big><b>Mmon</b></big>')

        cb_stick = Gtk::CheckButton.new('Stick')
        cb_stick.active = @stick
        cb_stick.signal_connect('toggled') do |w|
            @stick = w.active?
            @item_list.each do |i|
                if @stick 
                    i.stick
                else
                    i.unstick
                end
            end
        end

        cb_keep_above = Gtk::CheckButton.new('Keep Above')
        cb_keep_above.active = @keep_above
        cb_keep_above.signal_connect('toggled') do |w|
            @keep_above = w.active?
            @item_list.each do |i|
                i.keep_above = @keep_above
            end
        end

        vbox = Gtk::VBox.new
        vbox.pack_start(title, false)
        vbox.pack_start(Gtk::HSeparator.new, false)
        vbox.pack_start(cb_stick, false)
        vbox.pack_start(cb_keep_above, false)

        return vbox
    end
        
    private

    def check_plugin
        return if @plugin_dir.nil?

        Dir.glob(@plugin_dir + "*.rb") do |file|
            plugin = Plugin.new
            plugin.set_file(file)
            if plugin.valid?
                @plugin_list << plugin
            end
        end
    end

    def create_item(plugin)
        item = plugin.create_object(self)
		item.signal_connect("destroy") { |w, e| item_destroy_event(w, e) }
        item.show

        @item_list << item

        return item
    end

    def item_destroy_event(widget, event)
        #puts "item_destroy_event: #{widget.class.to_s}  #{@item_list.size.to_s}"

        @item_list.delete(widget)

        if @item_list.size.zero?
            puts 'main_quit'
            Gtk::main_quit
        end

        return false
    end

    def write_conf
        puts 'write_conf'

        File.rename(@conf_file, @conf_file + '.bak') if File.exist?(@conf_file)

        begin
            e_stick = REXML::Element.new('Stick')
            e_stick.text = @stick.to_s

            e_keep_above = REXML::Element.new('KeepAbove')
            e_keep_above.text = @keep_above.to_s

            e_item = REXML::Element.new('ItemSet')

            @item_list.each do |item|
                e = item.write_element
                e_item.add_element(e)
            end

            e_mmon = REXML::Element.new('Mmon')
            e_mmon.add_element(e_stick)
            e_mmon.add_element(e_keep_above)
            e_mmon.add_element(e_item)

            doc = REXML::Document.new
            doc.add_element(e_mmon)

            f = File.open(@conf_file, 'w')
            doc.write(f, 2)
        rescue
            p $!
        ensure
            f.close
        end
    end

    def read_conf
        begin
            f = File.open(@conf_file, 'r')
            doc = REXML::Document.new(f)

            e_item = doc.root.elements['ItemSet']
            e_item.each_element do |e|
                @plugin_list.each do |p|
                    if p.class_name == e.name 
                        item = create_item(p)
                        item.read_element(e)
                        break
                    end
                end
            end

            # 全アイテム登録後にしないと全く効かない
            e_mmon = doc.root
            @stick = Util.str_to_bool(e_mmon.elements['Stick'].text)
            @keep_above = Util.str_to_bool(e_mmon.elements['KeepAbove'].text)
            @item_list.each do |i|
                if @stick
                    i.stick
                else
                    i.unstick
                end

                i.keep_above = @keep_above
            end
        rescue
            p $!
        ensure
            f.close
        end
    end

    def show_dialog
        column_text = 0
        column_plugin = 1
		liststore = Gtk::ListStore.new(String, Plugin)

        @plugin_list.each do |plugin|
            iter = liststore.append
            iter[column_text] = plugin.item_name
            iter[column_plugin] = plugin
        end
		column = Gtk::TreeViewColumn.new("Item", Gtk::CellRendererText.new, :text => column_text)
		treeview = Gtk::TreeView.new(liststore)
		treeview.signal_connect('row-activated') do |tv, path, column|
			iter = tv.selection.selected
            newitem = create_item(iter[column_plugin])
		end
		treeview.headers_visible = false
		treeview.set_rules_hint(true)
		treeview.append_column(column)

		scroll = Gtk::ScrolledWindow.new
		scroll.set_policy(Gtk::POLICY_AUTOMATIC,Gtk::POLICY_AUTOMATIC)
		scroll.add(treeview)

        scroll.show_all

        dialog = Gtk::Dialog.new('Item List', nil, Gtk::Dialog::MODAL, [Gtk::Stock::CLOSE, Gtk::Dialog::ResponseType::CLOSE])
        dialog.vbox.pack_start(scroll)
        dialog.set_default_size(200, 300)
        dialog.run
        dialog.destroy
    end

end


if __FILE__ == $0
    app = AppMmon.new

=begin
Signal.list.each {|key, val|
    puts "#{key}  #{val}"
    
    next if val == 26

    Signal.trap(key) do |val|
        puts 'signal :' + val.to_s
    end
}
Signal.trap('SIGCHLD') do
    puts 'signal chld'
end
=end

    Gtk::main()
end


