# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

=begin

/proc/net/dev のサンプル

Inter-|   Receive                                                |  Transmit
 face |bytes    packets errs drop fifo frame compressed multicast|bytes    packets errs drop fifo colls carrier compressed
    lo:     756      14    0    0    0     0          0         0      756      14    0    0    0     0       0          0
  eth0: 3601487    3713    0    0    0     0          0         0   293704    2915    0    0    0     4       0          0

=end

class Network
    attr_reader :in, :out
    attr_accessor :in_max, :out_max

    def initialize(in_max_byte = 512000, out_max_byte = 64000)
        @in_max = in_max_byte
        @out_max = out_max_byte

        @raw_in = 0         # byte
        @raw_out = 0        # byte
        @raw_time = Time.now

        @d_in = 0
        @d_out = 0
        @d_time = 0

        @in = 0.0
        @out = 0.0

        read()
    end

    REG = /eth0:\s*(\d+)\s+\d+\s+\d+\s+\d+\s+\d+\s+\d+\s+\d+\s+\d+\s+(\d+)/

    def read
        in_old = @raw_in
        out_old = @raw_out
        time_old = @raw_time

        begin
            f = File.open('/proc/net/dev')
            f.each_line do |l|
                next unless l =~ /^  eth0/

                if REG =~ l
                    @raw_in = $1.to_i
                    @raw_out = $2.to_i
                    @raw_time = Time.now
                    #puts "row in:#{@in}  out:#{@out}"
                end
            end
        rescue
            p $!
        ensure
            f.close
        end

        @d_in = @raw_in - in_old
        @d_out = @raw_out - out_old
        @d_time = @raw_time - time_old

        @in = @d_in.to_f / (@d_time * @in_max)
        @out = @d_out.to_f / (@d_time * @out_max)
    end

    def print
         puts "byte in:#{@d_in}  out:#{@d_out} time:#{@d_time}"
         puts "\% in:#{@in}  out:#{@out}"
    end
end

if __FILE__ == $0
    net = Network.new
    sleep(1)
    net.read
    net.print
end
