# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'

class Plugin
    def initialize(class_name = nil)
        @plugin_class = Module.const_get(class_name)
    end

    def set_file(file)
        class_name = get_class_name(@file_path)
        unless class_name.nil?
            require(file)
            @plugin_class = Module.const_get(class_name)
        end
    end

    def create_object(parent)
        if @plugin_class.nil?
            return nil
        else
            return @plugin_class.new(parent)
        end
    end

    def class_name
        return @plugin_class.to_s
    end

    def item_name
        if @plugin_class.nil?
            return nil
        else
            if @plugin_class.const_defined?(:NAME)
                return @plugin_class.const_get(:NAME)
            else
                return class_name()
            end
        end
    end

    def valid?
        if @plugin_class.nil?
            return false
        else
            return true
        end
    end

    private

    def get_class_name(file)
        return nil unless FileTest.exist?(file)

        f = File.new(file)
        f.each_line do |l|
            if /class\s*(\w*)\s*<\s*Item/ =~ l
                return $1
            end
        end

        return nil
    end
end

