#!/usr/local/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'
require 'gtkglext'
require 'rexml/document'

class Cairo::Context
    @@use_alpha = false

    alias :orig_set_source_rgba :set_source_rgba

    def set_source_rgba(ar)
        set_source_rgba(ar[0], ar[1], ar[2], ar[3])
    end

    def set_source_rgba(r, g, b, a)
        #puts 'set_source_rgba'
        if @@use_alpha
            orig_set_source_rgba(r, g, b, a)
        else
            orig_set_source_rgba(r, g, b, 1.0)
        end
    end

    def self.use_alpha=(bool)
        #puts 'use_alpha ' + bool.to_s
        @@use_alpha = bool
    end
end

class GLItem < Gtk::Window
    def initialize(parent = nil)
        super(Gtk::Window::TOPLEVEL)

        @parent = parent

        @interval = 1  # sec
        @width = 65 
        @height = 65 

        @timeout_id = 0

        @bg = nil
        @cc_bg = nil

        @fg = nil
        @cc_fg = nil

        Gtk::GL.init
        @glconfig = Gdk::GLConfig.new(Gdk::GLConfig::MODE_RGB |
                                     Gdk::GLConfig::MODE_DEPTH |
                                     Gdk::GLConfig::MODE_DOUBLE)
        if !@glconfig
            @glconfig = Gdk::GLConfig.new(Gdk::GLConfig::MODE_RGBA | Gdk::GLConfig::MODE_DEPTH)
            if !@glconfig
                puts "glconfig.new error\n"
                exit 1
            end
        end

        @darea = Gtk::DrawingArea.new
#@darea.set_size_request(@width, @height)
        @darea.set_gl_capability(@glconfig)

        @darea.app_paintable = true

        self.resize(@width, @height)
        self.decorated = false
        self.skip_pager_hint = true
        self.skip_taskbar_hint = true

		self.signal_connect("destroy")           { |w, e| destroy_handler(w, e) }
        @darea.signal_connect("realize")               { |w| realize_handler(w) }
		@darea.signal_connect("expose-event")          { |w, e| expose_handler(w, e) }
		@darea.signal_connect("button-press-event")    { |w, e| button_press_handler(e) }

        self.add(@darea)

        screen = self.screen
        colormap = screen.rgba_colormap
        if colormap.nil?
            puts 'colormap is nil'
            self.colormap = screen.rgb_colormap
            Cairo::Context.use_alpha = false
        else
            puts 'colormap is not nil'
            self.colormap = colormap
            Cairo::Context.use_alpha = true
        end
    end

    # debug 用
    def force_rgb
        self.colormap = self.screen.rgb_colormap
        Cairo::Context.use_alpha = false
    end

    def destroy_handler(widget, event)
        #puts 'item destroy_handler'
        GLib::Source.remove(@timeout_id)
        Gtk::main_quit if @parent.nil?
    end

    def expose_handler(widget, event)
        x = event.area.x
        y = event.area.y
        w = event.area.width
        h = event.area.height

#        puts "expose #{x} #{y} #{w} #{h}"

        cc = self.window.create_cairo_context
=begin
        cc.rectangle(x, y, w, h)
        cc.clip
        cc.operator = Cairo::OPERATOR_CLEAR
        cc.paint

        # copy bg
        unless @bg.nil?
            cc.operator = Cairo::OPERATOR_SOURCE
            cc.set_source(@cc_bg.target, 0, 0)
            cc.paint
        end
=end

        glcontext = widget.gl_context
        gldrawable = widget.gl_drawable

        gldrawable.gl_begin(glcontext) do
            GL.Clear(GL::COLOR_BUFFER_BIT | GL::DEPTH_BUFFER_BIT)

            cc.operator = Cairo::OPERATOR_OVER
            render(cc)

        GL.LineWidth(3.0)
        GL.Color(1.0, 1.0, 0.0, 1.0)
        GL.Begin(GL::LINES)
        GL.Vertex(5.0, 5.0)
        GL.Vertex(65.0, 165.0)
        GL.End


            if gldrawable.double_buffered?
                gldrawable.swap_buffers
            else
                GL.Flush
                puts 's'
            end
        end

=begin
        # copy fg
        unless @fg.nil?
            cc.operator = Cairo::OPERATOR_OVER
            cc.set_source(@cc_fg.target, 0, 0)
            cc.paint
        end
=end

        return true
    end

    def button_press_handler(event)
        #puts "button_press #{event.button}"

        x = event.x_root
        y = event.y_root

        case event.button
        when 3 
            show_menu(event)
            return true
        end

        return false
    end

    def show_menu(event)
        x = event.x
        y = event.y

        menuitem_setting = Gtk::MenuItem.new('Settings')
        menuitem_setting.signal_connect('activate') { show_dialog(x, y) }

        if @parent.nil?
            menuitem_quit = Gtk::MenuItem.new('Quit') 
            menuitem_quit.signal_connect('activate') { self.destroy() }
        end
        menu = Gtk::Menu.new
        menu.append(menuitem_setting)
        menu.append(Gtk::SeparatorMenuItem.new)
        menu.append(menuitem_quit) if @parent.nil?
        @parent.add_menu(menu, self) unless @parent.nil?
        menu.show_all
        menu.popup(nil, nil, event.button, event.time)
    end

    def show_dialog(x, y)
        mmon = @parent.setting_widget unless @parent.nil?

        title = Gtk::Label.new
        title.set_markup('<big><b>' + self.class.to_s + '</b></big>')

        w = setting_widget(x, y)

        vbox = Gtk::VBox.new
        vbox.pack_start(title, false)
        vbox.pack_start(Gtk::HSeparator.new, false)
        vbox.pack_start(w, true) unless w.nil?

        notebook = Gtk::Notebook.new
        notebook.append_page(mmon, Gtk::Label.new('Mmon')) unless @parent.nil?
        notebook.append_page(vbox, Gtk::Label.new(self.class.to_s)) unless w.nil?

        notebook.show_all

        n = notebook.page_num(vbox)
        notebook.page = n

        dialog = Gtk::Dialog.new('Settings', nil, Gtk::Dialog::MODAL, 
                [Gtk::Stock::CLOSE, Gtk::Dialog::ResponseType::CLOSE])
        dialog.vbox.pack_start(notebook)
        dialog.set_default_size(400, 400)
        dialog.run
        dialog.destroy
    end

    def realize_handler(widget)

        puts "w:#{@width} h:#{@height}"


        size_changed()
        update()

        @timeout_id = GLib::Timeout.add(@interval * 1000) { update() }
    end

    def update()
        return if @interval == 0.0

        if prepare()
            #puts 'update interval:' + @interval.to_s
            @darea.queue_draw()
        end

        return true
    end

    def size_changed
        mask_update()
        create_bg() unless @bg.nil?
        create_fg() unless @fg.nil?

        update()

        @darea.queue_draw()
    end

    def mask_update()
#@darea.set_size_request(@width, @height)
        self.resize(@width, @height)
        @darea.window.resize(@width, @height)
#@darea.set_gl_capability(@glconfig)

        puts "mask_update w:#{@width} h:#{@height}"

        bitmap = Gdk::Pixmap.new(nil, @width, @height, 1)

        cc = bitmap.create_cairo_context
        cc.operator = Cairo::OPERATOR_CLEAR
        cc.paint
        cc.operator = Cairo::OPERATOR_SOURCE

        render_mask(cc)

#self.shape_combine_mask(bitmap, 0, 0)

        glcontext = @darea.gl_context
        gldrawable = @darea.gl_drawable
        gldrawable.gl_begin(glcontext) do
            GL.ClearColor(0.5, 0.0, 0.0, 0.2)
            GL.ClearDepth(1.0)

#GL.Disable(GL::DEPTH_TEST)
#GL.Disable(GL::LIGHTING)

            GL.Enable(GL::BLEND)
            GL.BlendFunc(GL::SRC_ALPHA, GL::ONE_MINUS_SRC_ALPHA)

    p @width
    p @height
    p gldrawable.size
            GL.Viewport(0, 0, @width, @height)

            GL.MatrixMode(GL::PROJECTION)
            GL.LoadIdentity

            GL.Ortho(0.0, @width, 0.0, @height, -1.0, 1.0)

            GL.MatrixMode(GL::MODELVIEW)
            GL.LoadIdentity
        end
    end

    def bg_update
        @cc_bg = Cairo::Context.new(@bg)
        @cc_bg.operator = Cairo::OPERATOR_CLEAR
        @cc_bg.paint
        @cc_bg.operator = Cairo::OPERATOR_SOURCE

        render_bg(@cc_bg)
    end

    def create_bg()
        @bg = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, @width, @height)

        bg_update()
    end

    def fg_update
        @cc_fg = Cairo::Context.new(@fg)
        @cc_fg.operator = Cairo::OPERATOR_CLEAR
        @cc_fg.paint
        @cc_fg.operator = Cairo::OPERATOR_SOURCE

        render_fg(@cc_fg)
    end

    def create_fg()
        @fg = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, @width, @height)

        fg_update()
    end

    def read_element(e)
        x = e.elements['x'].text.to_i
        y = e.elements['y'].text.to_i
        
        self.move(x, y)

        read_element_local(e)
    end

    def write_element
        x, y = self.position

        e = REXML::Element.new(self.class.to_s)
        
        e_x = REXML::Element.new('x')
        e_x.text = x.to_s

        e_y = REXML::Element.new('y')
        e_y.text = y.to_s

        e.add_element(e_x)
        e.add_element(e_y)

        write_element_local(e)

        return e
    end

    private

    def prepare
        return true
    end

    def render_bg(cc)
        puts 'render_bg'
        cc.set_source_rgba(0.0, 1.0, 0.0, 0.8)
        cc.paint
    end

    def render_fg(cc)
        puts 'render_fg'
        cc.set_source_rgba(0.0, 0.0, 1.0, 0.8)
        cc.paint
    end

    def render(cc)
        puts 'render'
        #cc.set_source_rgba(1.0, 0.0, 0.0, 0.8)
        #cc.paint

        GL.LineWidth(3.0)
        GL.Color(0.0, 1.0, 0.0, 1.0)
        GL.Begin(GL::LINES)
        GL.Vertex(5.0, 5.0)
        GL.Vertex(65.0, 65.0)
        GL.End
    end

    def render_mask(cc)
        cc.operator = Cairo::OPERATOR_SOURCE
        cc.paint
    end

    def read_element_local(e)
    end
    
    def write_element_local(e)
    end

    def setting_widget(x, y)
        return nil
    end
end
    
if __FILE__ == $0
    item = GLItem.new
    item.show_all

    Gtk::main()
end
