#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'

class ItemAClock < Item
    include Math

    NAME = 'Analog Clock'

    def initialize(parent = nil)
        super(parent)

        @item_name = 'Analog Clock'
        @interval = 5.0
        @use_bg = true
        self.set_item_size(72, 72)

        @now = Time.now
    end

    private

    def render_mask(cc, w, h)
        cc.arc(w / 2.0, h / 2.0, h / 2.0, 0.0, 2 * PI)
        cc.fill
    end

    def render_bg(cc, w, h)
        x0 = w / 2.0
        y0 = h / 2.0
        r0 = x0

        cc.arc(x0, y0, r0, 0.0, 2 * PI)
        cc.set_source_rgba(0.5, 0.5, 0.5, 0.8)
        cc.fill

        cc.arc(x0, y0, 0.97 * r0, 0.0, 2.0 * PI)
        cc.set_line_width(0.03 * w)
        cc.set_line_cap(Cairo::LINE_CAP_ROUND)
        cc.set_source_rgba(0.7, 0.7, 0.7, 1.0)
        cc.stroke

        r = 0.86 * x0

        12.times do |i|
            radian = 2.0 * PI * i / 12
            x = r * sin(radian)
            y = r * cos(radian)

            cc.arc(x0 + x, y0 - y, 0.02 * w, 0.0, 2.0 * PI)
            cc.set_source_rgb(0.7, 0.7, 0.0)
            cc.fill
        end
    end

    def render(cc, w, h)
        hour = @now.hour
        min = @now.min
        sec = @now.sec

        cc.scale(w, h)
        cc.set_line_cap(Cairo::LINE_CAP_ROUND)

        # hour
        rad = 2.0 * PI * (hour * 3600.0 + min * 60.0 + sec) / (12.0 * 3600.0);
        x = 0.30 * sin(rad);
        y = 0.30 * cos(rad);
        cc.set_line_width(0.06)
        cc.set_source_rgba(0.9, 0.9, 0.0, 0.6)
        cc.move_to(0.5, 0.5)
        cc.line_to(0.5 + x, 0.5 - y)
        cc.stroke

        # min
        rad = 2.0 * PI * (min * 60.0 + sec) / 3600.0;
        x = 0.43 * sin(rad);
        y = 0.43 * cos(rad);
        cc.set_line_width(0.05);
        cc.set_source_rgba(1.0, 1.0, 0.0, 0.8)
        cc.move_to(0.5, 0.5)
        cc.line_to(0.5 + x, 0.5 - y)
        cc.stroke
=begin        
        # sec
        rad = 2.0 * PI * sec / 60.0;
        x = 0.45 * sin(rad);
        y = 0.45 * cos(rad);
        cc.set_line_width(0.01)
        cc.set_source_rgba(0.5, 0.5, 0.5, 0.7)
        cc.move_to(0.5, 0.5)
        cc.line_to(0.5 + x, 0.5 - y)
        cc.stroke
=end
    end

    def prepare
        old = @now
        @now = Time.now

        return true
    end
end

if __FILE__ == $0
    item = ItemAClock.new
    p ItemAClock.const_get(:NAME)
    item.show

    Gtk::main()
end
