#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'

class ItemCal < Item
    NAME = 'Calendar'

    def initialize(parent = nil)
        super(parent)

        @interval = 2.0
        @use_bg = true
        self.set_item_size(72, 32)

        @wtext = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']
        #@wtext = ['日', '月', '火', '水', '木', '金', '土']

        @now = Time.now
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
        ym = @now.strftime('%Y/%m')
        d = @now.strftime('%d')
        wd = @wtext[@now.wday]

        puts "cal w:#{w} h:#{h} #{ym} #{d} #{wd}"

        cc.operator = Cairo::OPERATOR_SOURCE

        cc.select_font_face("Bitstream Vera Sans", Cairo::FONT_SLANT_NORMAL, Cairo::FONT_WEIGHT_BOLD);
        cc.set_source_rgb(1.0, 1.0, 0.0);

        cc.set_font_size(11)
        extents = cc.text_extents(ym)
        yx = 0.5 * w - (extents.width / 2 + extents.x_bearing)
        yy = 0.37 * h
        cc.move_to(yx, yy)
        cc.show_text(ym);

        cc.set_font_size(14)
        extents = cc.text_extents(d)
        dx = 0.72 * w - (extents.width / 2)
        dy = 0.87 * h
        #Util.show_extents(extents)
        cc.move_to(dx, dy)
        cc.show_text(d);

        cc.set_font_size(11)
        extents = cc.text_extents(wd)
        wx = 0.3 * w - (extents.width / 2)
        wy = 0.85* h
        cc.move_to(wx, wy)
        cc.show_text(wd)
    end

    def prepare
        old = @now
        @now = Time.now

        if old.day != @now.day
            return true
        else 
            return false
        end
    end
end

if __FILE__ == $0
    item = ItemCal.new
    item.show

    Gtk::main()
end
